/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.AaBox;
import com.github.stephengold.joltjni.BodyCreationSettings;
import com.github.stephengold.joltjni.BodyManager;
import com.github.stephengold.joltjni.CollisionGroup;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.MotionProperties;
import com.github.stephengold.joltjni.NonCopyable;
import com.github.stephengold.joltjni.PhysicsSystem;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RMat44;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Shape;
import com.github.stephengold.joltjni.SoftBodyCreationSettings;
import com.github.stephengold.joltjni.SoftBodyMotionProperties;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.TransformedShape;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EBodyType;
import com.github.stephengold.joltjni.enumerate.EMotionType;
import com.github.stephengold.joltjni.readonly.ConstAaBox;
import com.github.stephengold.joltjni.readonly.ConstBody;
import com.github.stephengold.joltjni.readonly.ConstCollisionGroup;
import com.github.stephengold.joltjni.readonly.ConstShape;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public class Body
extends NonCopyable
implements ConstBody {
    Body(JoltPhysicsObject container, long bodyVa) {
        super(container, bodyVa);
        assert (container instanceof PhysicsSystem || container instanceof BodyManager);
    }

    public Body(long bodyVa) {
        this.setVirtualAddress(bodyVa);
    }

    public void addAngularImpulse(Vec3Arg impulse) {
        long bodyVa = this.va();
        float x = impulse.getX();
        float y = impulse.getY();
        float z = impulse.getZ();
        Body.addAngularImpulse(bodyVa, x, y, z);
    }

    public void addForce(Vec3Arg force) {
        long bodyVa = this.va();
        float fx = force.getX();
        float fy = force.getY();
        float fz = force.getZ();
        Body.addForce(bodyVa, fx, fy, fz);
    }

    public void addForce(Vec3Arg force, RVec3Arg location) {
        long bodyVa = this.va();
        float fx = force.getX();
        float fy = force.getY();
        float fz = force.getZ();
        double locX = location.xx();
        double locY = location.yy();
        double locZ = location.zz();
        Body.addForce(bodyVa, fx, fy, fz, locX, locY, locZ);
    }

    public void addImpulse(float jx, float jy, float jz) {
        long bodyVa = this.va();
        Body.addImpulse(bodyVa, jx, jy, jz);
    }

    public void addImpulse(Vec3Arg impulse) {
        long bodyVa = this.va();
        float jx = impulse.getX();
        float jy = impulse.getY();
        float jz = impulse.getZ();
        Body.addImpulse(bodyVa, jx, jy, jz);
    }

    public void addImpulse(Vec3Arg impulse, RVec3Arg location) {
        long bodyVa = this.va();
        float jx = impulse.getX();
        float jy = impulse.getY();
        float jz = impulse.getZ();
        double locX = location.xx();
        double locY = location.yy();
        double locZ = location.zz();
        Body.addImpulse(bodyVa, jx, jy, jz, locX, locY, locZ);
    }

    public void addTorque(Vec3Arg torque) {
        long bodyVa = this.va();
        float x = torque.getX();
        float y = torque.getY();
        float z = torque.getZ();
        Body.addTorque(bodyVa, x, y, z);
    }

    public boolean applyBuoyancyImpulse(RVec3Arg surfacePosition, Vec3Arg surfaceNormal, float buoyancy, float linearDrag, float angularDrag, Vec3Arg fluidVelocity, Vec3Arg gravity, float deltaTime) {
        long bodyVa = this.va();
        double surfaceX = surfacePosition.xx();
        double surfaceY = surfacePosition.yy();
        double surfaceZ = surfacePosition.zz();
        float nx = surfaceNormal.getX();
        float ny = surfaceNormal.getY();
        float nz = surfaceNormal.getZ();
        float vx = fluidVelocity.getX();
        float vy = fluidVelocity.getY();
        float vz = fluidVelocity.getZ();
        float gravityX = fluidVelocity.getX();
        float gravityY = fluidVelocity.getY();
        float gravityZ = fluidVelocity.getZ();
        boolean result = Body.applyBuoyancyImpulse(bodyVa, surfaceX, surfaceY, surfaceZ, nx, ny, nz, buoyancy, linearDrag, angularDrag, vx, vy, vz, gravityX, gravityY, gravityZ, deltaTime);
        return result;
    }

    public void moveKinematic(RVec3Arg location, QuatArg orientation, float deltaTime) {
        long bodyVa = this.va();
        double xx = location.xx();
        double yy = location.yy();
        double zz = location.zz();
        float qw = orientation.getW();
        float qx = orientation.getX();
        float qy = orientation.getY();
        float qz = orientation.getZ();
        Body.moveKinematic(bodyVa, xx, yy, zz, qx, qy, qz, qw, deltaTime);
    }

    public void resetSleepTimer() {
        long bodyVa = this.va();
        Body.resetSleepTimer(bodyVa);
    }

    public void setAllowSleeping(boolean allow) {
        long bodyVa = this.va();
        Body.setAllowSleeping(bodyVa, allow);
    }

    public void setAngularVelocity(float wx, float wy, float wz) {
        long bodyVa = this.va();
        Body.setAngularVelocity(bodyVa, wx, wy, wz);
    }

    public void setAngularVelocity(Vec3Arg omega) {
        float wx = omega.getX();
        float wy = omega.getY();
        float wz = omega.getZ();
        this.setAngularVelocity(wx, wy, wz);
    }

    public void setAngularVelocityClamped(Vec3Arg omega) {
        long bodyVa = this.va();
        float wx = omega.getX();
        float wy = omega.getY();
        float wz = omega.getZ();
        Body.setAngularVelocityClamped(bodyVa, wx, wy, wz);
    }

    public void setCollisionGroup(ConstCollisionGroup group) {
        long bodyVa = this.va();
        long groupVa = group.targetVa();
        Body.setCollisionGroup(bodyVa, groupVa);
    }

    public void setEnhancedInternalEdgeRemoval(boolean enhance) {
        long bodySettingsVa = this.va();
        Body.setEnhancedInternalEdgeRemoval(bodySettingsVa, enhance);
    }

    public void setFriction(float friction) {
        long bodyVa = this.va();
        Body.setFriction(bodyVa, friction);
    }

    public void setIsSensor(boolean setting) {
        long bodyVa = this.va();
        Body.setIsSensor(bodyVa, setting);
    }

    public void setLinearVelocity(float vx, float vy, float vz) {
        long bodyVa = this.va();
        Body.setLinearVelocity(bodyVa, vx, vy, vz);
    }

    public void setLinearVelocity(Vec3Arg velocity) {
        float vx = velocity.getX();
        float vy = velocity.getY();
        float vz = velocity.getZ();
        this.setLinearVelocity(vx, vy, vz);
    }

    public void setLinearVelocityClamped(Vec3Arg velocity) {
        long bodyVa = this.va();
        float vx = velocity.getX();
        float vy = velocity.getY();
        float vz = velocity.getZ();
        Body.setLinearVelocityClamped(bodyVa, vx, vy, vz);
    }

    public void setMotionType(EMotionType motionType) {
        long bodyVa = this.va();
        int ordinal = motionType.ordinal();
        Body.setMotionType(bodyVa, ordinal);
    }

    public void setPositionAndRotationInternal(RVec3Arg location, QuatArg orientation) {
        this.setPositionAndRotationInternal(location, orientation, true);
    }

    public void setPositionAndRotationInternal(RVec3Arg location, QuatArg orientation, boolean resetSleepTimer) {
        long bodyVa = this.va();
        double locX = location.xx();
        double locY = location.yy();
        double locZ = location.zz();
        float qw = orientation.getW();
        float qx = orientation.getX();
        float qy = orientation.getY();
        float qz = orientation.getZ();
        Body.setPositionAndRotationInternal(bodyVa, locX, locY, locZ, qx, qy, qz, qw, resetSleepTimer);
    }

    public void setRestitution(float restitution) {
        long bodyVa = this.va();
        Body.setRestitution(bodyVa, restitution);
    }

    public void setUserData(long value) {
        long bodyVa = this.va();
        Body.setUserData(bodyVa, value);
    }

    public static Body sFixedToWorld() {
        long bodyVa = Body.createFixedToWorld();
        Body result = new Body(bodyVa);
        return result;
    }

    @Override
    public boolean canBeKinematicOrDynamic() {
        long bodyVa = this.va();
        boolean result = Body.canBeKinematicOrDynamic(bodyVa);
        return result;
    }

    @Override
    public Vec3 getAccumulatedForce() {
        long bodyVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        Body.getAccumulatedForce(bodyVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public Vec3 getAccumulatedTorque() {
        long bodyVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        Body.getAccumulatedTorque(bodyVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public boolean getAllowSleeping() {
        long bodyVa = this.va();
        boolean result = Body.getAllowSleeping(bodyVa);
        return result;
    }

    @Override
    public Vec3 getAngularVelocity() {
        long bodyVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        Body.getAngularVelocity(bodyVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public BodyCreationSettings getBodyCreationSettings() {
        long bodyVa = this.va();
        assert (Body.isRigidBody(bodyVa)) : "not a rigid body";
        long bodySettingsVa = Body.getBodyCreationSettings(bodyVa);
        BodyCreationSettings result = new BodyCreationSettings(bodySettingsVa, true);
        return result;
    }

    @Override
    public EBodyType getBodyType() {
        long bodyVa = this.va();
        int ordinal = Body.getBodyType(bodyVa);
        EBodyType result = EBodyType.values()[ordinal];
        return result;
    }

    @Override
    public int getBroadPhaseLayer() {
        long bodyVa = this.va();
        int result = Body.getBroadPhaseLayer(bodyVa);
        return result;
    }

    @Override
    public RVec3 getCenterOfMassPosition() {
        long bodyVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        Body.getCenterOfMassPositionToBuf(bodyVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        assert (Double.isFinite(result.xx())) : "xx = " + result.xx();
        assert (Double.isFinite(result.yy())) : "yy = " + result.yy();
        assert (Double.isFinite(result.zz())) : "zz = " + result.zz();
        return result;
    }

    @Override
    public void getCenterOfMassPosition(DoubleBuffer storeResult) {
        long bodyVa = this.va();
        Body.getCenterOfMassPositionToBuf(bodyVa, storeResult);
    }

    @Override
    public void getCenterOfMassPosition(RVec3 storeLocation) {
        long bodyVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        Body.getCenterOfMassPositionToBuf(bodyVa, storeDoubles);
        storeLocation.set(storeDoubles);
        assert (Double.isFinite(storeLocation.xx())) : "xx = " + storeLocation.xx();
        assert (Double.isFinite(storeLocation.yy())) : "yy = " + storeLocation.yy();
        assert (Double.isFinite(storeLocation.zz())) : "zz = " + storeLocation.zz();
    }

    @Override
    public RMat44 getCenterOfMassTransform() {
        long bodyVa = this.va();
        long matrixVa = Body.getCenterOfMassTransform(bodyVa);
        RMat44 result = new RMat44(matrixVa, true);
        return result;
    }

    @Override
    public CollisionGroup getCollisionGroup() {
        long bodyVa = this.va();
        long groupVa = Body.getCollisionGroup(bodyVa);
        JoltPhysicsObject container = this.getContainingObject();
        CollisionGroup result = new CollisionGroup(container, groupVa);
        return result;
    }

    @Override
    public boolean getEnhancedInternalEdgeRemoval() {
        long bodySettingsVa = this.va();
        boolean result = Body.getEnhancedInternalEdgeRemoval(bodySettingsVa);
        return result;
    }

    @Override
    public float getFriction() {
        long bodyVa = this.va();
        float result = Body.getFriction(bodyVa);
        return result;
    }

    @Override
    public int getId() {
        long bodyVa = this.va();
        int result = Body.getId(bodyVa);
        return result;
    }

    @Override
    public RMat44 getInverseCenterOfMassTransform() {
        long bodyVa = this.va();
        long matrixVa = Body.getInverseCenterOfMassTransform(bodyVa);
        RMat44 result = new RMat44(matrixVa, true);
        return result;
    }

    @Override
    public Vec3 getLinearVelocity() {
        long bodyVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        Body.getLinearVelocity(bodyVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public MotionProperties getMotionProperties() {
        MotionProperties result;
        long bodyVa = this.va();
        if (Body.isStatic(bodyVa)) {
            result = null;
        } else {
            long propertiesVa = Body.getMotionProperties(bodyVa);
            JoltPhysicsObject container = this.getContainingObject();
            result = Body.isSoftBody(bodyVa) ? new SoftBodyMotionProperties(container, propertiesVa) : new MotionProperties(container, propertiesVa);
        }
        return result;
    }

    @Override
    public EMotionType getMotionType() {
        long bodyVa = this.va();
        int ordinal = Body.getMotionType(bodyVa);
        EMotionType result = EMotionType.values()[ordinal];
        return result;
    }

    @Override
    public int getObjectLayer() {
        long bodyVa = this.va();
        int result = Body.getObjectLayer(bodyVa);
        return result;
    }

    @Override
    public RVec3 getPosition() {
        long bodyVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        Body.getPosition(bodyVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        assert (Double.isFinite(result.xx())) : "xx = " + result.xx();
        assert (Double.isFinite(result.yy())) : "yy = " + result.yy();
        assert (Double.isFinite(result.zz())) : "zz = " + result.zz();
        return result;
    }

    @Override
    public void getPositionAndRotation(RVec3 storeLocation, Quat storeOrientation) {
        long bodyVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        Body.getPosition(bodyVa, storeDoubles);
        Body.getRotation(bodyVa, storeFloats);
        storeLocation.set(storeDoubles);
        storeOrientation.set(storeFloats);
    }

    @Override
    public float getRestitution() {
        long bodyVa = this.va();
        float result = Body.getRestitution(bodyVa);
        return result;
    }

    @Override
    public Quat getRotation() {
        long bodyVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        Body.getRotation(bodyVa, storeFloats);
        Quat result = new Quat(storeFloats);
        return result;
    }

    @Override
    public ConstShape getShape() {
        long bodyVa = this.va();
        long shapeVa = Body.getShape(bodyVa);
        Shape result = Shape.newShape(shapeVa);
        return result;
    }

    @Override
    public SoftBodyCreationSettings getSoftBodyCreationSettings() {
        long bodyVa = this.va();
        assert (Body.isSoftBody(bodyVa)) : "not a soft body";
        long settingsVa = Body.getSoftBodyCreationSettings(bodyVa);
        SoftBodyCreationSettings result = new SoftBodyCreationSettings(settingsVa, true);
        return result;
    }

    @Override
    public TransformedShape getTransformedShape() {
        long bodyVa = this.va();
        long shapeVa = Body.getTransformedShape(bodyVa);
        TransformedShape result = new TransformedShape(shapeVa, true);
        return result;
    }

    @Override
    public long getUserData() {
        long bodyVa = this.va();
        long result = Body.getUserData(bodyVa);
        return result;
    }

    @Override
    public ConstAaBox getWorldSpaceBounds() {
        long bodyVa = this.va();
        long boxVa = Body.getWorldSpaceBounds(bodyVa);
        JoltPhysicsObject container = this.getContainingObject();
        AaBox result = new AaBox(container, boxVa);
        return result;
    }

    @Override
    public Vec3 getWorldSpaceSurfaceNormal(int subShapeId, RVec3Arg location) {
        long bodyVa = this.va();
        double xx = location.xx();
        double yy = location.yy();
        double zz = location.zz();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        Body.getWorldSpaceSurfaceNormal(bodyVa, subShapeId, xx, yy, zz, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public RMat44 getWorldTransform() {
        long bodyVa = this.va();
        long matrixVa = Body.getWorldTransform(bodyVa);
        RMat44 result = new RMat44(matrixVa, true);
        return result;
    }

    @Override
    public boolean isActive() {
        long bodyVa = this.va();
        boolean result = Body.isActive(bodyVa);
        return result;
    }

    @Override
    public boolean isDynamic() {
        long bodyVa = this.va();
        boolean result = Body.isDynamic(bodyVa);
        return result;
    }

    @Override
    public boolean isInBroadPhase() {
        long bodyVa = this.va();
        boolean result = Body.isInBroadPhase(bodyVa);
        return result;
    }

    @Override
    public boolean isKinematic() {
        long bodyVa = this.va();
        boolean result = Body.isKinematic(bodyVa);
        return result;
    }

    @Override
    public boolean isRigidBody() {
        long bodyVa = this.va();
        boolean result = Body.isRigidBody(bodyVa);
        return result;
    }

    @Override
    public boolean isSensor() {
        long bodyVa = this.va();
        boolean result = Body.isSensor(bodyVa);
        return result;
    }

    @Override
    public boolean isSoftBody() {
        long bodyVa = this.va();
        boolean result = Body.isSoftBody(bodyVa);
        return result;
    }

    @Override
    public boolean isStatic() {
        long bodyVa = this.va();
        boolean result = Body.isStatic(bodyVa);
        return result;
    }

    private static native void addAngularImpulse(long var0, float var2, float var3, float var4);

    private static native void addForce(long var0, float var2, float var3, float var4);

    private static native void addForce(long var0, float var2, float var3, float var4, double var5, double var7, double var9);

    private static native void addImpulse(long var0, float var2, float var3, float var4);

    private static native void addImpulse(long var0, float var2, float var3, float var4, double var5, double var7, double var9);

    private static native void addTorque(long var0, float var2, float var3, float var4);

    private static native boolean applyBuoyancyImpulse(long var0, double var2, double var4, double var6, float var8, float var9, float var10, float var11, float var12, float var13, float var14, float var15, float var16, float var17, float var18, float var19, float var20);

    private static native boolean canBeKinematicOrDynamic(long var0);

    private static native long createFixedToWorld();

    private static native void getAccumulatedForce(long var0, FloatBuffer var2);

    private static native void getAccumulatedTorque(long var0, FloatBuffer var2);

    private static native boolean getAllowSleeping(long var0);

    private static native void getAngularVelocity(long var0, FloatBuffer var2);

    private static native long getBodyCreationSettings(long var0);

    private static native int getBodyType(long var0);

    private static native int getBroadPhaseLayer(long var0);

    private static native void getCenterOfMassPositionToBuf(long var0, DoubleBuffer var2);

    private static native long getCenterOfMassTransform(long var0);

    private static native long getCollisionGroup(long var0);

    private static native boolean getEnhancedInternalEdgeRemoval(long var0);

    private static native float getFriction(long var0);

    static native int getId(long var0);

    private static native long getInverseCenterOfMassTransform(long var0);

    private static native void getLinearVelocity(long var0, FloatBuffer var2);

    private static native long getMotionProperties(long var0);

    private static native int getMotionType(long var0);

    private static native int getObjectLayer(long var0);

    private static native void getPosition(long var0, DoubleBuffer var2);

    private static native float getRestitution(long var0);

    private static native void getRotation(long var0, FloatBuffer var2);

    private static native long getShape(long var0);

    private static native long getSoftBodyCreationSettings(long var0);

    private static native long getTransformedShape(long var0);

    private static native long getUserData(long var0);

    private static native long getWorldSpaceBounds(long var0);

    private static native void getWorldSpaceSurfaceNormal(long var0, int var2, double var3, double var5, double var7, FloatBuffer var9);

    private static native long getWorldTransform(long var0);

    private static native boolean isActive(long var0);

    private static native boolean isDynamic(long var0);

    private static native boolean isInBroadPhase(long var0);

    private static native boolean isKinematic(long var0);

    private static native boolean isRigidBody(long var0);

    private static native boolean isSensor(long var0);

    static native boolean isSoftBody(long var0);

    private static native boolean isStatic(long var0);

    private static native void moveKinematic(long var0, double var2, double var4, double var6, float var8, float var9, float var10, float var11, float var12);

    private static native void resetSleepTimer(long var0);

    private static native void setAllowSleeping(long var0, boolean var2);

    private static native void setAngularVelocity(long var0, float var2, float var3, float var4);

    private static native void setAngularVelocityClamped(long var0, float var2, float var3, float var4);

    private static native void setCollisionGroup(long var0, long var2);

    private static native void setEnhancedInternalEdgeRemoval(long var0, boolean var2);

    private static native void setFriction(long var0, float var2);

    private static native void setIsSensor(long var0, boolean var2);

    private static native void setLinearVelocity(long var0, float var2, float var3, float var4);

    private static native void setLinearVelocityClamped(long var0, float var2, float var3, float var4);

    private static native void setMotionType(long var0, int var2);

    private static native void setPositionAndRotationInternal(long var0, double var2, double var4, double var6, float var8, float var9, float var10, float var11, boolean var12);

    private static native void setRestitution(long var0, float var2);

    private static native void setUserData(long var0, long var2);
}

