/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.BcsResult;
import com.github.stephengold.joltjni.CollisionGroup;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.MassProperties;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Shape;
import com.github.stephengold.joltjni.ShapeRef;
import com.github.stephengold.joltjni.ShapeResult;
import com.github.stephengold.joltjni.ShapeSettings;
import com.github.stephengold.joltjni.StreamIn;
import com.github.stephengold.joltjni.StreamOut;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EMotionQuality;
import com.github.stephengold.joltjni.enumerate.EMotionType;
import com.github.stephengold.joltjni.enumerate.EOverrideMassProperties;
import com.github.stephengold.joltjni.readonly.ConstBodyCreationSettings;
import com.github.stephengold.joltjni.readonly.ConstCollisionGroup;
import com.github.stephengold.joltjni.readonly.ConstMassProperties;
import com.github.stephengold.joltjni.readonly.ConstShape;
import com.github.stephengold.joltjni.readonly.ConstShapeSettings;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import com.github.stephengold.joltjni.streamutils.GroupFilterToIdMap;
import com.github.stephengold.joltjni.streamutils.IdToGroupFilterMap;
import com.github.stephengold.joltjni.streamutils.IdToMaterialMap;
import com.github.stephengold.joltjni.streamutils.IdToShapeMap;
import com.github.stephengold.joltjni.streamutils.MaterialToIdMap;
import com.github.stephengold.joltjni.streamutils.ShapeToIdMap;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public class BodyCreationSettings
extends JoltPhysicsObject
implements ConstBodyCreationSettings {
    public BodyCreationSettings() {
        long bodySettingsVa = BodyCreationSettings.createDefault();
        this.setVirtualAddress(bodySettingsVa, () -> BodyCreationSettings.free(bodySettingsVa));
    }

    public BodyCreationSettings(ConstBodyCreationSettings original) {
        long originalVa = original.targetVa();
        long copyVa = BodyCreationSettings.createCopy(originalVa);
        this.setVirtualAddress(copyVa, () -> BodyCreationSettings.free(copyVa));
    }

    public BodyCreationSettings(ConstShape shape, RVec3Arg loc, QuatArg orient, EMotionType motionType, int objLayer) {
        long shapeVa = shape.targetVa();
        int motionTypeOrdinal = motionType.ordinal();
        long bodySettingsVa = BodyCreationSettings.createFromShape(shapeVa, loc.xx(), loc.yy(), loc.zz(), orient.getX(), orient.getY(), orient.getZ(), orient.getW(), motionTypeOrdinal, objLayer);
        this.setVirtualAddress(bodySettingsVa, () -> BodyCreationSettings.free(bodySettingsVa));
    }

    public BodyCreationSettings(ConstShapeSettings shapeSettings, RVec3Arg loc, QuatArg orient, EMotionType motionType, int objLayer) {
        long shapeSettingsVa = shapeSettings.targetVa();
        int motionTypeOrdinal = motionType.ordinal();
        long bodySettingsVa = BodyCreationSettings.createFromShapeSettings(shapeSettingsVa, loc.xx(), loc.yy(), loc.zz(), orient.getX(), orient.getY(), orient.getZ(), orient.getW(), motionTypeOrdinal, objLayer);
        this.setVirtualAddress(bodySettingsVa, () -> BodyCreationSettings.free(bodySettingsVa));
    }

    BodyCreationSettings(JoltPhysicsObject container, long bodySettingsVa) {
        super(container, bodySettingsVa);
    }

    BodyCreationSettings(long bodySettingsVa, boolean owner) {
        Runnable freeingAction = owner ? () -> BodyCreationSettings.free(bodySettingsVa) : null;
        this.setVirtualAddress(bodySettingsVa, freeingAction);
    }

    public BodyCreationSettings(ShapeRef shapeRef, RVec3Arg loc, QuatArg orient, EMotionType motionType, int objLayer) {
        this(shapeRef.getPtr(), loc, orient, motionType, objLayer);
    }

    public ShapeResult convertShapeSettings() {
        long bodySettingsVa = this.va();
        long resultVa = BodyCreationSettings.convertShapeSettings(bodySettingsVa);
        ShapeResult result = new ShapeResult(resultVa, true);
        return result;
    }

    public void restoreBinaryState(StreamIn stream) {
        long bodySettingsVa = this.va();
        long streamVa = stream.va();
        BodyCreationSettings.restoreBinaryState(bodySettingsVa, streamVa);
    }

    public BodyCreationSettings setAllowDynamicOrKinematic(boolean setting) {
        long bodySettingsVa = this.va();
        BodyCreationSettings.setAllowDynamicOrKinematic(bodySettingsVa, setting);
        return this;
    }

    public BodyCreationSettings setAllowedDofs(int bitmask) {
        long bodySettingsVa = this.va();
        BodyCreationSettings.setAllowedDofs(bodySettingsVa, bitmask);
        return this;
    }

    public BodyCreationSettings setAllowSleeping(boolean allow) {
        long bodySettingsVa = this.va();
        BodyCreationSettings.setAllowSleeping(bodySettingsVa, allow);
        return this;
    }

    public BodyCreationSettings setAngularDamping(float damping) {
        long bodySettingsVa = this.va();
        BodyCreationSettings.setAngularDamping(bodySettingsVa, damping);
        return this;
    }

    public BodyCreationSettings setAngularVelocity(float wx, float wy, float wz) {
        long bodySettingsVa = this.va();
        BodyCreationSettings.setAngularVelocity(bodySettingsVa, wx, wy, wz);
        return this;
    }

    public BodyCreationSettings setAngularVelocity(Vec3Arg omega) {
        float wx = omega.getX();
        float wy = omega.getY();
        float wz = omega.getZ();
        this.setAngularVelocity(wx, wy, wz);
        return this;
    }

    public BodyCreationSettings setApplyGyroscopicForce(boolean setting) {
        long bodySettingsVa = this.va();
        BodyCreationSettings.setApplyGyroscopicForce(bodySettingsVa, setting);
        return this;
    }

    public BodyCreationSettings setCollideKinematicVsNonDynamic(boolean setting) {
        long bodySettingsVa = this.va();
        BodyCreationSettings.setCollideKinematicVsNonDynamic(bodySettingsVa, setting);
        return this;
    }

    public BodyCreationSettings setCollisionGroup(ConstCollisionGroup group) {
        long bodySettingsVa = this.va();
        long groupVa = group.targetVa();
        BodyCreationSettings.setCollisionGroup(bodySettingsVa, groupVa);
        return this;
    }

    public BodyCreationSettings setEnhancedInternalEdgeRemoval(boolean enhance) {
        long bodySettingsVa = this.va();
        BodyCreationSettings.setEnhancedInternalEdgeRemoval(bodySettingsVa, enhance);
        return this;
    }

    public BodyCreationSettings setFriction(float friction) {
        long bodySettingsVa = this.va();
        BodyCreationSettings.setFriction(bodySettingsVa, friction);
        return this;
    }

    public BodyCreationSettings setGravityFactor(float factor) {
        long bodySettingsVa = this.va();
        BodyCreationSettings.setGravityFactor(bodySettingsVa, factor);
        return this;
    }

    public BodyCreationSettings setInertiaMultiplier(float factor) {
        long bodySettingsVa = this.va();
        BodyCreationSettings.setInertiaMultiplier(bodySettingsVa, factor);
        return this;
    }

    public BodyCreationSettings setIsSensor(boolean setting) {
        long bodySettingsVa = this.va();
        BodyCreationSettings.setIsSensor(bodySettingsVa, setting);
        return this;
    }

    public BodyCreationSettings setLinearDamping(float damping) {
        long bodySettingsVa = this.va();
        BodyCreationSettings.setLinearDamping(bodySettingsVa, damping);
        return this;
    }

    public BodyCreationSettings setLinearVelocity(float vx, float vy, float vz) {
        long bodySettingsVa = this.va();
        BodyCreationSettings.setLinearVelocity(bodySettingsVa, vx, vy, vz);
        return this;
    }

    public BodyCreationSettings setLinearVelocity(Vec3Arg velocity) {
        float vx = velocity.getX();
        float vy = velocity.getY();
        float vz = velocity.getZ();
        this.setLinearVelocity(vx, vy, vz);
        return this;
    }

    public BodyCreationSettings setMassPropertiesOverride(ConstMassProperties properties) {
        long bodySettingsVa = this.va();
        long propertiesVa = properties.targetVa();
        BodyCreationSettings.setMassPropertiesOverride(bodySettingsVa, propertiesVa);
        return this;
    }

    public BodyCreationSettings setMaxAngularVelocity(float maxSpeed) {
        long bodySettingsVa = this.va();
        BodyCreationSettings.setMaxAngularVelocity(bodySettingsVa, maxSpeed);
        return this;
    }

    public BodyCreationSettings setMaxLinearVelocity(float maxSpeed) {
        long bodySettingsVa = this.va();
        BodyCreationSettings.setMaxLinearVelocity(bodySettingsVa, maxSpeed);
        return this;
    }

    public BodyCreationSettings setMotionQuality(EMotionQuality motionQuality) {
        long bodySettingsVa = this.va();
        int motionQualityOrdinal = motionQuality.ordinal();
        BodyCreationSettings.setMotionQuality(bodySettingsVa, motionQualityOrdinal);
        return this;
    }

    public BodyCreationSettings setMotionType(EMotionType motionType) {
        long bodySettingsVa = this.va();
        int motionTypeOrdinal = motionType.ordinal();
        BodyCreationSettings.setMotionType(bodySettingsVa, motionTypeOrdinal);
        return this;
    }

    public BodyCreationSettings getNumPositionStepsOverride(int numSteps) {
        long bodySettingsVa = this.va();
        BodyCreationSettings.setNumPositionStepsOverride(bodySettingsVa, numSteps);
        return this;
    }

    public BodyCreationSettings getNumVelocityStepsOverride(int numSteps) {
        long bodySettingsVa = this.va();
        BodyCreationSettings.setNumVelocityStepsOverride(bodySettingsVa, numSteps);
        return this;
    }

    public BodyCreationSettings setObjectLayer(int objLayer) {
        assert (objLayer >= 0 && objLayer < 65536) : "objLayer = " + objLayer;
        long bodySettingsVa = this.va();
        BodyCreationSettings.setObjectLayer(bodySettingsVa, objLayer);
        return this;
    }

    public BodyCreationSettings setOverrideMassProperties(EOverrideMassProperties setting) {
        long bodySettingsVa = this.va();
        int ordinal = setting.ordinal();
        BodyCreationSettings.setOverrideMassProperties(bodySettingsVa, ordinal);
        return this;
    }

    public BodyCreationSettings setPosition(double xx, double yy, double zz) {
        long bodySettingsVa = this.va();
        BodyCreationSettings.setPosition(bodySettingsVa, xx, yy, zz);
        return this;
    }

    public BodyCreationSettings setPosition(RVec3Arg location) {
        long bodySettingsVa = this.va();
        double xx = location.xx();
        double yy = location.yy();
        double zz = location.zz();
        BodyCreationSettings.setPosition(bodySettingsVa, xx, yy, zz);
        return this;
    }

    public BodyCreationSettings setRestitution(float restitution) {
        long bodySettingsVa = this.va();
        BodyCreationSettings.setRestitution(bodySettingsVa, restitution);
        return this;
    }

    public BodyCreationSettings setRotation(QuatArg quat) {
        assert (quat.isNormalized()) : "length =" + quat.length();
        long bodySettingsVa = this.va();
        float qw = quat.getW();
        float qx = quat.getX();
        float qy = quat.getY();
        float qz = quat.getZ();
        BodyCreationSettings.setRotation(bodySettingsVa, qx, qy, qz, qw);
        return this;
    }

    public BodyCreationSettings setShape(ConstShape shape) {
        long bodySettingsVa = this.va();
        long shapeVa = shape == null ? 0L : shape.targetVa();
        BodyCreationSettings.setShape(bodySettingsVa, shapeVa);
        return this;
    }

    public BodyCreationSettings setShapeSettings(ConstShapeSettings shapeSettings) {
        long bodySettingsVa = this.va();
        long shapeSettingsVa = shapeSettings.targetVa();
        BodyCreationSettings.setShapeSettings(bodySettingsVa, shapeSettingsVa);
        return this;
    }

    public BodyCreationSettings setUseManifoldReduction(boolean setting) {
        long bodySettingsVa = this.va();
        BodyCreationSettings.setUseManifoldReduction(bodySettingsVa, setting);
        return this;
    }

    public BodyCreationSettings setUserData(long value) {
        long bodySettingsVa = this.va();
        BodyCreationSettings.setUserData(bodySettingsVa, value);
        return this;
    }

    public static BcsResult sRestoreWithChildren(StreamIn stream, IdToShapeMap shapeMap, IdToMaterialMap materialMap, IdToGroupFilterMap filterMap) {
        long streamVa = stream.va();
        long shapeMapVa = shapeMap.va();
        long materialMapVa = materialMap.va();
        long filterMapVa = filterMap.va();
        long resultVa = BodyCreationSettings.sRestoreWithChildren(streamVa, shapeMapVa, materialMapVa, filterMapVa);
        BcsResult result = new BcsResult(resultVa, true);
        return result;
    }

    @Override
    public boolean getAllowDynamicOrKinematic() {
        long bodySettingsVa = this.va();
        boolean result = BodyCreationSettings.getAllowDynamicOrKinematic(bodySettingsVa);
        return result;
    }

    @Override
    public int getAllowedDofs() {
        long bodySettingsVa = this.va();
        int result = BodyCreationSettings.getAllowedDofs(bodySettingsVa);
        return result;
    }

    @Override
    public boolean getAllowSleeping() {
        long bodySettingsVa = this.va();
        boolean result = BodyCreationSettings.getAllowSleeping(bodySettingsVa);
        return result;
    }

    @Override
    public float getAngularDamping() {
        long bodySettingsVa = this.va();
        float result = BodyCreationSettings.getAngularDamping(bodySettingsVa);
        return result;
    }

    @Override
    public Vec3 getAngularVelocity() {
        long bodySettingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        BodyCreationSettings.getAngularVelocity(bodySettingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public boolean getApplyGyroscopicForce() {
        long bodySettingsVa = this.va();
        boolean result = BodyCreationSettings.getApplyGyroscopicForce(bodySettingsVa);
        return result;
    }

    @Override
    public boolean getCollideKinematicVsNonDynamic() {
        long bodySettingsVa = this.va();
        boolean result = BodyCreationSettings.getCollideKinematicVsNonDynamic(bodySettingsVa);
        return result;
    }

    @Override
    public CollisionGroup getCollisionGroup() {
        long bodySettingsVa = this.va();
        long groupVa = BodyCreationSettings.getCollisionGroup(bodySettingsVa);
        CollisionGroup result = new CollisionGroup(this, groupVa);
        return result;
    }

    @Override
    public boolean getEnhancedInternalEdgeRemoval() {
        long bodySettingsVa = this.va();
        boolean result = BodyCreationSettings.getEnhancedInternalEdgeRemoval(bodySettingsVa);
        return result;
    }

    @Override
    public float getFriction() {
        long bodySettingsVa = this.va();
        float result = BodyCreationSettings.getFriction(bodySettingsVa);
        return result;
    }

    @Override
    public float getGravityFactor() {
        long bodySettingsVa = this.va();
        float result = BodyCreationSettings.getGravityFactor(bodySettingsVa);
        return result;
    }

    @Override
    public float getInertiaMultiplier() {
        long bodySettingsVa = this.va();
        float result = BodyCreationSettings.getInertiaMultiplier(bodySettingsVa);
        return result;
    }

    @Override
    public boolean getIsSensor() {
        long bodySettingsVa = this.va();
        boolean result = BodyCreationSettings.getIsSensor(bodySettingsVa);
        return result;
    }

    @Override
    public float getLinearDamping() {
        long bodySettingsVa = this.va();
        float result = BodyCreationSettings.getLinearDamping(bodySettingsVa);
        return result;
    }

    @Override
    public Vec3 getLinearVelocity() {
        long bodySettingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        BodyCreationSettings.getLinearVelocity(bodySettingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public MassProperties getMassProperties() {
        MassProperties result;
        long bodySettingsVa = this.va();
        int omp = BodyCreationSettings.getOverrideMassProperties(bodySettingsVa);
        if (omp == EOverrideMassProperties.MassAndInertiaProvided.ordinal() || BodyCreationSettings.getShape(bodySettingsVa) != 0L) {
            long propertiesVa = BodyCreationSettings.getMassProperties(bodySettingsVa);
            result = new MassProperties(propertiesVa, true);
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public MassProperties getMassPropertiesOverride() {
        long bodySettingsVa = this.va();
        long propertiesVa = BodyCreationSettings.getMassPropertiesOverride(bodySettingsVa);
        MassProperties result = new MassProperties(this, propertiesVa);
        return result;
    }

    @Override
    public float getMaxAngularVelocity() {
        long bodySettingsVa = this.va();
        float result = BodyCreationSettings.getMaxAngularVelocity(bodySettingsVa);
        return result;
    }

    @Override
    public float getMaxLinearVelocity() {
        long bodySettingsVa = this.va();
        float result = BodyCreationSettings.getMaxLinearVelocity(bodySettingsVa);
        return result;
    }

    @Override
    public EMotionQuality getMotionQuality() {
        long bodySettingsVa = this.va();
        int ordinal = BodyCreationSettings.getMotionQuality(bodySettingsVa);
        EMotionQuality result = EMotionQuality.values()[ordinal];
        return result;
    }

    @Override
    public EMotionType getMotionType() {
        long bodySettingsVa = this.va();
        int ordinal = BodyCreationSettings.getMotionType(bodySettingsVa);
        EMotionType result = EMotionType.values()[ordinal];
        return result;
    }

    @Override
    public int getNumPositionStepsOverride() {
        long bodySettingsVa = this.va();
        int result = BodyCreationSettings.getNumPositionStepsOverride(bodySettingsVa);
        return result;
    }

    @Override
    public int getNumVelocityStepsOverride() {
        long bodySettingsVa = this.va();
        int result = BodyCreationSettings.getNumVelocityStepsOverride(bodySettingsVa);
        return result;
    }

    @Override
    public int getObjectLayer() {
        long bodySettingsVa = this.va();
        int result = BodyCreationSettings.getObjectLayer(bodySettingsVa);
        return result;
    }

    @Override
    public EOverrideMassProperties getOverrideMassProperties() {
        long bodySettingsVa = this.va();
        int ordinal = BodyCreationSettings.getOverrideMassProperties(bodySettingsVa);
        EOverrideMassProperties result = EOverrideMassProperties.values()[ordinal];
        return result;
    }

    @Override
    public RVec3 getPosition() {
        long bodySettingsVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        BodyCreationSettings.getPosition(bodySettingsVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        assert (Double.isFinite(result.xx())) : "xx = " + result.xx();
        assert (Double.isFinite(result.yy())) : "yy = " + result.yy();
        assert (Double.isFinite(result.zz())) : "zz = " + result.zz();
        return result;
    }

    @Override
    public float getRestitution() {
        long bodySettingsVa = this.va();
        float result = BodyCreationSettings.getRestitution(bodySettingsVa);
        return result;
    }

    @Override
    public Quat getRotation() {
        long bodySettingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        BodyCreationSettings.getRotation(bodySettingsVa, storeFloats);
        Quat result = new Quat(storeFloats);
        return result;
    }

    @Override
    public ConstShape getShape() {
        long bodySettingsVa = this.va();
        long shapeVa = BodyCreationSettings.getShape(bodySettingsVa);
        Shape result = Shape.newShape(shapeVa);
        return result;
    }

    @Override
    public ConstShapeSettings getShapeSettings() {
        long bodySettingsVa = this.va();
        long shapeSettingsVa = BodyCreationSettings.getShapeSettings(bodySettingsVa);
        ShapeSettings result = ShapeSettings.newShapeSettings(shapeSettingsVa);
        return result;
    }

    @Override
    public boolean getUseManifoldReduction() {
        long bodySettingsVa = this.va();
        boolean result = BodyCreationSettings.getUseManifoldReduction(bodySettingsVa);
        return result;
    }

    @Override
    public long getUserData() {
        long bodySettingsVa = this.va();
        long result = BodyCreationSettings.getUserData(bodySettingsVa);
        return result;
    }

    @Override
    public boolean hasMassProperties() {
        long bodySettingsVa = this.va();
        boolean result = BodyCreationSettings.hasMassProperties(bodySettingsVa);
        return result;
    }

    @Override
    public void saveBinaryState(StreamOut stream) {
        long bodySettingsVa = this.va();
        long streamVa = stream.va();
        BodyCreationSettings.saveBinaryState(bodySettingsVa, streamVa);
    }

    @Override
    public void saveWithChildren(StreamOut stream, ShapeToIdMap shapeMap, MaterialToIdMap materialMap, GroupFilterToIdMap filterMap) {
        long bodySettingsVa = this.va();
        long streamVa = stream.va();
        long shapeMapVa = shapeMap == null ? 0L : shapeMap.va();
        long materialMapVa = materialMap == null ? 0L : materialMap.va();
        long filterMapVa = filterMap == null ? 0L : filterMap.va();
        BodyCreationSettings.saveWithChildren(bodySettingsVa, streamVa, shapeMapVa, materialMapVa, filterMapVa);
    }

    final void setVirtualAddressAsOwner(long bodySettingsVa) {
        Runnable freeingAction = () -> BodyCreationSettings.free(bodySettingsVa);
        this.setVirtualAddress(bodySettingsVa, freeingAction);
    }

    private static native long convertShapeSettings(long var0);

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native long createFromShape(long var0, double var2, double var4, double var6, float var8, float var9, float var10, float var11, int var12, int var13);

    private static native long createFromShapeSettings(long var0, double var2, double var4, double var6, float var8, float var9, float var10, float var11, int var12, int var13);

    private static native void free(long var0);

    private static native boolean getAllowDynamicOrKinematic(long var0);

    private static native int getAllowedDofs(long var0);

    private static native boolean getAllowSleeping(long var0);

    private static native float getAngularDamping(long var0);

    private static native void getAngularVelocity(long var0, FloatBuffer var2);

    private static native boolean getApplyGyroscopicForce(long var0);

    private static native boolean getCollideKinematicVsNonDynamic(long var0);

    private static native long getCollisionGroup(long var0);

    private static native boolean getEnhancedInternalEdgeRemoval(long var0);

    private static native float getFriction(long var0);

    private static native float getGravityFactor(long var0);

    private static native float getInertiaMultiplier(long var0);

    private static native boolean getIsSensor(long var0);

    private static native float getLinearDamping(long var0);

    private static native void getLinearVelocity(long var0, FloatBuffer var2);

    private static native long getMassProperties(long var0);

    private static native long getMassPropertiesOverride(long var0);

    private static native float getMaxAngularVelocity(long var0);

    private static native float getMaxLinearVelocity(long var0);

    private static native int getMotionQuality(long var0);

    private static native int getMotionType(long var0);

    private static native int getNumPositionStepsOverride(long var0);

    private static native int getNumVelocityStepsOverride(long var0);

    private static native int getObjectLayer(long var0);

    private static native int getOverrideMassProperties(long var0);

    private static native void getPosition(long var0, DoubleBuffer var2);

    private static native float getRestitution(long var0);

    private static native void getRotation(long var0, FloatBuffer var2);

    private static native long getShape(long var0);

    private static native long getShapeSettings(long var0);

    private static native boolean getUseManifoldReduction(long var0);

    private static native long getUserData(long var0);

    private static native boolean hasMassProperties(long var0);

    private static native void restoreBinaryState(long var0, long var2);

    private static native void saveBinaryState(long var0, long var2);

    private static native void saveWithChildren(long var0, long var2, long var4, long var6, long var8);

    private static native void setAllowDynamicOrKinematic(long var0, boolean var2);

    private static native void setAllowedDofs(long var0, int var2);

    private static native void setAllowSleeping(long var0, boolean var2);

    private static native void setAngularDamping(long var0, float var2);

    private static native void setAngularVelocity(long var0, float var2, float var3, float var4);

    private static native void setApplyGyroscopicForce(long var0, boolean var2);

    private static native void setCollideKinematicVsNonDynamic(long var0, boolean var2);

    private static native void setCollisionGroup(long var0, long var2);

    private static native void setEnhancedInternalEdgeRemoval(long var0, boolean var2);

    private static native void setFriction(long var0, float var2);

    private static native void setGravityFactor(long var0, float var2);

    private static native void setInertiaMultiplier(long var0, float var2);

    private static native void setIsSensor(long var0, boolean var2);

    private static native void setLinearDamping(long var0, float var2);

    private static native void setLinearVelocity(long var0, float var2, float var3, float var4);

    private static native void setMassPropertiesOverride(long var0, long var2);

    private static native void setMaxAngularVelocity(long var0, float var2);

    private static native void setMaxLinearVelocity(long var0, float var2);

    private static native void setMotionQuality(long var0, int var2);

    private static native void setMotionType(long var0, int var2);

    private static native void setNumPositionStepsOverride(long var0, int var2);

    private static native void setNumVelocityStepsOverride(long var0, int var2);

    private static native void setObjectLayer(long var0, int var2);

    private static native void setOverrideMassProperties(long var0, int var2);

    private static native void setPosition(long var0, double var2, double var4, double var6);

    private static native void setRestitution(long var0, float var2);

    private static native void setRotation(long var0, float var2, float var3, float var4, float var5);

    private static native void setShape(long var0, long var2);

    private static native void setShapeSettings(long var0, long var2);

    private static native void setUseManifoldReduction(long var0, boolean var2);

    private static native void setUserData(long var0, long var2);

    private static native long sRestoreWithChildren(long var0, long var2, long var4, long var6);
}

