/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import java.util.ArrayList;
import java.util.List;

public class BodyIdVector
extends JoltPhysicsObject {
    public BodyIdVector() {
        long vectorVa = BodyIdVector.createDefault();
        this.setVirtualAddress(vectorVa, () -> BodyIdVector.free(vectorVa));
    }

    public BodyIdVector(BodyIdVector original) {
        long originalVa = original.va();
        long copyVa = BodyIdVector.createCopy(originalVa);
        this.setVirtualAddress(copyVa, () -> BodyIdVector.free(copyVa));
    }

    public int capacity() {
        long vectorVa = this.va();
        int result = BodyIdVector.capacity(vectorVa);
        return result;
    }

    public boolean empty() {
        return this.size() == 0;
    }

    public void erase(int elementIndex) {
        this.erase(elementIndex, elementIndex + 1);
    }

    public void erase(int startIndex, int stopIndex) {
        long vectorVa = this.va();
        BodyIdVector.erase(vectorVa, startIndex, stopIndex);
    }

    public int find(int id) {
        long vectorVa = this.va();
        int numIds = BodyIdVector.size(vectorVa);
        for (int i = 0; i < numIds; ++i) {
            int id2 = BodyIdVector.getId(vectorVa, i);
            if (id != id2) continue;
            return i;
        }
        return -1;
    }

    public int get(int elementIndex) {
        long vectorVa = this.va();
        int result = BodyIdVector.getId(vectorVa, elementIndex);
        return result;
    }

    public void pushBack(int bodyId) {
        int numElements = this.size();
        this.resize(numElements + 1);
        this.set(numElements, bodyId);
    }

    public void resize(int numIds) {
        long vectorVa = this.va();
        BodyIdVector.resize(vectorVa, numIds);
    }

    public void set(int elementIndex, int bodyId) {
        long vectorVa = this.va();
        BodyIdVector.setId(vectorVa, elementIndex, bodyId);
    }

    public int size() {
        long vectorVa = this.va();
        int result = BodyIdVector.size(vectorVa);
        return result;
    }

    public void sort() {
        long vectorVa = this.va();
        BodyIdVector.sort(vectorVa);
    }

    public List<Integer> toList() {
        int numElements = this.size();
        ArrayList<Integer> result = new ArrayList<Integer>(numElements);
        for (int i = 0; i < numElements; ++i) {
            int element = this.get(i);
            result.add(element);
        }
        return result;
    }

    private static native int capacity(long var0);

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native void erase(long var0, int var2, int var3);

    private static native void free(long var0);

    private static native int getId(long var0, int var2);

    private static native void resize(long var0, int var2);

    private static native void setId(long var0, int var2, int var3);

    private static native int size(long var0);

    private static native void sort(long var0);
}

