/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.ConvexShape;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.ConstPhysicsMaterial;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public class BoxShape
extends ConvexShape {
    public BoxShape(float halfExtent) {
        this(halfExtent, halfExtent, halfExtent);
    }

    public BoxShape(float xHalfExtent, float yHalfExtent, float zHalfExtent) {
        float convexRadius = 0.05f;
        assert (xHalfExtent >= convexRadius) : xHalfExtent;
        assert (yHalfExtent >= convexRadius) : yHalfExtent;
        assert (zHalfExtent >= convexRadius) : zHalfExtent;
        long materialVa = 0L;
        long shapeVa = BoxShape.createBoxShape(xHalfExtent, yHalfExtent, zHalfExtent, convexRadius, materialVa);
        this.setVirtualAddressAsCoOwner(shapeVa);
    }

    BoxShape(long shapeVa) {
        this.setVirtualAddressAsCoOwner(shapeVa);
    }

    public BoxShape(Vec3Arg halfExtents) {
        this(halfExtents, 0.05f);
    }

    public BoxShape(Vec3Arg halfExtents, float convexRadius) {
        this(halfExtents, convexRadius, null);
    }

    public BoxShape(Vec3Arg halfExtents, float convexRadius, ConstPhysicsMaterial material) {
        float xHalfExtent = halfExtents.getX();
        float yHalfExtent = halfExtents.getY();
        float zHalfExtent = halfExtents.getZ();
        assert (xHalfExtent >= convexRadius) : xHalfExtent;
        assert (yHalfExtent >= convexRadius) : yHalfExtent;
        assert (zHalfExtent >= convexRadius) : zHalfExtent;
        long materialVa = material == null ? 0L : material.targetVa();
        long shapeVa = BoxShape.createBoxShape(xHalfExtent, yHalfExtent, zHalfExtent, convexRadius, materialVa);
        this.setVirtualAddressAsCoOwner(shapeVa);
    }

    public float getConvexRadius() {
        long shapeVa = this.va();
        float result = BoxShape.getConvexRadius(shapeVa);
        return result;
    }

    public Vec3 getHalfExtent() {
        long shapeVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        BoxShape.getHalfExtent(shapeVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    private static native long createBoxShape(float var0, float var1, float var2, float var3, long var4);

    private static native float getConvexRadius(long var0);

    private static native void getHalfExtent(long var0, FloatBuffer var2);
}

