/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.ConvexShapeSettings;
import com.github.stephengold.joltjni.PhysicsMaterial;
import com.github.stephengold.joltjni.enumerate.EShapeSubType;

public class CapsuleShapeSettings
extends ConvexShapeSettings {
    public CapsuleShapeSettings() {
        long settingsVa = CapsuleShapeSettings.createDefault();
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Capsule);
    }

    public CapsuleShapeSettings(CapsuleShapeSettings original) {
        long originalVa = original.va();
        long copyVa = CapsuleShapeSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa, EShapeSubType.Capsule);
    }

    public CapsuleShapeSettings(float halfHeight, float radius) {
        this(halfHeight, radius, null);
    }

    public CapsuleShapeSettings(float halfHeight, float radius, PhysicsMaterial material) {
        long materialVa = material == null ? 0L : material.va();
        long settingsVa = CapsuleShapeSettings.createShapeSettings(halfHeight, radius, materialVa);
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Capsule);
    }

    CapsuleShapeSettings(long settingsVa) {
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Capsule);
    }

    public float getHalfHeightOfCylinder() {
        long settingsVa = this.va();
        float result = CapsuleShapeSettings.getHalfHeightOfCylinder(settingsVa);
        return result;
    }

    public float getRadius() {
        long settingsVa = this.va();
        float result = CapsuleShapeSettings.getRadius(settingsVa);
        return result;
    }

    public void setHalfHeightOfCylinder(float halfHeight) {
        long settingsVa = this.va();
        CapsuleShapeSettings.setHalfHeightOfCylinder(settingsVa, halfHeight);
    }

    public void setRadius(float radius) {
        long settingsVa = this.va();
        CapsuleShapeSettings.setRadius(settingsVa, radius);
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native long createShapeSettings(float var0, float var1, long var2);

    private static native float getHalfHeightOfCylinder(long var0);

    private static native float getRadius(long var0);

    private static native void setHalfHeightOfCylinder(long var0, float var2);

    private static native void setRadius(long var0, float var2);
}

