/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.CharacterBaseSettings;
import com.github.stephengold.joltjni.CharacterSettingsRef;
import com.github.stephengold.joltjni.readonly.ConstCharacterSettings;
import com.github.stephengold.joltjni.template.RefTarget;

public class CharacterSettings
extends CharacterBaseSettings
implements ConstCharacterSettings,
RefTarget {
    public CharacterSettings() {
        long settingsVa = CharacterSettings.createCharacterSettings();
        long refVa = CharacterSettings.toRef(settingsVa);
        Runnable freeingAction = () -> CharacterSettingsRef.free(refVa);
        this.setVirtualAddress(settingsVa, freeingAction);
    }

    public CharacterSettings(ConstCharacterSettings original) {
        long originalVa = original.targetVa();
        long copyVa = CharacterSettings.createCopy(originalVa);
        long refVa = CharacterSettings.toRef(copyVa);
        Runnable freeingAction = () -> CharacterSettingsRef.free(refVa);
        this.setVirtualAddress(copyVa, freeingAction);
    }

    CharacterSettings(long settingsVa) {
        long refVa = CharacterSettings.toRef(settingsVa);
        Runnable freeingAction = () -> CharacterSettingsRef.free(refVa);
        this.setVirtualAddress(settingsVa, freeingAction);
    }

    public void setFriction(float friction) {
        long settingsVa = this.va();
        CharacterSettings.setFriction(settingsVa, friction);
    }

    public void setGravityFactor(float factor) {
        long settingsVa = this.va();
        CharacterSettings.setGravityFactor(settingsVa, factor);
    }

    public void setLayer(int objLayer) {
        long settingsVa = this.va();
        CharacterSettings.setLayer(settingsVa, objLayer);
    }

    public void setMass(float mass) {
        long settingsVa = this.va();
        CharacterSettings.setMass(settingsVa, mass);
    }

    @Override
    public float getFriction() {
        long settingsVa = this.va();
        float result = CharacterSettings.getFriction(settingsVa);
        return result;
    }

    @Override
    public float getGravityFactor() {
        long settingsVa = this.va();
        float result = CharacterSettings.getGravityFactor(settingsVa);
        return result;
    }

    @Override
    public int getLayer() {
        long settingsVa = this.va();
        int result = CharacterSettings.getLayer(settingsVa);
        return result;
    }

    @Override
    public float getMass() {
        long settingsVa = this.va();
        float result = CharacterSettings.getMass(settingsVa);
        return result;
    }

    @Override
    public void setEmbedded() {
        long settingsVa = this.va();
        CharacterSettings.setEmbedded(settingsVa);
    }

    @Override
    public CharacterSettingsRef toRef() {
        long settingsVa = this.va();
        long refVa = CharacterSettings.toRef(settingsVa);
        CharacterSettingsRef result = new CharacterSettingsRef(refVa, true);
        return result;
    }

    private static native long createCharacterSettings();

    private static native long createCopy(long var0);

    static native float getFriction(long var0);

    static native float getGravityFactor(long var0);

    static native int getLayer(long var0);

    static native float getMass(long var0);

    private static native void setEmbedded(long var0);

    static native void setFriction(long var0, float var2);

    static native void setGravityFactor(long var0, float var2);

    static native void setLayer(long var0, int var2);

    static native void setMass(long var0, float var2);

    private static native long toRef(long var0);
}

