/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.CharacterBaseSettings;
import com.github.stephengold.joltjni.CharacterSettings;
import com.github.stephengold.joltjni.Plane;
import com.github.stephengold.joltjni.Shape;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.ConstCharacterSettings;
import com.github.stephengold.joltjni.readonly.ConstPlane;
import com.github.stephengold.joltjni.readonly.ConstShape;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import com.github.stephengold.joltjni.template.Ref;
import java.nio.FloatBuffer;

public final class CharacterSettingsRef
extends Ref
implements ConstCharacterSettings {
    public CharacterSettingsRef() {
        long refVa = CharacterSettingsRef.createDefault();
        this.setVirtualAddress(refVa, () -> CharacterSettingsRef.free(refVa));
    }

    CharacterSettingsRef(long refVa, boolean owner) {
        Runnable freeingAction = owner ? () -> CharacterSettingsRef.free(refVa) : null;
        this.setVirtualAddress(refVa, freeingAction);
    }

    public void setEnhancedInternalEdgeRemoval(boolean remove) {
        long settingsVa = this.targetVa();
        CharacterBaseSettings.setEnhancedInternalEdgeRemoval(settingsVa, remove);
    }

    public void setFriction(float friction) {
        long settingsVa = this.targetVa();
        CharacterSettings.setFriction(settingsVa, friction);
    }

    public void setGravityFactor(float factor) {
        long settingsVa = this.targetVa();
        CharacterSettings.setGravityFactor(settingsVa, factor);
    }

    public void setLayer(int objLayer) {
        long settingsVa = this.targetVa();
        CharacterSettings.setLayer(settingsVa, objLayer);
    }

    public void setMass(float mass) {
        long settingsVa = this.targetVa();
        CharacterSettings.setMass(settingsVa, mass);
    }

    public void setMaxSlopeAngle(float angle) {
        long settingsVa = this.targetVa();
        CharacterBaseSettings.setMaxSlopeAngle(settingsVa, angle);
    }

    public void setShape(ConstShape shape) {
        long settingsVa = this.targetVa();
        long shapeVa = shape.targetVa();
        CharacterBaseSettings.setShape(settingsVa, shapeVa);
    }

    public void setSupportingVolume(ConstPlane plane) {
        long settingsVa = this.targetVa();
        float nx = plane.getNormalX();
        float ny = plane.getNormalY();
        float nz = plane.getNormalZ();
        float c = plane.getConstant();
        CharacterBaseSettings.setSupportingVolume(settingsVa, nx, ny, nz, c);
    }

    public void setUp(Vec3Arg direction) {
        long settingsVa = this.targetVa();
        float dx = direction.getX();
        float dy = direction.getY();
        float dz = direction.getZ();
        CharacterBaseSettings.setUp(settingsVa, dx, dy, dz);
    }

    @Override
    public boolean getEnhancedInternalEdgeRemoval() {
        long settingsVa = this.targetVa();
        boolean result = CharacterBaseSettings.getEnhancedInternalEdgeRemoval(settingsVa);
        return result;
    }

    @Override
    public float getFriction() {
        long settingsVa = this.targetVa();
        float result = CharacterSettings.getFriction(settingsVa);
        return result;
    }

    @Override
    public float getGravityFactor() {
        long settingsVa = this.targetVa();
        float result = CharacterSettings.getGravityFactor(settingsVa);
        return result;
    }

    @Override
    public int getLayer() {
        long settingsVa = this.targetVa();
        int result = CharacterSettings.getLayer(settingsVa);
        return result;
    }

    @Override
    public float getMass() {
        long settingsVa = this.targetVa();
        float result = CharacterSettings.getMass(settingsVa);
        return result;
    }

    @Override
    public float getMaxSlopeAngle() {
        long settingsVa = this.targetVa();
        float result = CharacterBaseSettings.getMaxSlopeAngle(settingsVa);
        return result;
    }

    @Override
    public int getRefCount() {
        long settingsVa = this.targetVa();
        int result = CharacterBaseSettings.getRefCount(settingsVa);
        return result;
    }

    @Override
    public ConstShape getShape() {
        long bodySettingsVa = this.targetVa();
        long shapeSettingsVa = CharacterBaseSettings.getShape(bodySettingsVa);
        Shape result = Shape.newShape(shapeSettingsVa);
        return result;
    }

    @Override
    public Plane getSupportingVolume() {
        long settingsVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterBaseSettings.getSupportingVolume(settingsVa, storeFloats);
        Plane result = new Plane(storeFloats);
        return result;
    }

    @Override
    public Vec3 getUp() {
        long settingsVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterBaseSettings.getUp(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public CharacterSettings getPtr() {
        long settingsVa = this.targetVa();
        CharacterSettings result = new CharacterSettings(settingsVa);
        return result;
    }

    @Override
    public long targetVa() {
        long refVa = this.va();
        long result = CharacterSettingsRef.getPtr(refVa);
        return result;
    }

    @Override
    public CharacterSettingsRef toRef() {
        long refVa = this.va();
        long copyVa = CharacterSettingsRef.copy(refVa);
        CharacterSettingsRef result = new CharacterSettingsRef(copyVa, true);
        return result;
    }

    private static native long copy(long var0);

    private static native long createDefault();

    static native void free(long var0);

    private static native long getPtr(long var0);
}

