/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.BodyFilter;
import com.github.stephengold.joltjni.BroadPhaseLayerFilter;
import com.github.stephengold.joltjni.CharacterBase;
import com.github.stephengold.joltjni.CharacterVirtual;
import com.github.stephengold.joltjni.CharacterVirtualRefC;
import com.github.stephengold.joltjni.CharacterVirtualSettings;
import com.github.stephengold.joltjni.Contact;
import com.github.stephengold.joltjni.ExtendedUpdateSettings;
import com.github.stephengold.joltjni.ObjectLayerFilter;
import com.github.stephengold.joltjni.PhysicsMaterial;
import com.github.stephengold.joltjni.PhysicsSystem;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RMat44;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Shape;
import com.github.stephengold.joltjni.ShapeFilter;
import com.github.stephengold.joltjni.StateRecorder;
import com.github.stephengold.joltjni.TempAllocator;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.TransformedShape;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EGroundState;
import com.github.stephengold.joltjni.readonly.ConstCharacterVirtual;
import com.github.stephengold.joltjni.readonly.ConstContact;
import com.github.stephengold.joltjni.readonly.ConstPhysicsMaterial;
import com.github.stephengold.joltjni.readonly.ConstShape;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import com.github.stephengold.joltjni.template.Ref;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public final class CharacterVirtualRef
extends Ref
implements ConstCharacterVirtual {
    private final PhysicsSystem system;

    public CharacterVirtualRef() {
        this.system = null;
        long refVa = CharacterVirtualRef.createDefault();
        this.setVirtualAddress(refVa, () -> CharacterVirtualRef.free(refVa));
    }

    CharacterVirtualRef(long refVa, PhysicsSystem physicsSystem) {
        this.system = physicsSystem;
        Runnable freeingAction = () -> CharacterVirtualRef.freeWithSystem(refVa, physicsSystem);
        this.setVirtualAddress(refVa, freeingAction);
    }

    public void extendedUpdate(float deltaTime, Vec3Arg gravity, ExtendedUpdateSettings settings, BroadPhaseLayerFilter bpFilter, ObjectLayerFilter olFilter, BodyFilter bodyFilter, ShapeFilter shapeFilter, TempAllocator allocator) {
        long characterVa = this.targetVa();
        float gravityX = gravity.getX();
        float gravityY = gravity.getY();
        float gravityZ = gravity.getZ();
        long settingsVa = settings.va();
        long bpFilterVa = bpFilter.va();
        long olFilterVa = olFilter.va();
        long bodyFilterVa = bodyFilter.va();
        long shapeFilterVa = shapeFilter.va();
        long allocatorVa = allocator.va();
        CharacterVirtual.extendedUpdate(characterVa, deltaTime, gravityX, gravityY, gravityZ, settingsVa, bpFilterVa, olFilterVa, bodyFilterVa, shapeFilterVa, allocatorVa);
    }

    public void restoreState(StateRecorder recorder) {
        long characterVa = this.targetVa();
        long recorderVa = recorder.va();
        CharacterBase.restoreState(characterVa, recorderVa);
    }

    public void setLinearVelocity(float vx, float vy, float vz) {
        long characterVa = this.targetVa();
        CharacterVirtual.setLinearVelocity(characterVa, vx, vy, vz);
    }

    public void setLinearVelocity(Vec3Arg velocity) {
        float vx = velocity.getX();
        float vy = velocity.getY();
        float vz = velocity.getZ();
        this.setLinearVelocity(vx, vy, vz);
    }

    public void setPosition(RVec3Arg location) {
        long characterVa = this.targetVa();
        double locX = location.xx();
        double locY = location.yy();
        double locZ = location.zz();
        CharacterVirtual.setPosition(characterVa, locX, locY, locZ);
    }

    public void setRotation(QuatArg orientation) {
        long characterVa = this.targetVa();
        float qw = orientation.getW();
        float qx = orientation.getX();
        float qy = orientation.getY();
        float qz = orientation.getZ();
        CharacterVirtual.setRotation(characterVa, qx, qy, qz, qw);
    }

    public boolean setShape(ConstShape shape, float maxPenetrationDepth, BroadPhaseLayerFilter broadPhaseLayerFilter, ObjectLayerFilter objectLayerFilter, BodyFilter bodyFilter, ShapeFilter shapeFilter, TempAllocator allocator) {
        long characterVa = this.targetVa();
        long shapeVa = shape.targetVa();
        long bplFilterVa = broadPhaseLayerFilter.va();
        long olFilterVa = objectLayerFilter.va();
        long bodyFilterVa = bodyFilter.va();
        long shapeFilterVa = shapeFilter.va();
        long allocatorVa = allocator.va();
        boolean result = CharacterVirtual.setShape(characterVa, shapeVa, maxPenetrationDepth, bplFilterVa, olFilterVa, bodyFilterVa, shapeFilterVa, allocatorVa);
        return result;
    }

    public void setInnerBodyShape(ConstShape shape) {
        long characterVa = this.targetVa();
        long shapeVa = shape.targetVa();
        CharacterVirtual.setInnerBodyShape(characterVa, shapeVa);
    }

    public void setUp(Vec3Arg up) {
        long characterVa = this.targetVa();
        float x = up.getX();
        float y = up.getY();
        float z = up.getZ();
        CharacterBase.setUp(characterVa, x, y, z);
    }

    public void updateGroundVelocity() {
        long characterVa = this.targetVa();
        CharacterVirtual.updateGroundVelocity(characterVa);
    }

    @Override
    public Vec3 cancelVelocityTowardsSteepSlopes(Vec3Arg desiredVelocity) {
        long characterVa = this.targetVa();
        float vx = desiredVelocity.getX();
        float vy = desiredVelocity.getY();
        float vz = desiredVelocity.getZ();
        float[] storeVelocity = new float[3];
        CharacterVirtual.cancelVelocityTowardsSteepSlopes(characterVa, vx, vy, vz, storeVelocity);
        Vec3 result = new Vec3(storeVelocity);
        return result;
    }

    @Override
    public boolean canWalkStairs(Vec3Arg desiredVelocity) {
        long characterVa = this.targetVa();
        float vx = desiredVelocity.getX();
        float vy = desiredVelocity.getY();
        float vz = desiredVelocity.getZ();
        boolean result = CharacterVirtual.canWalkStairs(characterVa, vx, vy, vz);
        return result;
    }

    @Override
    public ConstContact[] getActiveContacts() {
        long characterVa = this.targetVa();
        int numContacts = CharacterVirtual.countActiveContacts(characterVa);
        ConstContact[] result = new ConstContact[numContacts];
        for (int i = 0; i < numContacts; ++i) {
            long contactVa = CharacterVirtual.getActiveContact(characterVa, i);
            result[i] = new Contact(contactVa, true);
        }
        return result;
    }

    @Override
    public RVec3 getCenterOfMassPosition() {
        long characterVa = this.targetVa();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        CharacterVirtual.getCenterOfMassPosition(characterVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    @Override
    public RMat44 getCenterOfMassTransform() {
        long characterVa = this.targetVa();
        long matrixVa = CharacterVirtual.getCenterOfMassTransform(characterVa);
        RMat44 result = new RMat44(matrixVa, true);
        return result;
    }

    @Override
    public float getCharacterPadding() {
        long characterVa = this.targetVa();
        float result = CharacterVirtual.getCharacterPadding(characterVa);
        return result;
    }

    @Override
    public CharacterVirtualSettings getCharacterVirtualSettings() {
        long characterVa = this.targetVa();
        long settingsVa = CharacterVirtual.getCharacterVirtualSettings(characterVa);
        CharacterVirtualSettings result = new CharacterVirtualSettings(settingsVa);
        return result;
    }

    @Override
    public float getCosMaxSlopeAngle() {
        long characterVa = this.targetVa();
        float result = CharacterBase.getCosMaxSlopeAngle(characterVa);
        return result;
    }

    @Override
    public boolean getEnhancedInternalEdgeRemoval() {
        long characterVa = this.targetVa();
        boolean result = CharacterVirtual.getEnhancedInternalEdgeRemoval(characterVa);
        return result;
    }

    @Override
    public int getGroundBodyId() {
        long characterVa = this.targetVa();
        int result = CharacterBase.getGroundBodyId(characterVa);
        return result;
    }

    @Override
    public ConstPhysicsMaterial getGroundMaterial() {
        long characterVa = this.targetVa();
        long materialVa = CharacterBase.getGroundMaterial(characterVa);
        PhysicsMaterial result = materialVa == 0L ? null : new PhysicsMaterial(materialVa);
        return result;
    }

    @Override
    public Vec3 getGroundNormal() {
        long characterVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterBase.getGroundNormal(characterVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public RVec3 getGroundPosition() {
        long characterVa = this.targetVa();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        CharacterBase.getGroundPosition(characterVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    @Override
    public EGroundState getGroundState() {
        long characterVa = this.targetVa();
        int ordinal = CharacterBase.getGroundState(characterVa);
        EGroundState result = EGroundState.values()[ordinal];
        return result;
    }

    @Override
    public int getGroundSubShapeId() {
        long characterVa = this.targetVa();
        int result = CharacterBase.getGroundSubShapeId(characterVa);
        return result;
    }

    @Override
    public long getGroundUserData() {
        long characterVa = this.targetVa();
        long result = CharacterBase.getGroundUserData(characterVa);
        return result;
    }

    @Override
    public Vec3 getGroundVelocity() {
        long characterVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterBase.getGroundVelocity(characterVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public float getHitReductionCosMaxAngle() {
        long characterVa = this.targetVa();
        float result = CharacterVirtual.getHitReductionCosMaxAngle(characterVa);
        return result;
    }

    @Override
    public int getId() {
        long characterVa = this.targetVa();
        int result = CharacterVirtual.getId(characterVa);
        return result;
    }

    @Override
    public int getInnerBodyId() {
        long characterVa = this.targetVa();
        int result = CharacterVirtual.getInnerBodyId(characterVa);
        return result;
    }

    @Override
    public Vec3 getLinearVelocity() {
        long characterVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterVirtual.getLinearVelocity(characterVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public float getMass() {
        long characterVa = this.targetVa();
        float result = CharacterVirtual.getMass(characterVa);
        return result;
    }

    @Override
    public boolean getMaxHitsExceeded() {
        long characterVa = this.targetVa();
        boolean result = CharacterVirtual.getMaxHitsExceeded(characterVa);
        return result;
    }

    @Override
    public int getMaxNumHits() {
        long characterVa = this.targetVa();
        int result = CharacterVirtual.getMaxNumHits(characterVa);
        return result;
    }

    @Override
    public float getMaxStrength() {
        long characterVa = this.targetVa();
        float result = CharacterVirtual.getMaxStrength(characterVa);
        return result;
    }

    @Override
    public float getPenetrationRecoverySpeed() {
        long characterVa = this.targetVa();
        float result = CharacterVirtual.getPenetrationRecoverySpeed(characterVa);
        return result;
    }

    @Override
    public RVec3 getPosition() {
        long characterVa = this.targetVa();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        CharacterVirtual.getPosition(characterVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    @Override
    public void getPositionAndRotation(RVec3 storeLocation, Quat storeOrientation) {
        long characterVa = this.targetVa();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        CharacterVirtual.getPosition(characterVa, storeDoubles);
        storeLocation.set(storeDoubles);
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterVirtual.getRotation(characterVa, storeFloats);
        storeOrientation.set(storeFloats);
    }

    @Override
    public int getRefCount() {
        long characterVa = this.targetVa();
        int result = CharacterBase.getRefCount(characterVa);
        return result;
    }

    @Override
    public Quat getRotation() {
        long characterVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterVirtual.getRotation(characterVa, storeFloats);
        Quat result = new Quat(storeFloats);
        return result;
    }

    @Override
    public ConstShape getShape() {
        long characterVa = this.targetVa();
        long shapeVa = CharacterBase.getShape(characterVa);
        Shape result = Shape.newShape(shapeVa);
        return result;
    }

    @Override
    public Vec3 getShapeOffset() {
        long characterVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterVirtual.getShapeOffset(characterVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public TransformedShape getTransformedShape() {
        long characterVa = this.targetVa();
        long resultVa = CharacterVirtual.getTransformedShape(characterVa);
        TransformedShape result = new TransformedShape(resultVa, true);
        return result;
    }

    @Override
    public Vec3 getUp() {
        long characterVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterBase.getUp(characterVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public long getUserData() {
        long characterVa = this.targetVa();
        long result = CharacterVirtual.getUserData(characterVa);
        return result;
    }

    @Override
    public RMat44 getWorldTransform() {
        long characterVa = this.targetVa();
        long matrixVa = CharacterVirtual.getWorldTransform(characterVa);
        RMat44 result = new RMat44(matrixVa, true);
        return result;
    }

    @Override
    public boolean hasCollidedWith(int bodyId) {
        long characterVa = this.targetVa();
        boolean result = CharacterVirtual.hasCollidedWithBody(characterVa, bodyId);
        return result;
    }

    @Override
    public boolean hasCollidedWith(ConstCharacterVirtual otherCharacter) {
        long characterVa = this.targetVa();
        long otherVa = otherCharacter.targetVa();
        boolean result = CharacterVirtual.hasCollidedWithCharacter(characterVa, otherVa);
        return result;
    }

    @Override
    public boolean isSlopeTooSteep(Vec3Arg normal) {
        long characterVa = this.targetVa();
        float nx = normal.getX();
        float ny = normal.getY();
        float nz = normal.getZ();
        boolean result = CharacterBase.isSlopeTooSteep(characterVa, nx, ny, nz);
        return result;
    }

    @Override
    public boolean isSupported() {
        long characterVa = this.targetVa();
        boolean result = CharacterBase.isSupported(characterVa);
        return result;
    }

    @Override
    public void saveState(StateRecorder recorder) {
        long characterVa = this.targetVa();
        long recorderVa = recorder.va();
        CharacterBase.saveState(characterVa, recorderVa);
    }

    @Override
    public CharacterVirtualRefC toRefC() {
        long refVa = this.va();
        long copyVa = CharacterVirtualRef.toRefC(refVa);
        CharacterVirtualRefC result = new CharacterVirtualRefC(copyVa, this.system);
        return result;
    }

    @Override
    public CharacterVirtual getPtr() {
        long settingsVa = this.targetVa();
        CharacterVirtual result = new CharacterVirtual(settingsVa, this.system);
        return result;
    }

    @Override
    public long targetVa() {
        long refVa = this.va();
        long result = CharacterVirtualRef.getPtr(refVa);
        return result;
    }

    @Override
    public CharacterVirtualRef toRef() {
        long refVa = this.va();
        long copyVa = CharacterVirtualRef.copy(refVa);
        CharacterVirtualRef result = new CharacterVirtualRef(copyVa, this.system);
        return result;
    }

    private static native long copy(long var0);

    private static native long createDefault();

    private static native void free(long var0);

    static native void freeWithSystem(long var0, PhysicsSystem var2);

    private static native long getPtr(long var0);

    private static native long toRefC(long var0);
}

