/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.CharacterBase;
import com.github.stephengold.joltjni.CharacterVirtual;
import com.github.stephengold.joltjni.CharacterVirtualSettings;
import com.github.stephengold.joltjni.Contact;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.PhysicsMaterial;
import com.github.stephengold.joltjni.PhysicsSystem;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RMat44;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Shape;
import com.github.stephengold.joltjni.StateRecorder;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.TransformedShape;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EGroundState;
import com.github.stephengold.joltjni.readonly.ConstCharacterVirtual;
import com.github.stephengold.joltjni.readonly.ConstContact;
import com.github.stephengold.joltjni.readonly.ConstPhysicsMaterial;
import com.github.stephengold.joltjni.readonly.ConstShape;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public final class CharacterVirtualRefC
extends JoltPhysicsObject
implements ConstCharacterVirtual {
    private final PhysicsSystem system;

    CharacterVirtualRefC(long refVa, PhysicsSystem physicsSystem) {
        this.system = physicsSystem;
        Runnable freeingAction = () -> CharacterVirtualRefC.freeWithSystem(refVa, physicsSystem);
        this.setVirtualAddress(refVa, freeingAction);
    }

    public ConstCharacterVirtual getPtr() {
        long refVa = this.va();
        long characterVa = CharacterVirtualRefC.getPtr(refVa);
        CharacterVirtual result = new CharacterVirtual(characterVa, this.system);
        return result;
    }

    @Override
    public Vec3 cancelVelocityTowardsSteepSlopes(Vec3Arg desiredVelocity) {
        long characterVa = this.targetVa();
        float vx = desiredVelocity.getX();
        float vy = desiredVelocity.getY();
        float vz = desiredVelocity.getZ();
        float[] storeVelocity = new float[3];
        CharacterVirtual.cancelVelocityTowardsSteepSlopes(characterVa, vx, vy, vz, storeVelocity);
        Vec3 result = new Vec3(storeVelocity);
        return result;
    }

    @Override
    public boolean canWalkStairs(Vec3Arg desiredVelocity) {
        long characterVa = this.targetVa();
        float vx = desiredVelocity.getX();
        float vy = desiredVelocity.getY();
        float vz = desiredVelocity.getZ();
        boolean result = CharacterVirtual.canWalkStairs(characterVa, vx, vy, vz);
        return result;
    }

    @Override
    public ConstContact[] getActiveContacts() {
        long characterVa = this.targetVa();
        int numContacts = CharacterVirtual.countActiveContacts(characterVa);
        ConstContact[] result = new ConstContact[numContacts];
        for (int i = 0; i < numContacts; ++i) {
            long contactVa = CharacterVirtual.getActiveContact(characterVa, i);
            result[i] = new Contact(contactVa, true);
        }
        return result;
    }

    @Override
    public RVec3 getCenterOfMassPosition() {
        long characterVa = this.targetVa();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        CharacterVirtual.getCenterOfMassPosition(characterVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    @Override
    public RMat44 getCenterOfMassTransform() {
        long characterVa = this.targetVa();
        long matrixVa = CharacterVirtual.getCenterOfMassTransform(characterVa);
        RMat44 result = new RMat44(matrixVa, true);
        return result;
    }

    @Override
    public float getCharacterPadding() {
        long characterVa = this.targetVa();
        float result = CharacterVirtual.getCharacterPadding(characterVa);
        return result;
    }

    @Override
    public CharacterVirtualSettings getCharacterVirtualSettings() {
        long characterVa = this.targetVa();
        long settingsVa = CharacterVirtual.getCharacterVirtualSettings(characterVa);
        CharacterVirtualSettings result = new CharacterVirtualSettings(settingsVa);
        return result;
    }

    @Override
    public float getCosMaxSlopeAngle() {
        long characterVa = this.targetVa();
        float result = CharacterBase.getCosMaxSlopeAngle(characterVa);
        return result;
    }

    @Override
    public boolean getEnhancedInternalEdgeRemoval() {
        long characterVa = this.targetVa();
        boolean result = CharacterVirtual.getEnhancedInternalEdgeRemoval(characterVa);
        return result;
    }

    @Override
    public int getGroundBodyId() {
        long characterVa = this.targetVa();
        int result = CharacterBase.getGroundBodyId(characterVa);
        return result;
    }

    @Override
    public ConstPhysicsMaterial getGroundMaterial() {
        long characterVa = this.targetVa();
        long materialVa = CharacterBase.getGroundMaterial(characterVa);
        PhysicsMaterial result = materialVa == 0L ? null : new PhysicsMaterial(materialVa);
        return result;
    }

    @Override
    public Vec3 getGroundNormal() {
        long characterVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterBase.getGroundNormal(characterVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public RVec3 getGroundPosition() {
        long characterVa = this.targetVa();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        CharacterBase.getGroundPosition(characterVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    @Override
    public EGroundState getGroundState() {
        long characterVa = this.targetVa();
        int ordinal = CharacterBase.getGroundState(characterVa);
        EGroundState result = EGroundState.values()[ordinal];
        return result;
    }

    @Override
    public int getGroundSubShapeId() {
        long characterVa = this.targetVa();
        int result = CharacterBase.getGroundSubShapeId(characterVa);
        return result;
    }

    @Override
    public long getGroundUserData() {
        long characterVa = this.targetVa();
        long result = CharacterBase.getGroundUserData(characterVa);
        return result;
    }

    @Override
    public Vec3 getGroundVelocity() {
        long characterVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterBase.getGroundVelocity(characterVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public float getHitReductionCosMaxAngle() {
        long characterVa = this.targetVa();
        float result = CharacterVirtual.getHitReductionCosMaxAngle(characterVa);
        return result;
    }

    @Override
    public int getId() {
        long characterVa = this.targetVa();
        int result = CharacterVirtual.getId(characterVa);
        return result;
    }

    @Override
    public int getInnerBodyId() {
        long characterVa = this.targetVa();
        int result = CharacterVirtual.getInnerBodyId(characterVa);
        return result;
    }

    @Override
    public Vec3 getLinearVelocity() {
        long characterVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterVirtual.getLinearVelocity(characterVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public float getMass() {
        long characterVa = this.targetVa();
        float result = CharacterVirtual.getMass(characterVa);
        return result;
    }

    @Override
    public boolean getMaxHitsExceeded() {
        long characterVa = this.targetVa();
        boolean result = CharacterVirtual.getMaxHitsExceeded(characterVa);
        return result;
    }

    @Override
    public int getMaxNumHits() {
        long characterVa = this.targetVa();
        int result = CharacterVirtual.getMaxNumHits(characterVa);
        return result;
    }

    @Override
    public float getMaxStrength() {
        long characterVa = this.targetVa();
        float result = CharacterVirtual.getMaxStrength(characterVa);
        return result;
    }

    @Override
    public float getPenetrationRecoverySpeed() {
        long characterVa = this.targetVa();
        float result = CharacterVirtual.getPenetrationRecoverySpeed(characterVa);
        return result;
    }

    @Override
    public RVec3 getPosition() {
        long characterVa = this.targetVa();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        CharacterVirtual.getPosition(characterVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    @Override
    public void getPositionAndRotation(RVec3 storeLocation, Quat storeOrientation) {
        long characterVa = this.targetVa();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        CharacterVirtual.getPosition(characterVa, storeDoubles);
        storeLocation.set(storeDoubles);
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterVirtual.getRotation(characterVa, storeFloats);
        storeOrientation.set(storeFloats);
    }

    @Override
    public int getRefCount() {
        long characterVa = this.targetVa();
        int result = CharacterBase.getRefCount(characterVa);
        return result;
    }

    @Override
    public Quat getRotation() {
        long characterVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterVirtual.getRotation(characterVa, storeFloats);
        Quat result = new Quat(storeFloats);
        return result;
    }

    @Override
    public ConstShape getShape() {
        long characterVa = this.targetVa();
        long shapeVa = CharacterBase.getShape(characterVa);
        Shape result = Shape.newShape(shapeVa);
        return result;
    }

    @Override
    public Vec3 getShapeOffset() {
        long characterVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterVirtual.getShapeOffset(characterVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public TransformedShape getTransformedShape() {
        long characterVa = this.targetVa();
        long resultVa = CharacterVirtual.getTransformedShape(characterVa);
        TransformedShape result = new TransformedShape(resultVa, true);
        return result;
    }

    @Override
    public Vec3 getUp() {
        long characterVa = this.targetVa();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        CharacterBase.getUp(characterVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public long getUserData() {
        long characterVa = this.targetVa();
        long result = CharacterVirtual.getUserData(characterVa);
        return result;
    }

    @Override
    public RMat44 getWorldTransform() {
        long characterVa = this.targetVa();
        long matrixVa = CharacterVirtual.getWorldTransform(characterVa);
        RMat44 result = new RMat44(matrixVa, true);
        return result;
    }

    @Override
    public boolean hasCollidedWith(int bodyId) {
        long characterVa = this.targetVa();
        boolean result = CharacterVirtual.hasCollidedWithBody(characterVa, bodyId);
        return result;
    }

    @Override
    public boolean hasCollidedWith(ConstCharacterVirtual otherCharacter) {
        long characterVa = this.targetVa();
        long otherVa = otherCharacter.targetVa();
        boolean result = CharacterVirtual.hasCollidedWithCharacter(characterVa, otherVa);
        return result;
    }

    @Override
    public boolean isSlopeTooSteep(Vec3Arg normal) {
        long characterVa = this.targetVa();
        float nx = normal.getX();
        float ny = normal.getY();
        float nz = normal.getZ();
        boolean result = CharacterBase.isSlopeTooSteep(characterVa, nx, ny, nz);
        return result;
    }

    @Override
    public boolean isSupported() {
        long characterVa = this.targetVa();
        boolean result = CharacterBase.isSupported(characterVa);
        return result;
    }

    @Override
    public void saveState(StateRecorder recorder) {
        long characterVa = this.targetVa();
        long recorderVa = recorder.va();
        CharacterBase.saveState(characterVa, recorderVa);
    }

    @Override
    public long targetVa() {
        long refVa = this.va();
        long result = CharacterVirtualRefC.getPtr(refVa);
        return result;
    }

    @Override
    public CharacterVirtualRefC toRefC() {
        long refVa = this.va();
        long copyVa = CharacterVirtualRefC.copy(refVa);
        CharacterVirtualRefC result = new CharacterVirtualRefC(copyVa, this.system);
        return result;
    }

    private static native long copy(long var0);

    private static native void freeWithSystem(long var0, PhysicsSystem var2);

    private static native long getPtr(long var0);
}

