/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EActiveEdgeMode;
import com.github.stephengold.joltjni.enumerate.ECollectFacesMode;
import com.github.stephengold.joltjni.readonly.Vec3Arg;

public class CollideSettingsBase
extends JoltPhysicsObject {
    CollideSettingsBase() {
    }

    public EActiveEdgeMode getActiveEdgeMode() {
        long settingsVa = this.va();
        int ordinal = CollideSettingsBase.getActiveEdgeMode(settingsVa);
        EActiveEdgeMode result = EActiveEdgeMode.values()[ordinal];
        return result;
    }

    public Vec3 getActiveEdgeMovementDirection() {
        long settingsVa = this.va();
        float dx = CollideSettingsBase.getActiveEdgeMovementDirectionX(settingsVa);
        float dy = CollideSettingsBase.getActiveEdgeMovementDirectionY(settingsVa);
        float dz = CollideSettingsBase.getActiveEdgeMovementDirectionZ(settingsVa);
        Vec3 result = new Vec3(dx, dy, dz);
        return result;
    }

    public ECollectFacesMode getCollectFacesMode() {
        long settingsVa = this.va();
        int ordinal = CollideSettingsBase.getCollectFacesMode(settingsVa);
        ECollectFacesMode result = ECollectFacesMode.values()[ordinal];
        return result;
    }

    public float getCollisionTolerance() {
        long settingsVa = this.va();
        float result = CollideSettingsBase.getCollisionTolerance(settingsVa);
        return result;
    }

    public float getPenetrationTolerance() {
        long settingsVa = this.va();
        float result = CollideSettingsBase.getPenetrationTolerance(settingsVa);
        return result;
    }

    public void setActiveEdgeMode(EActiveEdgeMode mode) {
        long settingsVa = this.va();
        int ordinal = mode.ordinal();
        CollideSettingsBase.setActiveEdgeMode(settingsVa, ordinal);
    }

    public void setActiveEdgeMovementDirection(Vec3Arg direction) {
        long settingsVa = this.va();
        float dx = direction.getX();
        float dy = direction.getY();
        float dz = direction.getZ();
        CollideSettingsBase.setActiveEdgeMovementDirection(settingsVa, dx, dy, dz);
    }

    public void setCollectFacesMode(ECollectFacesMode mode) {
        long settingsVa = this.va();
        int ordinal = mode.ordinal();
        CollideSettingsBase.setCollectFacesMode(settingsVa, ordinal);
    }

    public void setCollisionTolerance(float tolerance) {
        long settingsVa = this.va();
        CollideSettingsBase.setCollisionTolerance(settingsVa, tolerance);
    }

    public void setPenetrationTolerance(float tolerance) {
        long settingsVa = this.va();
        CollideSettingsBase.setPenetrationTolerance(settingsVa, tolerance);
    }

    final void setVirtualAddressAsOwner(long settingsVa) {
        Runnable freeingAction = () -> CollideSettingsBase.free(settingsVa);
        this.setVirtualAddress(settingsVa, freeingAction);
    }

    private static native void free(long var0);

    private static native int getActiveEdgeMode(long var0);

    private static native float getActiveEdgeMovementDirectionX(long var0);

    private static native float getActiveEdgeMovementDirectionY(long var0);

    private static native float getActiveEdgeMovementDirectionZ(long var0);

    private static native int getCollectFacesMode(long var0);

    private static native float getCollisionTolerance(long var0);

    private static native float getPenetrationTolerance(long var0);

    private static native void setActiveEdgeMode(long var0, int var2);

    private static native void setActiveEdgeMovementDirection(long var0, float var2, float var3, float var4);

    private static native void setCollectFacesMode(long var0, int var2);

    private static native void setCollisionTolerance(long var0, float var2);

    private static native void setPenetrationTolerance(long var0, float var2);
}

