/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.CollideSettingsBase;
import com.github.stephengold.joltjni.enumerate.EBackFaceMode;

public class CollideShapeSettings
extends CollideSettingsBase {
    public CollideShapeSettings() {
        long settingsVa = CollideShapeSettings.createDefault();
        this.setVirtualAddressAsOwner(settingsVa);
    }

    public CollideShapeSettings(CollideShapeSettings original) {
        long originalVa = original.va();
        long copyVa = CollideShapeSettings.createCopy(originalVa);
        this.setVirtualAddressAsOwner(copyVa);
    }

    public EBackFaceMode getBackFaceMode() {
        long settingsVa = this.va();
        int ordinal = CollideShapeSettings.getBackFaceMode(settingsVa);
        EBackFaceMode result = EBackFaceMode.values()[ordinal];
        return result;
    }

    public float getMaxSeparationDistance() {
        long settingsVa = this.va();
        float result = CollideShapeSettings.getMaxSeparationDistance(settingsVa);
        return result;
    }

    public void setBackFaceMode(EBackFaceMode mode) {
        long settingsVa = this.va();
        int ordinal = mode.ordinal();
        CollideShapeSettings.setBackFaceMode(settingsVa, ordinal);
    }

    public void setMaxSeparationDistance(float distance) {
        long settingsVa = this.va();
        CollideShapeSettings.setMaxSeparationDistance(settingsVa, distance);
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native int getBackFaceMode(long var0);

    private static native float getMaxSeparationDistance(long var0);

    private static native void setBackFaceMode(long var0, int var2);

    private static native void setMaxSeparationDistance(long var0, float var2);
}

