/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.ConvexHullShapeSettings;
import com.github.stephengold.joltjni.ShapeSettings;
import com.github.stephengold.joltjni.readonly.ConstShape;
import com.github.stephengold.joltjni.readonly.ConstShapeSettings;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import com.github.stephengold.joltjni.vhacd.ConvexHull;
import java.nio.FloatBuffer;
import java.util.Collection;

public abstract class CompoundShapeSettings
extends ShapeSettings {
    CompoundShapeSettings() {
    }

    public void addHulls(Collection<ConvexHull> hulls) {
        for (ConvexHull hull : hulls) {
            FloatBuffer points = hull.getPointsAsBuffer();
            int numFloats = points.capacity();
            int numPoints = numFloats / 3;
            ConvexHullShapeSettings childSettings = new ConvexHullShapeSettings(numPoints, points);
            this.addShape(0.0f, 0.0f, 0.0f, childSettings);
            childSettings.close();
        }
    }

    public void addShape(float xOffset, float yOffset, float zOffset, ConstShape subShape) {
        long settingsVa = this.va();
        float rotW = 1.0f;
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        long subShapeVa = subShape.targetVa();
        CompoundShapeSettings.addShape(settingsVa, xOffset, yOffset, zOffset, rotX, rotY, rotZ, rotW, subShapeVa);
    }

    public void addShape(float xOffset, float yOffset, float zOffset, ConstShapeSettings subSettings) {
        long settingsVa = this.va();
        float rotW = 1.0f;
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        long subSettingsVa = subSettings.targetVa();
        CompoundShapeSettings.addShapeSettings(settingsVa, xOffset, yOffset, zOffset, rotX, rotY, rotZ, rotW, subSettingsVa);
    }

    public void addShape(Vec3Arg offset, QuatArg rotation, ConstShape subShape) {
        long settingsVa = this.va();
        float offsetX = offset.getX();
        float offsetY = offset.getY();
        float offsetZ = offset.getZ();
        float rotW = rotation.getW();
        float rotX = rotation.getX();
        float rotY = rotation.getY();
        float rotZ = rotation.getZ();
        long subShapeVa = subShape.targetVa();
        CompoundShapeSettings.addShape(settingsVa, offsetX, offsetY, offsetZ, rotX, rotY, rotZ, rotW, subShapeVa);
    }

    public void addShape(Vec3Arg offset, QuatArg rotation, ConstShapeSettings subSettings) {
        long settingsVa = this.va();
        float offsetX = offset.getX();
        float offsetY = offset.getY();
        float offsetZ = offset.getZ();
        float rotW = rotation.getW();
        float rotX = rotation.getX();
        float rotY = rotation.getY();
        float rotZ = rotation.getZ();
        long subSettingsVa = subSettings.targetVa();
        CompoundShapeSettings.addShapeSettings(settingsVa, offsetX, offsetY, offsetZ, rotX, rotY, rotZ, rotW, subSettingsVa);
    }

    private static native void addShape(long var0, float var2, float var3, float var4, float var5, float var6, float var7, float var8, long var9);

    private static native void addShapeSettings(long var0, float var2, float var3, float var4, float var5, float var6, float var7, float var8, long var9);
}

