/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.TwoBodyConstraintSettings;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EConstraintSpace;
import com.github.stephengold.joltjni.enumerate.EConstraintSubType;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public class ConeConstraintSettings
extends TwoBodyConstraintSettings {
    public ConeConstraintSettings() {
        long settingsVa = ConeConstraintSettings.createDefault();
        this.setVirtualAddressAsCoOwner(settingsVa, EConstraintSubType.Cone);
    }

    public ConeConstraintSettings(ConeConstraintSettings original) {
        long originalVa = original.targetVa();
        long copyVa = ConeConstraintSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa, EConstraintSubType.Cone);
    }

    ConeConstraintSettings(long settingsVa) {
        this.setVirtualAddressAsCoOwner(settingsVa, EConstraintSubType.Cone);
    }

    public float getHalfConeAngle() {
        long settingsVa = this.va();
        float result = ConeConstraintSettings.getHalfConeAngle(settingsVa);
        return result;
    }

    public RVec3 getPoint1() {
        long settingsVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        ConeConstraintSettings.getPoint1(settingsVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    public RVec3 getPoint2() {
        long settingsVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        ConeConstraintSettings.getPoint2(settingsVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    public EConstraintSpace getSpace() {
        long settingsVa = this.va();
        int ordinal = ConeConstraintSettings.getSpace(settingsVa);
        EConstraintSpace result = EConstraintSpace.values()[ordinal];
        return result;
    }

    public Vec3 getTwistAxis1() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        ConeConstraintSettings.getTwistAxis1(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Vec3 getTwistAxis2() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        ConeConstraintSettings.getTwistAxis2(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public void setHalfConeAngle(float halfAngle) {
        long settingsVa = this.va();
        ConeConstraintSettings.setHalfConeAngle(settingsVa, halfAngle);
    }

    public RVec3Arg setPoint1(RVec3Arg location) {
        long settingsVa = this.va();
        double x = location.xx();
        double y = location.yy();
        double z = location.zz();
        ConeConstraintSettings.setPoint1(settingsVa, x, y, z);
        return location;
    }

    public RVec3Arg setPoint2(RVec3Arg location) {
        long settingsVa = this.va();
        double x = location.xx();
        double y = location.yy();
        double z = location.zz();
        ConeConstraintSettings.setPoint2(settingsVa, x, y, z);
        return location;
    }

    public void setSpace(EConstraintSpace space) {
        long settingsVa = this.va();
        int ordinal = space.ordinal();
        ConeConstraintSettings.setSpace(settingsVa, ordinal);
    }

    public Vec3Arg setTwistAxis1(Vec3Arg direction) {
        long settingsVa = this.va();
        float x = direction.getX();
        float y = direction.getY();
        float z = direction.getZ();
        ConeConstraintSettings.setTwistAxis1(settingsVa, x, y, z);
        return direction;
    }

    public Vec3Arg setTwistAxis2(Vec3Arg direction) {
        long settingsVa = this.va();
        float x = direction.getX();
        float y = direction.getY();
        float z = direction.getZ();
        ConeConstraintSettings.setTwistAxis2(settingsVa, x, y, z);
        return direction;
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native float getHalfConeAngle(long var0);

    private static native void getPoint1(long var0, DoubleBuffer var2);

    private static native void getPoint2(long var0, DoubleBuffer var2);

    private static native int getSpace(long var0);

    private static native void getTwistAxis1(long var0, FloatBuffer var2);

    private static native void getTwistAxis2(long var0, FloatBuffer var2);

    private static native void setHalfConeAngle(long var0, float var2);

    private static native void setPoint1(long var0, double var2, double var4, double var6);

    private static native void setPoint2(long var0, double var2, double var4, double var6);

    private static native void setSpace(long var0, int var2);

    private static native void setTwistAxis1(long var0, float var2, float var3, float var4);

    private static native void setTwistAxis2(long var0, float var2, float var3, float var4);
}

