/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.ConeConstraint;
import com.github.stephengold.joltjni.ConstraintRef;
import com.github.stephengold.joltjni.ConstraintSettingsRef;
import com.github.stephengold.joltjni.DistanceConstraint;
import com.github.stephengold.joltjni.FixedConstraint;
import com.github.stephengold.joltjni.GearConstraint;
import com.github.stephengold.joltjni.HingeConstraint;
import com.github.stephengold.joltjni.NonCopyable;
import com.github.stephengold.joltjni.PathConstraint;
import com.github.stephengold.joltjni.PointConstraint;
import com.github.stephengold.joltjni.PulleyConstraint;
import com.github.stephengold.joltjni.RackAndPinionConstraint;
import com.github.stephengold.joltjni.SixDofConstraint;
import com.github.stephengold.joltjni.SliderConstraint;
import com.github.stephengold.joltjni.StateRecorder;
import com.github.stephengold.joltjni.SwingTwistConstraint;
import com.github.stephengold.joltjni.VehicleConstraint;
import com.github.stephengold.joltjni.enumerate.EConstraintSubType;
import com.github.stephengold.joltjni.enumerate.EConstraintType;
import com.github.stephengold.joltjni.readonly.ConstConstraint;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import com.github.stephengold.joltjni.template.Ref;
import com.github.stephengold.joltjni.template.RefTarget;

public abstract class Constraint
extends NonCopyable
implements ConstConstraint,
RefTarget {
    Constraint() {
    }

    static Constraint newConstraint(long constraintVa) {
        Constraint result;
        if (constraintVa == 0L) {
            return null;
        }
        int ordinal = Constraint.getSubType(constraintVa);
        EConstraintSubType subType = EConstraintSubType.values()[ordinal];
        switch (subType) {
            case Cone: {
                result = new ConeConstraint(constraintVa);
                break;
            }
            case Distance: {
                result = new DistanceConstraint(constraintVa);
                break;
            }
            case Fixed: {
                result = new FixedConstraint(constraintVa);
                break;
            }
            case Gear: {
                result = new GearConstraint(constraintVa);
                break;
            }
            case Hinge: {
                result = new HingeConstraint(constraintVa);
                break;
            }
            case Path: {
                result = new PathConstraint(constraintVa);
                break;
            }
            case Point: {
                result = new PointConstraint(constraintVa);
                break;
            }
            case Pulley: {
                result = new PulleyConstraint(constraintVa);
                break;
            }
            case RackAndPinion: {
                result = new RackAndPinionConstraint(constraintVa);
                break;
            }
            case SixDof: {
                result = new SixDofConstraint(constraintVa);
                break;
            }
            case Slider: {
                result = new SliderConstraint(constraintVa);
                break;
            }
            case SwingTwist: {
                result = new SwingTwistConstraint(constraintVa);
                break;
            }
            case Vehicle: {
                result = new VehicleConstraint(constraintVa);
                break;
            }
            default: {
                throw new IllegalArgumentException("subType = " + String.valueOf((Object)subType));
            }
        }
        return result;
    }

    public void notifyShapeChanged(int bodyId, Vec3Arg deltaCom) {
        long constraintVa = this.va();
        float dx = deltaCom.getX();
        float dy = deltaCom.getY();
        float dz = deltaCom.getZ();
        Constraint.notifyShapeChanged(constraintVa, bodyId, dx, dy, dz);
    }

    public void restoreState(StateRecorder recorder) {
        long constraintVa = this.va();
        long recorderVa = recorder.va();
        Constraint.restoreState(constraintVa, recorderVa);
    }

    public void setConstraintPriority(int level) {
        long constraintVa = this.va();
        Constraint.setConstraintPriority(constraintVa, level);
    }

    public void setEnabled(boolean setting) {
        long constraintVa = this.va();
        Constraint.setEnabled(constraintVa, setting);
    }

    public void setNumPositionStepsOverride(int setting) {
        long constraintVa = this.va();
        Constraint.setNumPositionStepsOverride(constraintVa, setting);
    }

    public void setNumVelocityStepsOverride(int setting) {
        long constraintVa = this.va();
        Constraint.setNumVelocityStepsOverride(constraintVa, setting);
    }

    protected final void setVirtualAddressAsCoOwner(long constraintVa) {
        long refVa = Constraint.toRef(constraintVa);
        Runnable freeingAction = () -> ConstraintRef.free(refVa);
        this.setVirtualAddress(constraintVa, freeingAction);
    }

    @Override
    public int getConstraintPriority() {
        long constraintVa = this.va();
        int result = Constraint.getConstraintPriority(constraintVa);
        return result;
    }

    @Override
    public ConstraintSettingsRef getConstraintSettings() {
        long constraintVa = this.va();
        long settingsRefVa = Constraint.getConstraintSettings(constraintVa);
        ConstraintSettingsRef result = new ConstraintSettingsRef(settingsRefVa, true);
        return result;
    }

    @Override
    public boolean getEnabled() {
        long constraintVa = this.va();
        boolean result = Constraint.getEnabled(constraintVa);
        return result;
    }

    @Override
    public int getNumPositionStepsOverride() {
        long constraintVa = this.va();
        int result = Constraint.getNumPositionStepsOverride(constraintVa);
        return result;
    }

    @Override
    public int getNumVelocityStepsOverride() {
        long constraintVa = this.va();
        int result = Constraint.getNumVelocityStepsOverride(constraintVa);
        return result;
    }

    @Override
    public EConstraintSubType getSubType() {
        long constraintVa = this.va();
        int ordinal = Constraint.getSubType(constraintVa);
        EConstraintSubType result = EConstraintSubType.values()[ordinal];
        return result;
    }

    @Override
    public EConstraintType getType() {
        long constraintVa = this.va();
        int ordinal = Constraint.getType(constraintVa);
        EConstraintType result = EConstraintType.values()[ordinal];
        return result;
    }

    @Override
    public boolean isActive() {
        long constraintVa = this.va();
        boolean result = Constraint.isActive(constraintVa);
        return result;
    }

    @Override
    public void saveState(StateRecorder recorder) {
        long constraintVa = this.va();
        long recorderVa = recorder.va();
        Constraint.saveState(constraintVa, recorderVa);
    }

    @Override
    public int getRefCount() {
        long constraintVa = this.va();
        int result = Constraint.getRefCount(constraintVa);
        return result;
    }

    @Override
    public void setEmbedded() {
        long constraintVa = this.va();
        Constraint.setEmbedded(constraintVa);
    }

    @Override
    public Ref toRef() {
        long constraintVa = this.va();
        long refVa = Constraint.toRef(constraintVa);
        ConstraintRef result = new ConstraintRef(refVa, true);
        return result;
    }

    static native int getConstraintPriority(long var0);

    static native long getConstraintSettings(long var0);

    static native int getControllerType(long var0);

    static native boolean getEnabled(long var0);

    static native int getNumPositionStepsOverride(long var0);

    static native int getNumVelocityStepsOverride(long var0);

    private static native int getRefCount(long var0);

    static native int getSubType(long var0);

    static native int getType(long var0);

    static native boolean isActive(long var0);

    static native void notifyShapeChanged(long var0, int var2, float var3, float var4, float var5);

    static native void restoreState(long var0, long var2);

    static native void saveState(long var0, long var2);

    private static native void setConstraintPriority(long var0, int var2);

    private static native void setEmbedded(long var0);

    private static native void setEnabled(long var0, boolean var2);

    private static native void setNumPositionStepsOverride(long var0, int var2);

    private static native void setNumVelocityStepsOverride(long var0, int var2);

    private static native long toRef(long var0);
}

