/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.ConstraintSettings;
import com.github.stephengold.joltjni.template.Ref;

public final class ConstraintSettingsRef
extends Ref {
    public ConstraintSettingsRef() {
        long refVa = ConstraintSettingsRef.createDefault();
        this.setVirtualAddress(refVa, () -> ConstraintSettingsRef.free(refVa));
    }

    ConstraintSettingsRef(long refVa, boolean owner) {
        Runnable freeingAction = owner ? () -> ConstraintSettingsRef.free(refVa) : null;
        this.setVirtualAddress(refVa, freeingAction);
    }

    @Override
    public ConstraintSettings getPtr() {
        long settingsVa = this.targetVa();
        ConstraintSettings result = ConstraintSettings.newConstraintSettings(settingsVa);
        return result;
    }

    @Override
    public long targetVa() {
        long refVa = this.va();
        long result = ConstraintSettingsRef.getPtr(refVa);
        return result;
    }

    @Override
    public ConstraintSettingsRef toRef() {
        long refVa = this.va();
        long copyVa = ConstraintSettingsRef.copy(refVa);
        ConstraintSettingsRef result = new ConstraintSettingsRef(copyVa, true);
        return result;
    }

    private static native long copy(long var0);

    private static native long createDefault();

    static native void free(long var0);

    private static native long getPtr(long var0);
}

