/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.ConvexShapeSettings;
import com.github.stephengold.joltjni.PhysicsMaterial;
import com.github.stephengold.joltjni.enumerate.EShapeSubType;

public class CylinderShapeSettings
extends ConvexShapeSettings {
    public CylinderShapeSettings() {
        long settingsVa = CylinderShapeSettings.createDefault();
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Cylinder);
    }

    public CylinderShapeSettings(CylinderShapeSettings original) {
        long originalVa = original.va();
        long copyVa = CylinderShapeSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa, EShapeSubType.Cylinder);
    }

    public CylinderShapeSettings(float halfHeight, float radius) {
        this(halfHeight, radius, 0.05f);
    }

    public CylinderShapeSettings(float halfHeight, float radius, float convexRadius) {
        this(halfHeight, radius, convexRadius, null);
    }

    public CylinderShapeSettings(float halfHeight, float radius, float convexRadius, PhysicsMaterial material) {
        long materialVa = material == null ? 0L : material.va();
        long settingsVa = CylinderShapeSettings.createShapeSettings(halfHeight, radius, convexRadius, materialVa);
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Cylinder);
    }

    CylinderShapeSettings(long settingsVa) {
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Cylinder);
    }

    public float getConvexRadius() {
        long settingsVa = this.va();
        float result = CylinderShapeSettings.getConvexRadius(settingsVa);
        return result;
    }

    public float getHalfHeight() {
        long settingsVa = this.va();
        float result = CylinderShapeSettings.getHalfHeight(settingsVa);
        return result;
    }

    public float getRadius() {
        long settingsVa = this.va();
        float result = CylinderShapeSettings.getRadius(settingsVa);
        return result;
    }

    public void setConvexRadius(float radius) {
        long settingsVa = this.va();
        CylinderShapeSettings.setConvexRadius(settingsVa, radius);
    }

    public void setHalfHeight(float halfHeight) {
        long settingsVa = this.va();
        CylinderShapeSettings.setHalfHeight(settingsVa, halfHeight);
    }

    public void setRadius(float radius) {
        long settingsVa = this.va();
        CylinderShapeSettings.setRadius(settingsVa, radius);
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native long createShapeSettings(float var0, float var1, float var2, long var3);

    private static native float getConvexRadius(long var0);

    private static native float getHalfHeight(long var0);

    private static native float getRadius(long var0);

    private static native void setConvexRadius(long var0, float var2);

    private static native void setHalfHeight(long var0, float var2);

    private static native void setRadius(long var0, float var2);
}

