/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.AddConvexRadiusTab;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.PointConvexSupport;
import com.github.stephengold.joltjni.Sphere;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.TransformedAaBox;
import com.github.stephengold.joltjni.TransformedSphere;
import com.github.stephengold.joltjni.Vec3;
import java.nio.FloatBuffer;

public class EpaPenetrationDepth
extends JoltPhysicsObject {
    public EpaPenetrationDepth() {
        long epaVa = EpaPenetrationDepth.createDefault();
        this.setVirtualAddress(epaVa, () -> EpaPenetrationDepth.free(epaVa));
    }

    public boolean getPenetrationDepth(PointConvexSupport aExcluding, Sphere aIncluding, float convexRadiusA, PointConvexSupport bExcluding, Sphere bIncluding, float convexRadiusB, float collisionToleranceSq, float penetrationTolerance, Vec3 iov, Vec3 storePointA, Vec3 storePointB) {
        long epaVa = this.va();
        long aExcludingVa = aExcluding.targetVa();
        long aIncludingVa = aIncluding.targetVa();
        long bExcludingVa = bExcluding.targetVa();
        long bIncludingVa = bIncluding.targetVa();
        FloatBuffer fBuf = Temporaries.floatBuffer1.get();
        fBuf.rewind();
        fBuf.put(collisionToleranceSq);
        fBuf.put(penetrationTolerance);
        iov.put(fBuf);
        boolean result = EpaPenetrationDepth.getPenetrationDepthPoints(epaVa, aExcludingVa, aIncludingVa, convexRadiusA, bExcludingVa, bIncludingVa, convexRadiusB, fBuf);
        iov.set(fBuf.get(2), fBuf.get(3), fBuf.get(4));
        storePointA.set(fBuf.get(5), fBuf.get(6), fBuf.get(7));
        storePointB.set(fBuf.get(8), fBuf.get(9), fBuf.get(10));
        return result;
    }

    public boolean getPenetrationDepth(Sphere aExcluding, Sphere aIncluding, float convexRadiusA, Sphere bExcluding, Sphere bIncluding, float convexRadiusB, float collisionToleranceSq, float penetrationTolerance, Vec3 iov, Vec3 storePointA, Vec3 storePointB) {
        long epaVa = this.va();
        long aExcludingVa = aExcluding.targetVa();
        long aIncludingVa = aIncluding.targetVa();
        long bExcludingVa = bExcluding.targetVa();
        long bIncludingVa = bIncluding.targetVa();
        FloatBuffer fBuf = Temporaries.floatBuffer1.get();
        fBuf.rewind();
        fBuf.put(collisionToleranceSq);
        fBuf.put(penetrationTolerance);
        iov.put(fBuf);
        boolean result = EpaPenetrationDepth.getPenetrationDepthSpheres(epaVa, aExcludingVa, aIncludingVa, convexRadiusA, bExcludingVa, bIncludingVa, convexRadiusB, fBuf);
        iov.set(fBuf.get(2), fBuf.get(3), fBuf.get(4));
        storePointA.set(fBuf.get(5), fBuf.get(6), fBuf.get(7));
        storePointB.set(fBuf.get(8), fBuf.get(9), fBuf.get(10));
        return result;
    }

    public boolean getPenetrationDepth(Sphere aExcluding, Sphere aIncluding, float convexRadiusA, TransformedAaBox bExcluding, AddConvexRadiusTab bIncluding, float convexRadiusB, float collisionToleranceSq, float penetrationTolerance, Vec3 iov, Vec3 storePointA, Vec3 storePointB) {
        long epaVa = this.va();
        long aExcludingVa = aExcluding.targetVa();
        long aIncludingVa = aIncluding.targetVa();
        long bExcludingVa = bExcluding.targetVa();
        long bIncludingVa = bIncluding.targetVa();
        FloatBuffer fBuf = Temporaries.floatBuffer1.get();
        fBuf.rewind();
        fBuf.put(collisionToleranceSq);
        fBuf.put(penetrationTolerance);
        iov.put(fBuf);
        boolean result = EpaPenetrationDepth.getPenetrationDepthSphereTab(epaVa, aExcludingVa, aIncludingVa, convexRadiusA, bExcludingVa, bIncludingVa, convexRadiusB, fBuf);
        iov.set(fBuf.get(2), fBuf.get(3), fBuf.get(4));
        storePointA.set(fBuf.get(5), fBuf.get(6), fBuf.get(7));
        storePointB.set(fBuf.get(8), fBuf.get(9), fBuf.get(10));
        return result;
    }

    public boolean getPenetrationDepth(TransformedAaBox aExcluding, AddConvexRadiusTab aIncluding, float convexRadiusA, TransformedAaBox bExcluding, AddConvexRadiusTab bIncluding, float convexRadiusB, float collisionToleranceSq, float penetrationTolerance, Vec3 iov, Vec3 storePointA, Vec3 storePointB) {
        long epaVa = this.va();
        long aExcludingVa = aExcluding.targetVa();
        long aIncludingVa = aIncluding.targetVa();
        long bExcludingVa = bExcluding.targetVa();
        long bIncludingVa = bIncluding.targetVa();
        FloatBuffer fBuf = Temporaries.floatBuffer1.get();
        fBuf.rewind();
        fBuf.put(collisionToleranceSq);
        fBuf.put(penetrationTolerance);
        iov.put(fBuf);
        boolean result = EpaPenetrationDepth.getPenetrationDepthTabs(epaVa, aExcludingVa, aIncludingVa, convexRadiusA, bExcludingVa, bIncludingVa, convexRadiusB, fBuf);
        iov.set(fBuf.get(2), fBuf.get(3), fBuf.get(4));
        storePointA.set(fBuf.get(5), fBuf.get(6), fBuf.get(7));
        storePointB.set(fBuf.get(8), fBuf.get(9), fBuf.get(10));
        return result;
    }

    public boolean getPenetrationDepth(TransformedAaBox aExcluding, TransformedAaBox aIncluding, float convexRadiusA, TransformedSphere bExcluding, TransformedSphere bIncluding, float convexRadiusB, float collisionToleranceSq, float penetrationTolerance, Vec3 iov, Vec3 storePointA, Vec3 storePointB) {
        long epaVa = this.va();
        long aExcludingVa = aExcluding.targetVa();
        long aIncludingVa = aIncluding.targetVa();
        long bExcludingVa = bExcluding.targetVa();
        long bIncludingVa = bIncluding.targetVa();
        FloatBuffer fBuf = Temporaries.floatBuffer1.get();
        fBuf.rewind();
        fBuf.put(collisionToleranceSq);
        fBuf.put(penetrationTolerance);
        iov.put(fBuf);
        boolean result = EpaPenetrationDepth.getPenetrationDepth(epaVa, aExcludingVa, aIncludingVa, convexRadiusA, bExcludingVa, bIncludingVa, convexRadiusB, fBuf);
        iov.set(fBuf.get(2), fBuf.get(3), fBuf.get(4));
        storePointA.set(fBuf.get(5), fBuf.get(6), fBuf.get(7));
        storePointB.set(fBuf.get(8), fBuf.get(9), fBuf.get(10));
        return result;
    }

    private static native long createDefault();

    private static native void free(long var0);

    private static native boolean getPenetrationDepth(long var0, long var2, long var4, float var6, long var7, long var9, float var11, FloatBuffer var12);

    private static native boolean getPenetrationDepthPoints(long var0, long var2, long var4, float var6, long var7, long var9, float var11, FloatBuffer var12);

    private static native boolean getPenetrationDepthSpheres(long var0, long var2, long var4, float var6, long var7, long var9, float var11, FloatBuffer var12);

    private static native boolean getPenetrationDepthSphereTab(long var0, long var2, long var4, float var6, long var7, long var9, float var11, FloatBuffer var12);

    private static native boolean getPenetrationDepthTabs(long var0, long var2, long var4, float var6, long var7, long var9, float var11, FloatBuffer var12);
}

