/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.BodyFilter;
import com.github.stephengold.joltjni.BroadPhaseLayerFilter;
import com.github.stephengold.joltjni.ContactListener;
import com.github.stephengold.joltjni.ObjectLayerPairFilter;
import com.github.stephengold.joltjni.enumerate.EFilterMode;
import com.github.stephengold.joltjni.enumerate.ValidateResult;

public class FilteredContactListener
extends ContactListener {
    private BodyFilter bodyFilter;
    private BroadPhaseLayerFilter bplFilter;
    private ObjectLayerPairFilter olpFilter;

    public FilteredContactListener() {
        long listenerVa = this.createDefault();
        this.setVirtualAddressAsOwner(listenerVa);
    }

    public BodyFilter getBodyFilter() {
        return this.bodyFilter;
    }

    public EFilterMode getBodyFilterMode() {
        long listenerVa = this.va();
        int ordinal = FilteredContactListener.getBodyFilterMode(listenerVa);
        EFilterMode result = EFilterMode.values()[ordinal];
        return result;
    }

    public BroadPhaseLayerFilter getBroadPhaseLayerFilter() {
        return this.bplFilter;
    }

    public EFilterMode getBroadPhaseLayerFilterMode() {
        long listenerVa = this.va();
        int ordinal = FilteredContactListener.getBroadPhaseLayerFilterMode(listenerVa);
        EFilterMode result = EFilterMode.values()[ordinal];
        return result;
    }

    public boolean getEnableAdded() {
        long listenerVa = this.va();
        boolean result = FilteredContactListener.getEnableAdded(listenerVa);
        return result;
    }

    public boolean getEnablePersisted() {
        long listenerVa = this.va();
        boolean result = FilteredContactListener.getEnablePersisted(listenerVa);
        return result;
    }

    public boolean getEnableRemoved() {
        long listenerVa = this.va();
        boolean result = FilteredContactListener.getEnableRemoved(listenerVa);
        return result;
    }

    public boolean getEnableValidate() {
        long listenerVa = this.va();
        boolean result = FilteredContactListener.getEnableValidate(listenerVa);
        return result;
    }

    public ObjectLayerPairFilter getObjectLayerPairFilter() {
        return this.olpFilter;
    }

    public void onContactAdded(long body1Va, long body2Va, long manifoldVa, long settingsVa) {
    }

    public void onContactPersisted(long body1Va, long body2Va, long manifoldVa, long settingsVa) {
    }

    public void onContactRemoved(long pairVa) {
    }

    public int onContactValidate(long body1Va, long body2Va, double baseOffsetX, double baseOffsetY, double baseOffsetZ, long collisionResultVa) {
        int result = ValidateResult.AcceptAllContactsForThisBodyPair.ordinal();
        return result;
    }

    public FilteredContactListener setBodyFilter(BodyFilter bodyFilter) {
        this.bodyFilter = bodyFilter;
        long listenerVa = this.va();
        long bodyFilterVa = bodyFilter.va();
        FilteredContactListener.setBodyFilter(listenerVa, bodyFilterVa);
        return this;
    }

    public FilteredContactListener setBodyFilterMode(EFilterMode mode) {
        long listenerVa = this.va();
        int ordinal = mode.ordinal();
        FilteredContactListener.setBodyFilterMode(listenerVa, ordinal);
        return this;
    }

    public FilteredContactListener setBroadPhaseLayerFilter(BroadPhaseLayerFilter bplFilter) {
        this.bplFilter = bplFilter;
        long listenerVa = this.va();
        long bplFilterVa = bplFilter.va();
        FilteredContactListener.setBroadPhaseLayerFilter(listenerVa, bplFilterVa);
        return this;
    }

    public FilteredContactListener setBroadPhaseLayerFilterMode(EFilterMode mode) {
        long listenerVa = this.va();
        int ordinal = mode.ordinal();
        FilteredContactListener.setBroadPhaseLayerFilterMode(listenerVa, ordinal);
        return this;
    }

    public void setEnableAdded(boolean enable) {
        long listenerVa = this.va();
        FilteredContactListener.setEnableAdded(listenerVa, enable);
    }

    public void setEnablePersisted(boolean enable) {
        long listenerVa = this.va();
        FilteredContactListener.setEnablePersisted(listenerVa, enable);
    }

    public void setEnableRemoved(boolean enable) {
        long listenerVa = this.va();
        FilteredContactListener.setEnableRemoved(listenerVa, enable);
    }

    public void setEnableValidate(boolean enable) {
        long listenerVa = this.va();
        FilteredContactListener.setEnableValidate(listenerVa, enable);
    }

    public FilteredContactListener setObjectLayerPairFilter(ObjectLayerPairFilter olpFilter) {
        this.olpFilter = olpFilter;
        long listenerVa = this.va();
        long olpFilterVa = olpFilter.va();
        FilteredContactListener.setObjectLayerPairFilter(listenerVa, olpFilterVa);
        return this;
    }

    private native long createDefault();

    private static native int getBodyFilterMode(long var0);

    private static native int getBroadPhaseLayerFilterMode(long var0);

    private static native boolean getEnableAdded(long var0);

    private static native boolean getEnablePersisted(long var0);

    private static native boolean getEnableRemoved(long var0);

    private static native boolean getEnableValidate(long var0);

    private static native void setBodyFilter(long var0, long var2);

    private static native void setBodyFilterMode(long var0, int var2);

    private static native void setBroadPhaseLayerFilter(long var0, long var2);

    private static native void setBroadPhaseLayerFilterMode(long var0, int var2);

    private static native void setEnableAdded(long var0, boolean var2);

    private static native void setEnablePersisted(long var0, boolean var2);

    private static native void setEnableRemoved(long var0, boolean var2);

    private static native void setEnableValidate(long var0, boolean var2);

    private static native void setObjectLayerPairFilter(long var0, long var2);
}

