/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.PhysicsMaterialList;
import com.github.stephengold.joltjni.ShapeSettings;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EShapeSubType;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public class HeightFieldShapeSettings
extends ShapeSettings {
    public HeightFieldShapeSettings() {
        long settingsVa = HeightFieldShapeSettings.createDefault();
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.HeightField);
    }

    public HeightFieldShapeSettings(float[] samples, Vec3Arg offset, Vec3Arg scale, int sampleCount) {
        this(samples, offset, scale, sampleCount, null);
    }

    public HeightFieldShapeSettings(float[] samples, Vec3Arg offset, Vec3Arg scale, int sampleCount, byte[] materialIndices) {
        this(samples, offset, scale, sampleCount, materialIndices, new PhysicsMaterialList());
    }

    public HeightFieldShapeSettings(float[] samples, Vec3Arg offset, Vec3Arg scale, int sampleCount, byte[] materialIndices, PhysicsMaterialList materialList) {
        float offsetX = offset.getX();
        float offsetY = offset.getY();
        float offsetZ = offset.getZ();
        float scaleX = scale.getX();
        float scaleY = scale.getY();
        float scaleZ = scale.getZ();
        long listVa = materialList.va();
        long settingsVa = HeightFieldShapeSettings.createSettingsFromArray(samples, offsetX, offsetY, offsetZ, scaleX, scaleY, scaleZ, sampleCount, materialIndices, listVa);
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.HeightField);
    }

    public HeightFieldShapeSettings(FloatBuffer samples, Vec3Arg offset, Vec3Arg scale, int sampleCount) {
        this(samples, offset, scale, sampleCount, null);
    }

    public HeightFieldShapeSettings(FloatBuffer samples, Vec3Arg offset, Vec3Arg scale, int sampleCount, byte[] materialIndices) {
        this(samples, offset, scale, sampleCount, materialIndices, new PhysicsMaterialList());
    }

    public HeightFieldShapeSettings(FloatBuffer samples, Vec3Arg offset, Vec3Arg scale, int sampleCount, byte[] materialIndices, PhysicsMaterialList materialList) {
        float offsetX = offset.getX();
        float offsetY = offset.getY();
        float offsetZ = offset.getZ();
        float scaleX = scale.getX();
        float scaleY = scale.getY();
        float scaleZ = scale.getZ();
        long listVa = materialList.va();
        long settingsVa = HeightFieldShapeSettings.createSettingsFromBuffer(samples, offsetX, offsetY, offsetZ, scaleX, scaleY, scaleZ, sampleCount, materialIndices, listVa);
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.HeightField);
    }

    public HeightFieldShapeSettings(HeightFieldShapeSettings original) {
        long originalVa = original.va();
        long copyVa = HeightFieldShapeSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa, EShapeSubType.HeightField);
    }

    HeightFieldShapeSettings(long settingsVa) {
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.HeightField);
    }

    public float getActiveEdgeCosThresholdAngle() {
        long settingsVa = this.va();
        float result = HeightFieldShapeSettings.getActiveEdgeCosThresholdAngle(settingsVa);
        return result;
    }

    public int getBitsPerSample() {
        long settingsVa = this.va();
        int result = HeightFieldShapeSettings.getBitsPerSample(settingsVa);
        return result;
    }

    public int getBlockSize() {
        long settingsVa = this.va();
        int result = HeightFieldShapeSettings.getBlockSize(settingsVa);
        return result;
    }

    public float getMaxHeightValue() {
        long settingsVa = this.va();
        float result = HeightFieldShapeSettings.getMaxHeightValue(settingsVa);
        return result;
    }

    public float getMinHeightValue() {
        long settingsVa = this.va();
        float result = HeightFieldShapeSettings.getMinHeightValue(settingsVa);
        return result;
    }

    public Vec3 getOffset() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        HeightFieldShapeSettings.getOffset(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public int getSampleCount() {
        long settingsVa = this.va();
        int result = HeightFieldShapeSettings.getSampleCount(settingsVa);
        return result;
    }

    public Vec3 getScale() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        HeightFieldShapeSettings.getScale(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public void setActiveEdgeCosThresholdAngle(float cosine) {
        long settingsVa = this.va();
        HeightFieldShapeSettings.setActiveEdgeCosThresholdAngle(settingsVa, cosine);
    }

    public void setBitsPerSample(int numBits) {
        long settingsVa = this.va();
        HeightFieldShapeSettings.setBitsPerSample(settingsVa, numBits);
    }

    public void setBlockSize(int numRows) {
        long settingsVa = this.va();
        HeightFieldShapeSettings.setBlockSize(settingsVa, numRows);
    }

    public void setMaxHeightValue(float maxHeight) {
        long settingsVa = this.va();
        HeightFieldShapeSettings.setMaxHeightValue(settingsVa, maxHeight);
    }

    public void setMinHeightValue(float minHeight) {
        long settingsVa = this.va();
        HeightFieldShapeSettings.setMinHeightValue(settingsVa, minHeight);
    }

    public void setOffset(Vec3Arg offset) {
        long settingsVa = this.va();
        float dx = offset.getX();
        float dy = offset.getY();
        float dz = offset.getZ();
        HeightFieldShapeSettings.setOffset(settingsVa, dx, dy, dz);
    }

    public void setScale(Vec3Arg scale) {
        long settingsVa = this.va();
        float sx = scale.getX();
        float sy = scale.getY();
        float sz = scale.getZ();
        HeightFieldShapeSettings.setScale(settingsVa, sx, sy, sz);
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native long createSettingsFromArray(float[] var0, float var1, float var2, float var3, float var4, float var5, float var6, int var7, byte[] var8, long var9);

    private static native long createSettingsFromBuffer(FloatBuffer var0, float var1, float var2, float var3, float var4, float var5, float var6, int var7, byte[] var8, long var9);

    private static native float getActiveEdgeCosThresholdAngle(long var0);

    private static native int getBitsPerSample(long var0);

    private static native int getBlockSize(long var0);

    private static native float getMaxHeightValue(long var0);

    private static native float getMinHeightValue(long var0);

    private static native void getOffset(long var0, FloatBuffer var2);

    private static native int getSampleCount(long var0);

    private static native void getScale(long var0, FloatBuffer var2);

    private static native void setActiveEdgeCosThresholdAngle(long var0, float var2);

    private static native void setBitsPerSample(long var0, int var2);

    private static native void setBlockSize(long var0, int var2);

    private static native void setMaxHeightValue(long var0, float var2);

    private static native void setMinHeightValue(long var0, float var2);

    private static native void setOffset(long var0, float var2, float var3, float var4);

    private static native void setScale(long var0, float var2, float var3, float var4);
}

