/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Mat44;
import com.github.stephengold.joltjni.readonly.Mat44Arg;

public class InvBind
extends JoltPhysicsObject {
    public InvBind() {
        long invBindVa = InvBind.createDefault();
        this.setVirtualAddress(invBindVa, () -> InvBind.free(invBindVa));
    }

    public InvBind(int jointIndex, Mat44Arg transform) {
        long transformVa = transform.targetVa();
        long invBindVa = InvBind.create(jointIndex, transformVa);
        this.setVirtualAddress(invBindVa, () -> InvBind.free(invBindVa));
    }

    public Mat44 getInvBind() {
        long invBindVa = this.va();
        long resultVa = InvBind.getInvBind(invBindVa);
        Mat44 result = new Mat44(resultVa, true);
        return result;
    }

    public int getJointIndex() {
        long invBindVa = this.va();
        int result = InvBind.getJointIndex(invBindVa);
        return result;
    }

    private static native long create(int var0, long var1);

    private static native long createDefault();

    private static native void free(long var0);

    private static native long getInvBind(long var0);

    private static native int getJointIndex(long var0);
}

