/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.CollisionEstimationResult;
import com.github.stephengold.joltjni.RayInvDirection;
import com.github.stephengold.joltjni.readonly.ConstBody;
import com.github.stephengold.joltjni.readonly.ConstContactManifold;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.HashSet;
import java.util.Set;

public final class Jolt {
    public static final float cDefaultConvexRadius = 0.05f;
    public static final float JPH_PI = (float)Math.PI;
    public static final int cEmptySubShapeId = -1;
    public static final int cInvalidBodyId = -1;
    public static final int cMaxPhysicsBarriers = 8;
    public static final int cMaxPhysicsJobs = 2048;
    public static final int SWIZZLE_X = 0;
    public static final int SWIZZLE_Y = 1;
    public static final int SWIZZLE_Z = 2;
    public static final Object nullptr = null;

    private Jolt() {
    }

    public static native float aCos(float var0);

    public static native float aTan(float var0);

    public static native float aTan2(float var0, float var1);

    public static native String buildType();

    public static native float cos(float var0);

    public static native int countDeletes();

    public static native int countNews();

    public static float degreesToRadians(float degrees) {
        float result = degrees * ((float)Math.PI / 180);
        return result;
    }

    public static native void destroyFactory();

    public static native void detLog(String var0);

    public static void estimateCollisionResponse(ConstBody body1, ConstBody body2, ConstContactManifold manifold, CollisionEstimationResult storeResult, float combinedFriction, float combinedRestitution) {
        Jolt.estimateCollisionResponse(body1, body2, manifold, storeResult, combinedFriction, combinedRestitution, 1.0f);
    }

    public static void estimateCollisionResponse(ConstBody body1, ConstBody body2, ConstContactManifold manifold, CollisionEstimationResult storeResult, float combinedFriction, float combinedRestitution, float minVelocity) {
        Jolt.estimateCollisionResponse(body1, body2, manifold, storeResult, combinedFriction, combinedRestitution, minVelocity, 10);
    }

    public static void estimateCollisionResponse(ConstBody body1, ConstBody body2, ConstContactManifold manifold, CollisionEstimationResult storeResult, float combinedFriction, float combinedRestitution, float minVelocity, int numIterations) {
        long body1Va = body1.targetVa();
        long body2Va = body2.targetVa();
        long manifoldVa = manifold.targetVa();
        long resultVa = storeResult.va();
        Jolt.estimateCollisionResponse(body1Va, body2Va, manifoldVa, resultVa, combinedFriction, combinedRestitution, minVelocity, numIterations);
    }

    public static native String getConfigurationString();

    public static native long hashBytes(long var0, int var2);

    public static long hashBytes(QuatArg quaternion, long oldHash) {
        float qw = quaternion.getW();
        float qx = quaternion.getX();
        float qy = quaternion.getY();
        float qz = quaternion.getZ();
        long result = Jolt.hashBytes(qx, qy, qz, qw, oldHash);
        return result;
    }

    public static long hashBytes(RVec3Arg vector, long oldHash) {
        double xx = vector.xx();
        double yy = vector.yy();
        double zz = vector.zz();
        long result = Jolt.hashBytes(xx, yy, zz, oldHash);
        return result;
    }

    public static native long hashCombine(long var0, int var2);

    public static native long hashCombine(long var0, long var2);

    public static long hashCombine(long oldHash, RVec3Arg vector) {
        double xx = vector.xx();
        double yy = vector.yy();
        double zz = vector.zz();
        long result = Jolt.hashCombineRVec3(oldHash, xx, yy, zz);
        return result;
    }

    public static long hashCombine(long oldHash, Vec3Arg vector) {
        float x = vector.getX();
        float y = vector.getY();
        float z = vector.getZ();
        long result = Jolt.hashCombineVec3(oldHash, x, y, z);
        return result;
    }

    public static native boolean implementsDebugRendering();

    public static native boolean implementsDeterminismLog();

    public static native void installDefaultAssertCallback();

    public static native void installCerrTraceCallback();

    public static native void installDefaultTraceCallback();

    public static native void installJavaTraceCallback(PrintStream var0);

    public static native boolean isDoublePrecision();

    public static Set<Class<?>> listClasses(String packageName) {
        String resourcePath;
        ClassLoader loader = Jolt.class.getClassLoader();
        InputStream stream = loader.getResourceAsStream(resourcePath = packageName.replaceAll("[.]", "/"));
        if (stream == null) {
            System.err.println("resourcePath = " + resourcePath);
            System.exit(1);
        }
        InputStreamReader isr = new InputStreamReader(stream);
        BufferedReader reader = new BufferedReader(isr);
        HashSet result = new HashSet();
        block4: while (true) {
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (!line.endsWith(".class")) continue;
                    int dotPos = line.lastIndexOf(46);
                    String className = line.substring(0, dotPos);
                    try {
                        Class<?> cl = Class.forName(packageName + "." + className);
                        result.add(cl);
                        continue block4;
                    }
                    catch (ClassNotFoundException exception) {
                        System.err.println("className = " + className);
                        System.exit(0);
                    }
                }
                break;
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
        return result;
    }

    public static ByteBuffer newDirectByteBuffer(int numBytes) {
        ByteBuffer result = ByteBuffer.allocateDirect(numBytes);
        result.order(ByteOrder.nativeOrder());
        assert (result.capacity() == numBytes) : result.capacity();
        assert (result.limit() == numBytes) : result.limit();
        assert (result.position() == 0) : result.position();
        return result;
    }

    public static DoubleBuffer newDirectDoubleBuffer(int numDoubles) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(numDoubles * 8);
        byteBuffer.order(ByteOrder.nativeOrder());
        DoubleBuffer result = byteBuffer.asDoubleBuffer();
        assert (result.capacity() == numDoubles) : result.capacity();
        assert (result.limit() == numDoubles) : result.limit();
        assert (result.position() == 0) : result.position();
        return result;
    }

    public static FloatBuffer newDirectFloatBuffer(int numFloats) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(numFloats * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer result = byteBuffer.asFloatBuffer();
        assert (result.capacity() == numFloats) : result.capacity();
        assert (result.limit() == numFloats) : result.limit();
        assert (result.position() == 0) : result.position();
        return result;
    }

    public static IntBuffer newDirectIntBuffer(int numInts) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(numInts * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        IntBuffer result = byteBuffer.asIntBuffer();
        assert (result.capacity() == numInts) : result.capacity();
        assert (result.limit() == numInts) : result.limit();
        assert (result.position() == 0) : result.position();
        return result;
    }

    public static ShortBuffer newDirectShortBuffer(int numShorts) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(numShorts * 2);
        byteBuffer.order(ByteOrder.nativeOrder());
        ShortBuffer result = byteBuffer.asShortBuffer();
        assert (result.capacity() == numShorts) : result.capacity();
        assert (result.limit() == numShorts) : result.limit();
        assert (result.position() == 0) : result.position();
        return result;
    }

    public static native boolean newFactory();

    public static native float perlinNoise3(float var0, float var1, float var2, int var3, int var4, int var5);

    public static native void profileDump(String var0);

    public static native void profileEnd();

    public static native void profileNextFrame();

    public static native void profileStart(String var0);

    public static float radiansToDegrees(float radians) {
        float result = radians * 57.295776f;
        return result;
    }

    public static float rayAaBox(Vec3Arg rayOrigin, RayInvDirection invDirection, Vec3Arg minimum, Vec3Arg maximum) {
        float originX = rayOrigin.getX();
        float originY = rayOrigin.getY();
        float originZ = rayOrigin.getZ();
        long invDirVa = invDirection.va();
        float minX = minimum.getX();
        float minY = minimum.getY();
        float minZ = minimum.getZ();
        float maxX = maximum.getX();
        float maxY = maximum.getY();
        float maxZ = maximum.getZ();
        float result = Jolt.rayAaBox(originX, originY, originZ, invDirVa, minX, minY, minZ, maxX, maxY, maxZ);
        return result;
    }

    public static boolean rayAaBoxHits(Vec3Arg startLocation, Vec3Arg offset, Vec3Arg minimum, Vec3Arg maximum) {
        float startX = startLocation.getX();
        float startY = startLocation.getY();
        float startZ = startLocation.getZ();
        float offsetX = offset.getX();
        float offsetY = offset.getY();
        float offsetZ = offset.getZ();
        float minX = minimum.getX();
        float minY = minimum.getY();
        float minZ = minimum.getZ();
        float maxX = maximum.getX();
        float maxY = maximum.getY();
        float maxZ = maximum.getZ();
        boolean result = Jolt.rayAaBoxHits(startX, startY, startZ, offsetX, offsetY, offsetZ, minX, minY, minZ, maxX, maxY, maxZ);
        return result;
    }

    public static float rayCapsule(Vec3Arg rayOrigin, Vec3Arg rayDirection, float capsuleHalfHeight, float capsuleRadius) {
        float originX = rayOrigin.getX();
        float originY = rayOrigin.getY();
        float originZ = rayOrigin.getZ();
        float directionX = rayDirection.getX();
        float directionY = rayDirection.getY();
        float directionZ = rayDirection.getZ();
        float result = Jolt.rayCapsule(originX, originY, originZ, directionX, directionY, directionZ, capsuleHalfHeight, capsuleRadius);
        return result;
    }

    public static float rayCylinder(Vec3Arg rayOrigin, Vec3Arg rayDirection, float cylinderRadius) {
        float originX = rayOrigin.getX();
        float originY = rayOrigin.getY();
        float originZ = rayOrigin.getZ();
        float directionX = rayDirection.getX();
        float directionY = rayDirection.getY();
        float directionZ = rayDirection.getZ();
        float result = Jolt.rayInfiniteCylinder(originX, originY, originZ, directionX, directionY, directionZ, cylinderRadius);
        return result;
    }

    public static float rayCylinder(Vec3Arg rayOrigin, Vec3Arg rayDirection, float cylinderHalfHeight, float cylinderRadius) {
        float originX = rayOrigin.getX();
        float originY = rayOrigin.getY();
        float originZ = rayOrigin.getZ();
        float directionX = rayDirection.getX();
        float directionY = rayDirection.getY();
        float directionZ = rayDirection.getZ();
        float result = Jolt.rayFiniteCylinder(originX, originY, originZ, directionX, directionY, directionZ, cylinderHalfHeight, cylinderRadius);
        return result;
    }

    public static float raySphere(Vec3Arg rayOrigin, Vec3Arg rayDirection, Vec3Arg sphereCenter, float sphereRadius) {
        float originX = rayOrigin.getX();
        float originY = rayOrigin.getY();
        float originZ = rayOrigin.getZ();
        float directionX = rayDirection.getX();
        float directionY = rayDirection.getY();
        float directionZ = rayDirection.getZ();
        float centerX = sphereCenter.getX();
        float centerY = sphereCenter.getY();
        float centerZ = sphereCenter.getZ();
        float result = Jolt.raySphere(originX, originY, originZ, directionX, directionY, directionZ, centerX, centerY, centerZ, sphereRadius);
        return result;
    }

    public static float rayTriangle(Vec3Arg rayOrigin, Vec3Arg rayDirection, Vec3Arg v0, Vec3Arg v1, Vec3Arg v2) {
        float originX = rayOrigin.getX();
        float originY = rayOrigin.getY();
        float originZ = rayOrigin.getZ();
        float directionX = rayDirection.getX();
        float directionY = rayDirection.getY();
        float directionZ = rayDirection.getZ();
        float v0x = v0.getX();
        float v0y = v0.getY();
        float v0z = v0.getZ();
        float v1x = v1.getX();
        float v1y = v1.getY();
        float v1z = v1.getZ();
        float v2x = v2.getX();
        float v2y = v2.getY();
        float v2z = v2.getZ();
        float result = Jolt.rayTriangle(originX, originY, originZ, directionX, directionY, directionZ, v0x, v0y, v0z, v1x, v1y, v1z, v2x, v2y, v2z);
        return result;
    }

    public static native void registerCustomAllocator(long var0, long var2, long var4, long var6, long var8);

    public static native void registerDefaultAllocator();

    public static native void registerTypes();

    public static native void setTraceAllocations(boolean var0);

    public static float sign(float input) {
        float result = input < 0.0f ? -1.0f : 1.0f;
        return result;
    }

    public static native float sin(float var0);

    public static float square(float value) {
        float result = value * value;
        return result;
    }

    public static int square(int value) {
        int result = value * value;
        return result;
    }

    public static void sSetNextCharacterId() {
        Jolt.sSetNextCharacterId(1);
    }

    public static native void sSetNextCharacterId(int var0);

    public static native boolean supportsObjectStream();

    public static native float tan(float var0);

    public static native void test000(String ... var0);

    public static native void unregisterTypes();

    public static native String versionString();

    private static native void estimateCollisionResponse(long var0, long var2, long var4, long var6, float var8, float var9, float var10, int var11);

    private static native long hashBytes(double var0, double var2, double var4, long var6);

    private static native long hashBytes(float var0, float var1, float var2, float var3, long var4);

    private static native long hashCombineRVec3(long var0, double var2, double var4, double var6);

    private static native long hashCombineVec3(long var0, float var2, float var3, float var4);

    private static native float rayAaBox(float var0, float var1, float var2, long var3, float var5, float var6, float var7, float var8, float var9, float var10);

    private static native boolean rayAaBoxHits(float var0, float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11);

    private static native float rayCapsule(float var0, float var1, float var2, float var3, float var4, float var5, float var6, float var7);

    private static native float rayFiniteCylinder(float var0, float var1, float var2, float var3, float var4, float var5, float var6, float var7);

    private static native float rayInfiniteCylinder(float var0, float var1, float var2, float var3, float var4, float var5, float var6);

    private static native float raySphere(float var0, float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9);

    private static native float rayTriangle(float var0, float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14);
}

