/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.readonly.ConstJoltPhysicsObject;
import com.github.stephengold.joltjni.template.Ref;
import java.lang.ref.Cleaner;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public abstract class JoltPhysicsObject
implements AutoCloseable,
ConstJoltPhysicsObject {
    private final AtomicLong virtualAddress = new AtomicLong(0L);
    private final AtomicReference<Runnable> freeingActionRef = new AtomicReference();
    private static Cleaner cleaner;
    private final JoltPhysicsObject containingObject;

    protected JoltPhysicsObject() {
        this.containingObject = null;
    }

    protected JoltPhysicsObject(JoltPhysicsObject container, long va) {
        assert (va != 0L);
        this.virtualAddress.set(va);
        assert (container == null || container.ownsNativeObject()) : container;
        this.containingObject = container;
    }

    public static boolean isCleanerStarted() {
        return cleaner != null;
    }

    public static void startCleaner() {
        if (cleaner == null) {
            cleaner = Cleaner.create();
        } else {
            System.out.println("A cleaner has already been started.");
        }
    }

    public final long va() {
        long addr = this.virtualAddress.get();
        assert (addr != 0L) : "Attempted to use an object that has already been freed: " + String.valueOf(this);
        return addr;
    }

    protected final JoltPhysicsObject getContainingObject() {
        return this.containingObject;
    }

    protected final void setVirtualAddress(long va) {
        assert (va != 0L) : "invalid virtual address";
        assert (!this.hasAssignedNativeObject()) : "native object already assigned";
        assert (this.freeingActionRef.get() == null);
        this.virtualAddress.set(va);
    }

    protected final void setVirtualAddress(long va, Runnable action) {
        this.setVirtualAddress(va);
        if (action != null) {
            assert (this.containingObject == null) : this.containingObject;
            this.freeingActionRef.set(action);
            if (cleaner != null) {
                cleaner.register(this, new CleanerRunnable(this.freeingActionRef, this.virtualAddress));
            }
        }
    }

    @Override
    public void close() {
        JoltPhysicsObject.executeCleanup(this.freeingActionRef, this.virtualAddress);
    }

    @Override
    public int compareTo(JoltPhysicsObject other) {
        long otherVa = other.va();
        int result = Long.compare(this.virtualAddress.get(), otherVa);
        return result;
    }

    @Override
    public final boolean hasAssignedNativeObject() {
        return this.virtualAddress.get() != 0L;
    }

    @Override
    public final boolean ownsNativeObject() {
        return this.freeingActionRef.get() != null;
    }

    @Override
    public long targetVa() {
        assert (!(this instanceof Ref)) : this.getClass().getSimpleName() + " must override targetVa()";
        return this.va();
    }

    public boolean equals(Object otherObject) {
        boolean result;
        if (otherObject == this) {
            result = true;
        } else if (otherObject != null && otherObject.getClass() == this.getClass()) {
            JoltPhysicsObject otherJpo = (JoltPhysicsObject)otherObject;
            result = this.virtualAddress.get() == otherJpo.virtualAddress.get();
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        int result = (int)(this.virtualAddress.get() >> 4);
        return result;
    }

    public String toString() {
        Object result = this.getClass().getSimpleName();
        result = (String)result + "#" + Long.toHexString(this.virtualAddress.get());
        return result;
    }

    private static void executeCleanup(AtomicReference<Runnable> actionRef, AtomicLong addressRef) {
        Runnable action = actionRef.getAndSet(null);
        if (action != null) {
            action.run();
            addressRef.set(0L);
        }
    }

    private static class CleanerRunnable
    implements Runnable {
        private final AtomicLong addressRef;
        private final AtomicReference<Runnable> actionRef;

        CleanerRunnable(AtomicReference<Runnable> actionRef, AtomicLong addressRef) {
            this.actionRef = actionRef;
            this.addressRef = addressRef;
        }

        @Override
        public void run() {
            JoltPhysicsObject.executeCleanup(this.actionRef, this.addressRef);
        }
    }
}

