/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Mat44;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.ConstMassProperties;
import com.github.stephengold.joltjni.readonly.Mat44Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;

public final class MassProperties
extends JoltPhysicsObject
implements ConstMassProperties {
    public MassProperties() {
        long propertiesVa = MassProperties.createDefault();
        this.setVirtualAddress(propertiesVa, () -> MassProperties.free(propertiesVa));
    }

    public MassProperties(ConstMassProperties original) {
        long originalVa = original.targetVa();
        long copyVa = MassProperties.createCopy(originalVa);
        this.setVirtualAddress(copyVa, () -> MassProperties.free(copyVa));
    }

    MassProperties(JoltPhysicsObject container, long propertiesVa) {
        super(container, propertiesVa);
    }

    MassProperties(long propertiesVa, boolean owner) {
        Runnable freeingAction = owner ? () -> MassProperties.free(propertiesVa) : null;
        this.setVirtualAddress(propertiesVa, freeingAction);
    }

    public void rotate(Mat44Arg rotation) {
        long propertiesVa = this.va();
        long matrixVa = rotation.targetVa();
        MassProperties.rotate(propertiesVa, matrixVa);
    }

    public void scale(Vec3Arg scaleFactors) {
        long propertiesVa = this.va();
        float x = scaleFactors.getX();
        float y = scaleFactors.getY();
        float z = scaleFactors.getZ();
        MassProperties.scale(propertiesVa, x, y, z);
    }

    public void scaleToMass(float mass) {
        long propertiesVa = this.va();
        MassProperties.scaleToMass(propertiesVa, mass);
    }

    public MassProperties setInertia(Mat44Arg inertia) {
        long propertiesVa = this.va();
        long matrixVa = inertia.targetVa();
        MassProperties.setInertia(propertiesVa, matrixVa);
        return this;
    }

    public MassProperties setMass(float mass) {
        long propertiesVa = this.va();
        MassProperties.setMass(propertiesVa, mass);
        return this;
    }

    public void setMassAndInertiaOfSolidBox(Vec3Arg boxSize, float density) {
        long propertiesVa = this.va();
        float sx = boxSize.getX();
        float sy = boxSize.getY();
        float sz = boxSize.getZ();
        MassProperties.setMassAndInertiaOfSolidBox(propertiesVa, sx, sy, sz, density);
    }

    public void translate(Vec3Arg offset) {
        long propertiesVa = this.va();
        float x = offset.getX();
        float y = offset.getY();
        float z = offset.getZ();
        MassProperties.translate(propertiesVa, x, y, z);
    }

    @Override
    public boolean decomposePrincipalMomentsOfInertia(Mat44 storeRotation, Vec3 storeDiagonal) {
        long propertiesVa = this.va();
        long matrixVa = storeRotation.va();
        float[] diagonal = new float[3];
        boolean result = MassProperties.decomposePrincipalMomentsOfInertia(propertiesVa, matrixVa, diagonal);
        storeDiagonal.set(diagonal);
        return result;
    }

    @Override
    public Mat44 getInertia() {
        long propertiesVa = this.va();
        long matrixVa = MassProperties.getInertia(propertiesVa);
        Mat44 result = new Mat44(matrixVa, true);
        return result;
    }

    @Override
    public float getMass() {
        long propertiesVa = this.va();
        float result = MassProperties.getMass(propertiesVa);
        return result;
    }

    @Override
    public String toString() {
        String result = "MassProperties(mass=" + this.getMass() + " inertia=" + String.valueOf(this.getInertia()) + ")";
        return result;
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native boolean decomposePrincipalMomentsOfInertia(long var0, long var2, float[] var4);

    private static native void free(long var0);

    private static native long getInertia(long var0);

    private static native float getMass(long var0);

    private static native void rotate(long var0, long var2);

    private static native void scale(long var0, float var2, float var3, float var4);

    private static native void scaleToMass(long var0, float var2);

    private static native void setInertia(long var0, long var2);

    private static native void setMass(long var0, float var2);

    private static native void setMassAndInertiaOfSolidBox(long var0, float var2, float var3, float var4, float var5);

    private static native void translate(long var0, float var2, float var3, float var4);
}

