/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Mat44;
import com.github.stephengold.joltjni.readonly.Mat44Arg;

public class Mat44Array
extends JoltPhysicsObject {
    public Mat44Array(int length) {
        long arrayVa = Mat44Array.create(length);
        this.setVirtualAddress(arrayVa, () -> Mat44Array.free(arrayVa));
    }

    Mat44Array(JoltPhysicsObject container, long arrayVa) {
        super(container, arrayVa);
    }

    public Mat44 get(int elementIndex) {
        long arrayVa = this.va();
        long matrixVa = Mat44Array.getMatrix(arrayVa, elementIndex);
        Mat44 result = new Mat44(this, matrixVa);
        return result;
    }

    public void set(int elementIndex, Mat44Arg matrix) {
        long arrayVa = this.va();
        long matrixVa = matrix.targetVa();
        Mat44Array.setMatrix(arrayVa, elementIndex, matrixVa);
    }

    private static native long create(int var0);

    private static native void free(long var0);

    private static native long getMatrix(long var0, int var2);

    private static native void setMatrix(long var0, int var2, long var3);
}

