/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.MotorSettings;
import com.github.stephengold.joltjni.PathConstraintPath;
import com.github.stephengold.joltjni.TwoBodyConstraint;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EMotorState;
import com.github.stephengold.joltjni.readonly.ConstPathConstraintPath;

public class PathConstraint
extends TwoBodyConstraint {
    PathConstraint(long constraintVa) {
        this.setVirtualAddressAsCoOwner(constraintVa);
    }

    public float getMaxFrictionForce() {
        long constraintVa = this.va();
        float result = PathConstraint.getMaxFrictionForce(constraintVa);
        return result;
    }

    public ConstPathConstraintPath getPath() {
        long constraintVa = this.va();
        long pathVa = PathConstraint.getPath(constraintVa);
        PathConstraintPath result = PathConstraintPath.newPath(pathVa);
        return result;
    }

    public float getPathFraction() {
        long constraintVa = this.va();
        float result = PathConstraint.getPathFraction(constraintVa);
        return result;
    }

    public MotorSettings getPositionMotorSettings() {
        long constraintVa = this.va();
        long settingsVa = PathConstraint.getPositionMotorSettings(constraintVa);
        MotorSettings result = new MotorSettings(this, settingsVa);
        return result;
    }

    public EMotorState getPositionMotorState() {
        long constraintVa = this.va();
        int ordinal = PathConstraint.getPositionMotorState(constraintVa);
        EMotorState result = EMotorState.values()[ordinal];
        return result;
    }

    public float getTargetPathFraction() {
        long constraintVa = this.va();
        float result = PathConstraint.getTargetPathFraction(constraintVa);
        return result;
    }

    public float getTargetVelocity() {
        long constraintVa = this.va();
        float result = PathConstraint.getTargetVelocity(constraintVa);
        return result;
    }

    public float getTotalLambdaMotor() {
        long constraintVa = this.va();
        float result = PathConstraint.getTotalLambdaMotor(constraintVa);
        return result;
    }

    public float getTotalLambdaPositionLimits() {
        long constraintVa = this.va();
        float result = PathConstraint.getTotalLambdaPositionLimits(constraintVa);
        return result;
    }

    public Vec3 getTotalLambdaRotation() {
        long constraintVa = this.va();
        float x = PathConstraint.getTotalLambdaRotationX(constraintVa);
        float y = PathConstraint.getTotalLambdaRotationY(constraintVa);
        float z = PathConstraint.getTotalLambdaRotationZ(constraintVa);
        Vec3 result = new Vec3(x, y, z);
        return result;
    }

    public void setMaxFrictionForce(float force) {
        long constraintVa = this.va();
        PathConstraint.setMaxFrictionForce(constraintVa, force);
    }

    public void setPath(PathConstraintPath path, float amount) {
        long constraintVa = this.va();
        long pathVa = path.va();
        PathConstraint.setPath(constraintVa, pathVa, amount);
    }

    public void setPositionMotorState(EMotorState state) {
        long constraintVa = this.va();
        int ordinal = state.ordinal();
        PathConstraint.setPositionMotorState(constraintVa, ordinal);
    }

    public void setTargetPathFraction(float amount) {
        long constraintVa = this.va();
        PathConstraint.setTargetPathFraction(constraintVa, amount);
    }

    public void setTargetVelocity(float speed) {
        long constraintVa = this.va();
        PathConstraint.setTargetVelocity(constraintVa, speed);
    }

    private static native float getMaxFrictionForce(long var0);

    private static native long getPath(long var0);

    private static native float getPathFraction(long var0);

    private static native long getPositionMotorSettings(long var0);

    private static native int getPositionMotorState(long var0);

    private static native float getTargetPathFraction(long var0);

    private static native float getTargetVelocity(long var0);

    private static native float getTotalLambdaMotor(long var0);

    private static native float getTotalLambdaPositionLimits(long var0);

    private static native float getTotalLambdaRotationX(long var0);

    private static native float getTotalLambdaRotationY(long var0);

    private static native float getTotalLambdaRotationZ(long var0);

    private static native void setMaxFrictionForce(long var0, float var2);

    private static native void setPath(long var0, long var2, float var4);

    private static native void setPositionMotorState(long var0, int var2);

    private static native void setTargetPathFraction(long var0, float var2);

    private static native void setTargetVelocity(long var0, float var2);
}

