/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.PathConstraintPathHermite;
import com.github.stephengold.joltjni.PathConstraintPathRef;
import com.github.stephengold.joltjni.PathResult;
import com.github.stephengold.joltjni.Rtti;
import com.github.stephengold.joltjni.SerializableObject;
import com.github.stephengold.joltjni.StreamIn;
import com.github.stephengold.joltjni.StreamOut;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.ConstPathConstraintPath;
import com.github.stephengold.joltjni.readonly.Vec3Arg;

public class PathConstraintPath
extends SerializableObject
implements ConstPathConstraintPath {
    PathConstraintPath() {
    }

    static PathConstraintPath newPath(long pathVa) {
        PathConstraintPathHermite result;
        String typeName;
        if (pathVa == 0L) {
            return null;
        }
        long rttiVa = SerializableObject.getRtti(pathVa);
        switch (typeName = Rtti.getName(rttiVa)) {
            case "PathConstraintPathHermite": {
                result = new PathConstraintPathHermite(pathVa);
                break;
            }
            default: {
                throw new IllegalArgumentException("typeName = " + typeName);
            }
        }
        return result;
    }

    public void setIsLooping(boolean setting) {
        long pathVa = this.va();
        PathConstraintPath.setIsLooping(pathVa, setting);
    }

    public static PathResult sRestoreFromBinaryState(StreamIn stream) {
        long streamVa = stream.va();
        long resultVa = PathConstraintPath.sRestoreFromBinaryState(streamVa);
        PathResult result = new PathResult(resultVa, true);
        return result;
    }

    protected final void setVirtualAddressAsCoOwner(long pathVa) {
        long refVa = PathConstraintPath.toRef(pathVa);
        Runnable freeingAction = () -> PathConstraintPathRef.free(refVa);
        this.setVirtualAddress(pathVa, freeingAction);
    }

    @Override
    public float getClosestPoint(Vec3Arg location, float fractionHint) {
        long pathVa = this.va();
        float x = location.getX();
        float y = location.getY();
        float z = location.getZ();
        float result = PathConstraintPath.getClosestPoint(pathVa, x, y, z, fractionHint);
        return result;
    }

    @Override
    public float getPathMaxFraction() {
        long pathVa = this.va();
        float result = PathConstraintPath.getPathMaxFraction(pathVa);
        return result;
    }

    @Override
    public void getPointOnPath(float amount, Vec3 storeLocation, Vec3 storeTangent, Vec3 storeNormal, Vec3 storeBinormal) {
        long pathVa = this.va();
        float[] storeFloats = new float[12];
        PathConstraintPath.getPointOnPath(pathVa, amount, storeFloats);
        storeLocation.set(storeFloats);
        storeTangent.set(storeFloats[3], storeFloats[4], storeFloats[5]);
        storeNormal.set(storeFloats[6], storeFloats[7], storeFloats[8]);
        storeBinormal.set(storeFloats[9], storeFloats[10], storeFloats[11]);
    }

    @Override
    public boolean isLooping() {
        long pathVa = this.va();
        boolean result = PathConstraintPath.isLooping(pathVa);
        return result;
    }

    @Override
    public void saveBinaryState(StreamOut stream) {
        long pathVa = this.va();
        long streamVa = stream.va();
        PathConstraintPath.saveBinaryState(pathVa, streamVa);
    }

    @Override
    public int getRefCount() {
        long pathVa = this.va();
        int result = PathConstraintPath.getRefCount(pathVa);
        return result;
    }

    @Override
    public void setEmbedded() {
        long pathVa = this.va();
        PathConstraintPath.setEmbedded(pathVa);
    }

    @Override
    public PathConstraintPathRef toRef() {
        long pathVa = this.va();
        long copyVa = PathConstraintPath.toRef(pathVa);
        PathConstraintPathRef result = new PathConstraintPathRef(copyVa, true);
        return result;
    }

    private static native float getClosestPoint(long var0, float var2, float var3, float var4, float var5);

    private static native float getPathMaxFraction(long var0);

    private static native void getPointOnPath(long var0, float var2, float[] var3);

    private static native int getRefCount(long var0);

    private static native boolean isLooping(long var0);

    private static native void saveBinaryState(long var0, long var2);

    private static native void setEmbedded(long var0);

    private static native void setIsLooping(long var0, boolean var2);

    private static native long sRestoreFromBinaryState(long var0);

    private static native long toRef(long var0);
}

