/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.PhysicsMaterialRef;
import com.github.stephengold.joltjni.template.Array;

public class PhysicsMaterialList
extends Array<PhysicsMaterialRef> {
    public PhysicsMaterialList() {
        long listVa = PhysicsMaterialList.createDefault();
        this.setVirtualAddress(listVa, () -> PhysicsMaterialList.free(listVa));
    }

    @Override
    public int capacity() {
        long listVa = this.va();
        int result = PhysicsMaterialList.capacity(listVa);
        return result;
    }

    @Override
    public void erase(int startIndex, int stopIndex) {
        long vectorVa = this.va();
        PhysicsMaterialList.erase(vectorVa, startIndex, stopIndex);
    }

    @Override
    public PhysicsMaterialRef get(int elementIndex) {
        long listVa = this.va();
        long refVa = PhysicsMaterialList.get(listVa, elementIndex);
        PhysicsMaterialRef result = new PhysicsMaterialRef(refVa, true);
        return result;
    }

    @Override
    public void resize(int numElements) {
        long listVa = this.va();
        PhysicsMaterialList.resize(listVa, numElements);
    }

    @Override
    public void set(int elementIndex, PhysicsMaterialRef reference) {
        long listVa = this.va();
        long refVa = reference.va();
        PhysicsMaterialList.set(listVa, elementIndex, refVa);
    }

    @Override
    public int size() {
        long listVa = this.va();
        int result = PhysicsMaterialList.size(listVa);
        return result;
    }

    private static native int capacity(long var0);

    private static native long createDefault();

    private static native void erase(long var0, int var2, int var3);

    private static native void free(long var0);

    private static native long get(long var0, int var2);

    private static native void resize(long var0, int var2);

    private static native void set(long var0, int var2, long var3);

    private static native int size(long var0);
}

