/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.BodyCreationSettings;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.PhysicsSceneRef;
import com.github.stephengold.joltjni.PhysicsSceneResult;
import com.github.stephengold.joltjni.PhysicsSystem;
import com.github.stephengold.joltjni.SoftBodyCreationSettings;
import com.github.stephengold.joltjni.StreamIn;
import com.github.stephengold.joltjni.StreamOut;
import com.github.stephengold.joltjni.TwoBodyConstraintSettings;
import com.github.stephengold.joltjni.readonly.ConstBodyCreationSettings;
import com.github.stephengold.joltjni.readonly.ConstSoftBodyCreationSettings;
import com.github.stephengold.joltjni.template.RefTarget;

public class PhysicsScene
extends JoltPhysicsObject
implements RefTarget {
    public PhysicsScene() {
        long sceneVa = PhysicsScene.createDefault();
        long refVa = PhysicsScene.toRef(sceneVa);
        Runnable freeingAction = () -> PhysicsSceneRef.free(refVa);
        this.setVirtualAddress(sceneVa, freeingAction);
    }

    PhysicsScene(long sceneVa) {
        long refVa = PhysicsScene.toRef(sceneVa);
        Runnable freeingAction = () -> PhysicsSceneRef.free(refVa);
        this.setVirtualAddress(sceneVa, freeingAction);
    }

    public void addBody(ConstBodyCreationSettings body) {
        long sceneVa = this.va();
        long bodyVa = body.targetVa();
        PhysicsScene.addBody(sceneVa, bodyVa);
    }

    public void addConstraint(TwoBodyConstraintSettings constraint, int body1, int body2) {
        long sceneVa = this.va();
        long constraintVa = constraint.va();
        PhysicsScene.addConstraint(sceneVa, constraintVa, body1, body2);
    }

    public void addSoftBody(ConstSoftBodyCreationSettings softBody) {
        long sceneVa = this.va();
        long bodyVa = softBody.targetVa();
        PhysicsScene.addSoftBody(sceneVa, bodyVa);
    }

    public boolean createBodies(PhysicsSystem system) {
        long sceneVa = this.va();
        long systemVa = system.va();
        boolean result = PhysicsScene.createBodies(sceneVa, systemVa);
        return result;
    }

    public boolean fixInvalidScales() {
        long sceneVa = this.va();
        boolean result = PhysicsScene.fixInvalidScales(sceneVa);
        return result;
    }

    public void fromPhysicsSystem(PhysicsSystem system) {
        long sceneVa = this.va();
        long systemVa = system.va();
        PhysicsScene.fromPhysicsSystem(sceneVa, systemVa);
    }

    public BodyCreationSettings[] getBodies() {
        long sceneVa = this.va();
        int numBodies = PhysicsScene.getNumBodies(sceneVa);
        BodyCreationSettings[] result = new BodyCreationSettings[numBodies];
        for (int bodyIndex = 0; bodyIndex < numBodies; ++bodyIndex) {
            long settingsVa = PhysicsScene.getBody(sceneVa, bodyIndex);
            result[bodyIndex] = new BodyCreationSettings(this, settingsVa);
        }
        return result;
    }

    public SoftBodyCreationSettings[] getSoftBodies() {
        long sceneVa = this.va();
        int numBodies = PhysicsScene.getNumSoftBodies(sceneVa);
        SoftBodyCreationSettings[] result = new SoftBodyCreationSettings[numBodies];
        for (int sbIndex = 0; sbIndex < numBodies; ++sbIndex) {
            long settingsVa = PhysicsScene.getSoftBody(sceneVa, sbIndex);
            result[sbIndex] = new SoftBodyCreationSettings(this, settingsVa);
        }
        return result;
    }

    public void saveBinaryState(StreamOut stream, boolean saveShapes, boolean saveGroupFilter) {
        long sceneVa = this.va();
        long streamVa = stream.va();
        PhysicsScene.saveBinaryState(sceneVa, streamVa, saveShapes, saveGroupFilter);
    }

    public static PhysicsSceneResult sRestoreFromBinaryState(StreamIn stream) {
        long streamVa = stream.va();
        long resultVa = PhysicsScene.sRestoreFromBinaryState(streamVa);
        PhysicsSceneResult result = new PhysicsSceneResult(resultVa, true);
        return result;
    }

    @Override
    public int getRefCount() {
        long sceneVa = this.va();
        int result = PhysicsScene.getRefCount(sceneVa);
        return result;
    }

    @Override
    public void setEmbedded() {
        long sceneVa = this.va();
        PhysicsScene.setEmbedded(sceneVa);
    }

    @Override
    public PhysicsSceneRef toRef() {
        long sceneVa = this.va();
        long refVa = PhysicsScene.toRef(sceneVa);
        PhysicsSceneRef result = new PhysicsSceneRef(refVa, true);
        return result;
    }

    static native void addBody(long var0, long var2);

    static native void addConstraint(long var0, long var2, int var4, int var5);

    static native void addSoftBody(long var0, long var2);

    static native boolean createBodies(long var0, long var2);

    private static native long createDefault();

    static native boolean fixInvalidScales(long var0);

    static native void fromPhysicsSystem(long var0, long var2);

    static native long getBody(long var0, int var2);

    static native long getSoftBody(long var0, int var2);

    static native int getNumBodies(long var0);

    static native int getNumSoftBodies(long var0);

    private static native int getRefCount(long var0);

    static native void saveBinaryState(long var0, long var2, boolean var4, boolean var5);

    private static native void setEmbedded(long var0);

    private static native long sRestoreFromBinaryState(long var0);

    private static native long toRef(long var0);
}

