/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Plane;
import com.github.stephengold.joltjni.Shape;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.readonly.ConstPhysicsMaterial;
import com.github.stephengold.joltjni.readonly.ConstPlane;
import java.nio.FloatBuffer;

public class PlaneShape
extends Shape {
    public PlaneShape(ConstPlane plane) {
        this(plane, null);
    }

    public PlaneShape(ConstPlane plane, ConstPhysicsMaterial material) {
        this(plane, material, 1000.0f);
    }

    public PlaneShape(ConstPlane plane, ConstPhysicsMaterial material, float halfExtent) {
        float nx = plane.getNormalX();
        float ny = plane.getNormalY();
        float nz = plane.getNormalZ();
        float planeConstant = plane.getConstant();
        long materialVa = material == null ? 0L : material.targetVa();
        long shapeVa = PlaneShape.createShape(nx, ny, nz, planeConstant, materialVa, halfExtent);
        this.setVirtualAddressAsCoOwner(shapeVa);
    }

    PlaneShape(long shapeVa) {
        this.setVirtualAddressAsCoOwner(shapeVa);
    }

    public Plane getPlane() {
        long shapeVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        PlaneShape.getPlane(shapeVa, storeFloats);
        Plane result = new Plane(storeFloats);
        return result;
    }

    private static native long createShape(float var0, float var1, float var2, float var3, long var4, float var6);

    private static native void getPlane(long var0, FloatBuffer var2);
}

