/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.PhysicsMaterial;
import com.github.stephengold.joltjni.Plane;
import com.github.stephengold.joltjni.ShapeSettings;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.enumerate.EShapeSubType;
import com.github.stephengold.joltjni.readonly.ConstPhysicsMaterial;
import com.github.stephengold.joltjni.readonly.ConstPlane;
import java.nio.FloatBuffer;

public class PlaneShapeSettings
extends ShapeSettings {
    public static final float cDefaultHalfExtent = 1000.0f;

    public PlaneShapeSettings() {
        long settingsVa = PlaneShapeSettings.createDefault();
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Plane);
    }

    public PlaneShapeSettings(ConstPlane plane) {
        this(plane, null);
    }

    public PlaneShapeSettings(ConstPlane plane, ConstPhysicsMaterial material) {
        this(plane, material, 1000.0f);
    }

    public PlaneShapeSettings(ConstPlane plane, ConstPhysicsMaterial material, float halfExtent) {
        float nx = plane.getNormalX();
        float ny = plane.getNormalY();
        float nz = plane.getNormalZ();
        float planeConstant = plane.getConstant();
        long materialVa = material == null ? 0L : material.targetVa();
        long settingsVa = PlaneShapeSettings.createPlaneShapeSettings(nx, ny, nz, planeConstant, materialVa, halfExtent);
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Plane);
    }

    PlaneShapeSettings(long settingsVa) {
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Plane);
    }

    public PlaneShapeSettings(PlaneShapeSettings original) {
        long originalVa = original.va();
        long copyVa = PlaneShapeSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa, EShapeSubType.Plane);
    }

    public float getHalfExtent() {
        long settingsVa = this.va();
        float result = PlaneShapeSettings.getHalfExtent(settingsVa);
        return result;
    }

    public ConstPhysicsMaterial getMaterial() {
        long settingsVa = this.va();
        long materialVa = PlaneShapeSettings.getMaterial(settingsVa);
        PhysicsMaterial result = materialVa == 0L ? null : new PhysicsMaterial(materialVa);
        return result;
    }

    public Plane getPlane() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        PlaneShapeSettings.getPlane(settingsVa, storeFloats);
        Plane result = new Plane(storeFloats);
        return result;
    }

    public void setHalfExtent(float halfExtent) {
        long settingsVa = this.va();
        PlaneShapeSettings.setHalfExtent(settingsVa, halfExtent);
    }

    public void setMaterial(ConstPhysicsMaterial material) {
        long settingsVa = this.va();
        long materialVa = material == null ? 0L : material.targetVa();
        PlaneShapeSettings.setMaterial(settingsVa, materialVa);
    }

    public void setPlane(ConstPlane plane) {
        long settingsVa = this.va();
        float nx = plane.getNormalX();
        float ny = plane.getNormalY();
        float nz = plane.getNormalZ();
        float c = plane.getConstant();
        PlaneShapeSettings.setPlane(settingsVa, nx, ny, nz, c);
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native long createPlaneShapeSettings(float var0, float var1, float var2, float var3, long var4, float var6);

    private static native float getHalfExtent(long var0);

    private static native long getMaterial(long var0);

    private static native void getPlane(long var0, FloatBuffer var2);

    private static native void setHalfExtent(long var0, float var2);

    private static native void setMaterial(long var0, long var2);

    private static native void setPlane(long var0, float var2, float var3, float var4, float var5);
}

