/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.TwoBodyConstraintSettings;
import com.github.stephengold.joltjni.enumerate.EConstraintSpace;
import com.github.stephengold.joltjni.enumerate.EConstraintSubType;
import com.github.stephengold.joltjni.readonly.RVec3Arg;

public class PulleyConstraintSettings
extends TwoBodyConstraintSettings {
    public PulleyConstraintSettings() {
        long settingsVa = PulleyConstraintSettings.createDefault();
        this.setVirtualAddressAsCoOwner(settingsVa, EConstraintSubType.Pulley);
    }

    PulleyConstraintSettings(long settingsVa) {
        this.setVirtualAddressAsCoOwner(settingsVa, EConstraintSubType.Pulley);
    }

    public PulleyConstraintSettings(PulleyConstraintSettings original) {
        long originalVa = original.targetVa();
        long copyVa = PulleyConstraintSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa, EConstraintSubType.Pulley);
    }

    public RVec3 getBodyPoint1() {
        long settingsVa = this.va();
        double x = PulleyConstraintSettings.getBodyPoint1X(settingsVa);
        double y = PulleyConstraintSettings.getBodyPoint1Y(settingsVa);
        double z = PulleyConstraintSettings.getBodyPoint1Z(settingsVa);
        RVec3 result = new RVec3(x, y, z);
        return result;
    }

    public RVec3 getBodyPoint2() {
        long settingsVa = this.va();
        double x = PulleyConstraintSettings.getBodyPoint2X(settingsVa);
        double y = PulleyConstraintSettings.getBodyPoint2Y(settingsVa);
        double z = PulleyConstraintSettings.getBodyPoint2Z(settingsVa);
        RVec3 result = new RVec3(x, y, z);
        return result;
    }

    public RVec3 getFixedPoint1() {
        long settingsVa = this.va();
        double x = PulleyConstraintSettings.getFixedPoint1X(settingsVa);
        double y = PulleyConstraintSettings.getFixedPoint1Y(settingsVa);
        double z = PulleyConstraintSettings.getFixedPoint1Z(settingsVa);
        RVec3 result = new RVec3(x, y, z);
        return result;
    }

    public RVec3 getFixedPoint2() {
        long settingsVa = this.va();
        double x = PulleyConstraintSettings.getFixedPoint2X(settingsVa);
        double y = PulleyConstraintSettings.getFixedPoint2Y(settingsVa);
        double z = PulleyConstraintSettings.getFixedPoint2Z(settingsVa);
        RVec3 result = new RVec3(x, y, z);
        return result;
    }

    public float getMaxLength() {
        long settingsVa = this.va();
        float result = PulleyConstraintSettings.getMaxLength(settingsVa);
        return result;
    }

    public float getMinLength() {
        long settingsVa = this.va();
        float result = PulleyConstraintSettings.getMinLength(settingsVa);
        return result;
    }

    public float getRatio() {
        long settingsVa = this.va();
        float result = PulleyConstraintSettings.getRatio(settingsVa);
        return result;
    }

    public EConstraintSpace getSpace() {
        long settingsVa = this.va();
        int ordinal = PulleyConstraintSettings.getSpace(settingsVa);
        EConstraintSpace result = EConstraintSpace.values()[ordinal];
        return result;
    }

    public void setBodyPoint1(RVec3Arg location) {
        long settingsVa = this.va();
        double locX = location.xx();
        double locY = location.yy();
        double locZ = location.zz();
        PulleyConstraintSettings.setBodyPoint1(settingsVa, locX, locY, locZ);
    }

    public void setBodyPoint2(RVec3Arg location) {
        long settingsVa = this.va();
        double locX = location.xx();
        double locY = location.yy();
        double locZ = location.zz();
        PulleyConstraintSettings.setBodyPoint2(settingsVa, locX, locY, locZ);
    }

    public void setFixedPoint1(RVec3Arg location) {
        long settingsVa = this.va();
        double locX = location.xx();
        double locY = location.yy();
        double locZ = location.zz();
        PulleyConstraintSettings.setFixedPoint1(settingsVa, locX, locY, locZ);
    }

    public void setFixedPoint2(RVec3Arg location) {
        long settingsVa = this.va();
        double locX = location.xx();
        double locY = location.yy();
        double locZ = location.zz();
        PulleyConstraintSettings.setFixedPoint2(settingsVa, locX, locY, locZ);
    }

    public float setMaxLength(float length) {
        long settingsVa = this.va();
        PulleyConstraintSettings.setMaxLength(settingsVa, length);
        return length;
    }

    public float setMinLength(float length) {
        long settingsVa = this.va();
        PulleyConstraintSettings.setMinLength(settingsVa, length);
        return length;
    }

    public void setRatio(float ratio) {
        long settingsVa = this.va();
        PulleyConstraintSettings.setRatio(settingsVa, ratio);
    }

    public void setSpace(EConstraintSpace space) {
        long settingsVa = this.va();
        int ordinal = space.ordinal();
        PulleyConstraintSettings.setSpace(settingsVa, ordinal);
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native double getBodyPoint1X(long var0);

    private static native double getBodyPoint1Y(long var0);

    private static native double getBodyPoint1Z(long var0);

    private static native double getBodyPoint2X(long var0);

    private static native double getBodyPoint2Y(long var0);

    private static native double getBodyPoint2Z(long var0);

    private static native double getFixedPoint1X(long var0);

    private static native double getFixedPoint1Y(long var0);

    private static native double getFixedPoint1Z(long var0);

    private static native double getFixedPoint2X(long var0);

    private static native double getFixedPoint2Y(long var0);

    private static native double getFixedPoint2Z(long var0);

    private static native float getMaxLength(long var0);

    private static native float getMinLength(long var0);

    private static native float getRatio(long var0);

    private static native int getSpace(long var0);

    private static native void setBodyPoint1(long var0, double var2, double var4, double var6);

    private static native void setBodyPoint2(long var0, double var2, double var4, double var6);

    private static native void setFixedPoint1(long var0, double var2, double var4, double var6);

    private static native void setFixedPoint2(long var0, double var2, double var4, double var6);

    private static native void setMaxLength(long var0, float var2);

    private static native void setMinLength(long var0, float var2);

    private static native void setRatio(long var0, float var2);

    private static native void setSpace(long var0, int var2);
}

