/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.TwoBodyConstraintSettings;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EConstraintSpace;
import com.github.stephengold.joltjni.enumerate.EConstraintSubType;
import com.github.stephengold.joltjni.readonly.Vec3Arg;

public class RackAndPinionConstraintSettings
extends TwoBodyConstraintSettings {
    public RackAndPinionConstraintSettings() {
        long settingsVa = RackAndPinionConstraintSettings.createDefault();
        this.setVirtualAddressAsCoOwner(settingsVa, EConstraintSubType.RackAndPinion);
    }

    RackAndPinionConstraintSettings(long settingsVa) {
        this.setVirtualAddressAsCoOwner(settingsVa, EConstraintSubType.RackAndPinion);
    }

    public RackAndPinionConstraintSettings(RackAndPinionConstraintSettings original) {
        long originalVa = original.va();
        long copyVa = RackAndPinionConstraintSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa, EConstraintSubType.RackAndPinion);
    }

    public Vec3 getHingeAxis() {
        long settingsVa = this.va();
        float dx = RackAndPinionConstraintSettings.getHingeAxisX(settingsVa);
        float dy = RackAndPinionConstraintSettings.getHingeAxisY(settingsVa);
        float dz = RackAndPinionConstraintSettings.getHingeAxisZ(settingsVa);
        Vec3 result = new Vec3(dx, dy, dz);
        return result;
    }

    public float getRatio() {
        long settingsVa = this.va();
        float result = RackAndPinionConstraintSettings.getRatio(settingsVa);
        return result;
    }

    public Vec3 getSliderAxis() {
        long settingsVa = this.va();
        float dx = RackAndPinionConstraintSettings.getSliderAxisX(settingsVa);
        float dy = RackAndPinionConstraintSettings.getSliderAxisY(settingsVa);
        float dz = RackAndPinionConstraintSettings.getSliderAxisZ(settingsVa);
        Vec3 result = new Vec3(dx, dy, dz);
        return result;
    }

    public EConstraintSpace getSpace() {
        long settingsVa = this.va();
        int ordinal = RackAndPinionConstraintSettings.getSpace(settingsVa);
        EConstraintSpace result = EConstraintSpace.values()[ordinal];
        return result;
    }

    public Vec3Arg setHingeAxis(Vec3Arg direction) {
        long settingsVa = this.va();
        float dx = direction.getX();
        float dy = direction.getY();
        float dz = direction.getZ();
        RackAndPinionConstraintSettings.setHingeAxis(settingsVa, dx, dy, dz);
        return direction;
    }

    public void setRatio(float ratio) {
        long settingsVa = this.va();
        RackAndPinionConstraintSettings.setRatioDirectly(settingsVa, ratio);
    }

    public void setRatio(int rackTeeth, float rackLength, int pinionTeeth) {
        long settingsVa = this.va();
        RackAndPinionConstraintSettings.setRatio(settingsVa, rackTeeth, rackLength, pinionTeeth);
    }

    public Vec3Arg setSliderAxis(Vec3Arg direction) {
        long settingsVa = this.va();
        float dx = direction.getX();
        float dy = direction.getY();
        float dz = direction.getZ();
        RackAndPinionConstraintSettings.setSliderAxis(settingsVa, dx, dy, dz);
        return direction;
    }

    public void setSpace(EConstraintSpace space) {
        long settingsVa = this.va();
        int ordinal = space.ordinal();
        RackAndPinionConstraintSettings.setSpace(settingsVa, ordinal);
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native float getHingeAxisX(long var0);

    private static native float getHingeAxisY(long var0);

    private static native float getHingeAxisZ(long var0);

    private static native float getRatio(long var0);

    private static native float getSliderAxisX(long var0);

    private static native float getSliderAxisY(long var0);

    private static native float getSliderAxisZ(long var0);

    private static native int getSpace(long var0);

    private static native void setHingeAxis(long var0, float var2, float var3, float var4);

    private static native void setRatio(long var0, int var2, float var3, int var4);

    private static native void setRatioDirectly(long var0, float var2);

    private static native void setSliderAxis(long var0, float var2, float var3, float var4);

    private static native void setSpace(long var0, int var2);
}

