/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Mat44Array;
import com.github.stephengold.joltjni.NonCopyable;
import com.github.stephengold.joltjni.PhysicsSystem;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.RagdollRef;
import com.github.stephengold.joltjni.SkeletonPose;
import com.github.stephengold.joltjni.enumerate.EActivation;
import com.github.stephengold.joltjni.template.RefTarget;

public class Ragdoll
extends NonCopyable
implements RefTarget {
    private final PhysicsSystem system;

    Ragdoll(long ragdollVa, PhysicsSystem physicsSystem) {
        this.system = physicsSystem;
        long refVa = Ragdoll.toRef(ragdollVa);
        Runnable freeingAction = () -> RagdollRef.freeWithSystem(refVa, physicsSystem);
        this.setVirtualAddress(ragdollVa, freeingAction);
    }

    public void addToPhysicsSystem(EActivation activation) {
        long ragdollVa = this.va();
        int ordinal = activation.ordinal();
        Ragdoll.addToPhysicsSystem(ragdollVa, ordinal);
    }

    public void driveToPoseUsingKinematics(SkeletonPose pose, float time) {
        this.driveToPoseUsingKinematics(pose, time, true);
    }

    public void driveToPoseUsingKinematics(SkeletonPose pose, float time, boolean lockBodies) {
        long ragdollVa = this.va();
        long poseVa = pose.va();
        Ragdoll.driveToPoseUsingKinematics(ragdollVa, poseVa, time, lockBodies);
    }

    public void driveToPoseUsingMotors(SkeletonPose pose) {
        long ragdollVa = this.va();
        long poseVa = pose.va();
        Ragdoll.driveToPoseUsingMotors(ragdollVa, poseVa);
    }

    public int getBodyCount() {
        long ragdollVa = this.va();
        int result = Ragdoll.getBodyCount(ragdollVa);
        return result;
    }

    public int[] getBodyIds() {
        long ragdollVa = this.va();
        int numBodies = Ragdoll.getBodyCount(ragdollVa);
        int[] storeIds = new int[numBodies];
        Ragdoll.getBodyIds(ragdollVa, storeIds);
        return storeIds;
    }

    public int getConstraintCount() {
        long ragdollVa = this.va();
        int result = Ragdoll.getConstraintCount(ragdollVa);
        return result;
    }

    public void getPose(RVec3 storeRootOffset, Mat44Array storeJointMatrices) {
        this.getPose(storeRootOffset, storeJointMatrices, true);
    }

    public void getPose(RVec3 storeRootOffset, Mat44Array storeJointMatrices, boolean lockBodies) {
        long ragdollVa = this.va();
        double[] storeDoubles = new double[3];
        long storeMatsVa = storeJointMatrices.va();
        Ragdoll.getPose(ragdollVa, storeDoubles, storeMatsVa, lockBodies);
        storeRootOffset.set(storeDoubles);
    }

    public void getPose(SkeletonPose storePose) {
        this.getPose(storePose, true);
    }

    public void getPose(SkeletonPose storePose, boolean lockBodies) {
        long ragdollVa = this.targetVa();
        long poseVa = storePose.va();
        Ragdoll.getPoseToObject(ragdollVa, poseVa, lockBodies);
    }

    public void getRootTransform(RVec3 storeLocation, Quat storeOrientation) {
        this.getRootTransform(storeLocation, storeOrientation, true);
    }

    public void getRootTransform(RVec3 storeLocation, Quat storeOrientation, boolean lockBodies) {
        long ragdollVa = this.va();
        double[] storeDoubles = new double[3];
        float[] storeFloats = new float[4];
        Ragdoll.getRootTransform(ragdollVa, storeDoubles, storeFloats, lockBodies);
        storeLocation.set(storeDoubles);
        storeOrientation.set(storeFloats);
    }

    public void removeFromPhysicsSystem() {
        long ragdollVa = this.va();
        Ragdoll.removeFromPhysicsSystem(ragdollVa);
    }

    public void setPose(SkeletonPose pose) {
        this.setPose(pose, true);
    }

    public void setPose(SkeletonPose pose, boolean lockBodies) {
        long ragdollVa = this.va();
        long poseVa = pose.va();
        Ragdoll.setPose(ragdollVa, poseVa, lockBodies);
    }

    @Override
    public int getRefCount() {
        long ragdollVa = this.va();
        int result = Ragdoll.getRefCount(ragdollVa);
        return result;
    }

    @Override
    public void setEmbedded() {
        long ragdollVa = this.va();
        Ragdoll.setEmbedded(ragdollVa);
    }

    @Override
    public RagdollRef toRef() {
        long ragdollVa = this.va();
        long refVa = Ragdoll.toRef(ragdollVa);
        RagdollRef result = new RagdollRef(refVa, this.system);
        return result;
    }

    static native void addToPhysicsSystem(long var0, int var2);

    static native void driveToPoseUsingKinematics(long var0, long var2, float var4, boolean var5);

    static native void driveToPoseUsingMotors(long var0, long var2);

    static native int getBodyCount(long var0);

    static native void getBodyIds(long var0, int[] var2);

    static native int getConstraintCount(long var0);

    static native void getPose(long var0, double[] var2, long var3, boolean var5);

    static native void getPoseToObject(long var0, long var2, boolean var4);

    private static native int getRefCount(long var0);

    static native void getRootTransform(long var0, double[] var2, float[] var3, boolean var4);

    static native void removeFromPhysicsSystem(long var0);

    private static native void setEmbedded(long var0);

    static native void setPose(long var0, long var2, boolean var4);

    private static native long toRef(long var0);
}

