/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Mat44Array;
import com.github.stephengold.joltjni.PhysicsSystem;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Ragdoll;
import com.github.stephengold.joltjni.SkeletonPose;
import com.github.stephengold.joltjni.enumerate.EActivation;
import com.github.stephengold.joltjni.template.Ref;

public final class RagdollRef
extends Ref {
    private final PhysicsSystem system;

    public RagdollRef() {
        this.system = null;
        long refVa = RagdollRef.createDefault();
        this.setVirtualAddress(refVa, () -> RagdollRef.free(refVa));
    }

    RagdollRef(long refVa, PhysicsSystem physicsSystem) {
        this.system = physicsSystem;
        Runnable freeingAction = () -> RagdollRef.freeWithSystem(refVa, physicsSystem);
        this.setVirtualAddress(refVa, freeingAction);
    }

    public void addToPhysicsSystem(EActivation activation) {
        long ragdollVa = this.targetVa();
        int ordinal = activation.ordinal();
        Ragdoll.addToPhysicsSystem(ragdollVa, ordinal);
    }

    public void driveToPoseUsingKinematics(SkeletonPose pose, float time) {
        this.driveToPoseUsingKinematics(pose, time, true);
    }

    public void driveToPoseUsingKinematics(SkeletonPose pose, float time, boolean lockBodies) {
        long ragdollVa = this.targetVa();
        long poseVa = pose.va();
        Ragdoll.driveToPoseUsingKinematics(ragdollVa, poseVa, time, lockBodies);
    }

    public void driveToPoseUsingMotors(SkeletonPose pose) {
        long ragdollVa = this.targetVa();
        long poseVa = pose.va();
        Ragdoll.driveToPoseUsingMotors(ragdollVa, poseVa);
    }

    public int getBodyCount() {
        long ragdollVa = this.targetVa();
        int result = Ragdoll.getBodyCount(ragdollVa);
        return result;
    }

    public int[] getBodyIds() {
        long ragdollVa = this.targetVa();
        int numBodies = Ragdoll.getBodyCount(ragdollVa);
        int[] storeIds = new int[numBodies];
        Ragdoll.getBodyIds(ragdollVa, storeIds);
        return storeIds;
    }

    public int getConstraintCount() {
        long ragdollVa = this.targetVa();
        int result = Ragdoll.getConstraintCount(ragdollVa);
        return result;
    }

    public void getPose(RVec3 storeRootOffset, Mat44Array storeJointMatrices) {
        this.getPose(storeRootOffset, storeJointMatrices, true);
    }

    public void getPose(RVec3 storeRootOffset, Mat44Array storeJointMatrices, boolean lockBodies) {
        long ragdollVa = this.targetVa();
        double[] storeDoubles = new double[3];
        long storeMatsVa = storeJointMatrices.va();
        Ragdoll.getPose(ragdollVa, storeDoubles, storeMatsVa, lockBodies);
        storeRootOffset.set(storeDoubles);
    }

    public void getPose(SkeletonPose storePose) {
        this.getPose(storePose, true);
    }

    public void getPose(SkeletonPose storePose, boolean lockBodies) {
        long ragdollVa = this.targetVa();
        long poseVa = storePose.va();
        Ragdoll.getPoseToObject(ragdollVa, poseVa, lockBodies);
    }

    public void getRootTransform(RVec3 storeLocation, Quat storeOrientation) {
        this.getRootTransform(storeLocation, storeOrientation, true);
    }

    public void getRootTransform(RVec3 storeLocation, Quat storeOrientation, boolean lockBodies) {
        long ragdollVa = this.targetVa();
        double[] storeDoubles = new double[3];
        float[] storeFloats = new float[4];
        Ragdoll.getRootTransform(ragdollVa, storeDoubles, storeFloats, lockBodies);
        storeLocation.set(storeDoubles);
        storeOrientation.set(storeFloats);
    }

    public void removeFromPhysicsSystem() {
        long ragdollVa = this.targetVa();
        Ragdoll.removeFromPhysicsSystem(ragdollVa);
    }

    public void setPose(SkeletonPose pose) {
        this.setPose(pose, true);
    }

    public void setPose(SkeletonPose pose, boolean lockBodies) {
        long ragdollVa = this.targetVa();
        long poseVa = pose.va();
        Ragdoll.setPose(ragdollVa, poseVa, lockBodies);
    }

    @Override
    public Ragdoll getPtr() {
        long ragdollVa = this.targetVa();
        Ragdoll result = new Ragdoll(ragdollVa, this.system);
        return result;
    }

    @Override
    public long targetVa() {
        long refVa = this.va();
        long result = RagdollRef.getPtr(refVa);
        return result;
    }

    @Override
    public RagdollRef toRef() {
        long refVa = this.va();
        long copyVa = RagdollRef.copy(refVa);
        RagdollRef result = new RagdollRef(copyVa, this.system);
        return result;
    }

    private static native long copy(long var0);

    private static native long createDefault();

    private static native void free(long var0);

    static native void freeWithSystem(long var0, PhysicsSystem var2);

    private static native long getPtr(long var0);
}

