/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.AdditionalConstraint;
import com.github.stephengold.joltjni.Part;
import com.github.stephengold.joltjni.PhysicsSystem;
import com.github.stephengold.joltjni.Ragdoll;
import com.github.stephengold.joltjni.RagdollResult;
import com.github.stephengold.joltjni.RagdollSettings;
import com.github.stephengold.joltjni.Skeleton;
import com.github.stephengold.joltjni.StreamIn;
import com.github.stephengold.joltjni.StreamOut;
import com.github.stephengold.joltjni.template.Ref;

public final class RagdollSettingsRef
extends Ref {
    public RagdollSettingsRef() {
        long refVa = RagdollSettingsRef.createDefault();
        this.setVirtualAddress(refVa, () -> RagdollSettingsRef.free(refVa));
    }

    RagdollSettingsRef(long refVa, boolean owner) {
        Runnable freeingAction = owner ? () -> RagdollSettingsRef.free(refVa) : null;
        this.setVirtualAddress(refVa, freeingAction);
    }

    public void addAdditionalConstraint(AdditionalConstraint constraint) {
        long settingsVa = this.targetVa();
        long constraintVa = constraint.va();
        RagdollSettings.addAdditionalConstraint(settingsVa, constraintVa);
    }

    public void calculateBodyIndexToConstraintIndex() {
        long settingsVa = this.targetVa();
        RagdollSettings.calculateBodyIndexToConstraintIndex(settingsVa);
    }

    public void calculateConstraintIndexToBodyIdxPair() {
        long settingsVa = this.targetVa();
        RagdollSettings.calculateConstraintIndexToBodyIdxPair(settingsVa);
    }

    public Ragdoll createRagdoll(int groupId, long userData, PhysicsSystem physicsSystem) {
        long systemVa;
        long settingsVa = this.targetVa();
        long resultVa = RagdollSettings.createRagdoll(settingsVa, groupId, userData, systemVa = physicsSystem.va());
        Ragdoll result = resultVa == 0L ? null : new Ragdoll(resultVa, physicsSystem);
        return result;
    }

    public void disableParentChildCollisions() {
        long settingsVa = this.targetVa();
        RagdollSettings.disableParentChildCollisions(settingsVa);
    }

    public Part[] getParts() {
        long settingsVa = this.targetVa();
        int numParts = RagdollSettings.getNumParts(settingsVa);
        Part[] result = new Part[numParts];
        for (int partIndex = 0; partIndex < numParts; ++partIndex) {
            long partVa = RagdollSettings.getPart(settingsVa, partIndex);
            result[partIndex] = new Part(this, partVa);
        }
        return result;
    }

    public Skeleton getSkeleton() {
        long settingsVa = this.targetVa();
        long skeletonVa = RagdollSettings.getSkeleton(settingsVa);
        Skeleton result = new Skeleton(skeletonVa);
        return result;
    }

    public void resizeParts(int numParts) {
        long settingsVa = this.targetVa();
        RagdollSettings.resizeParts(settingsVa, numParts);
    }

    public void saveBinaryState(StreamOut stream, boolean saveShapes, boolean saveGroupFilter) {
        long settingsVa = this.targetVa();
        long streamVa = stream.va();
        RagdollSettings.saveBinaryState(settingsVa, streamVa, saveShapes, saveGroupFilter);
    }

    public void setSkeleton(Skeleton skeleton) {
        long settingsVa = this.targetVa();
        long skeletonVa = skeleton.va();
        RagdollSettings.setSkeleton(settingsVa, skeletonVa);
    }

    public static RagdollResult sRestoreFromBinaryState(StreamIn stream) {
        long streamVa = stream.targetVa();
        long resultVa = RagdollSettings.sRestoreFromBinaryState(streamVa);
        RagdollResult result = new RagdollResult(resultVa, true);
        return result;
    }

    public boolean stabilize() {
        long settingsVa = this.targetVa();
        boolean result = RagdollSettings.stabilize(settingsVa);
        return result;
    }

    @Override
    public RagdollSettings getPtr() {
        long settingsVa = this.targetVa();
        RagdollSettings result = new RagdollSettings(settingsVa);
        return result;
    }

    @Override
    public long targetVa() {
        long refVa = this.va();
        long result = RagdollSettingsRef.getPtr(refVa);
        return result;
    }

    @Override
    public RagdollSettingsRef toRef() {
        long refVa = this.va();
        long copyVa = RagdollSettingsRef.copy(refVa);
        RagdollSettingsRef result = new RagdollSettingsRef(copyVa, true);
        return result;
    }

    private static native long copy(long var0);

    private static native long createDefault();

    static native void free(long var0);

    private static native long getPtr(long var0);
}

