/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public class RayInvDirection
extends JoltPhysicsObject {
    public RayInvDirection() {
        long dirVa = RayInvDirection.createDefault();
        this.setVirtualAddress(dirVa, () -> RayInvDirection.free(dirVa));
    }

    public RayInvDirection(Vec3Arg direction) {
        float dx = direction.getX();
        float dy = direction.getY();
        float dz = direction.getZ();
        long dirVa = RayInvDirection.create(dx, dy, dz);
        this.setVirtualAddress(dirVa, () -> RayInvDirection.free(dirVa));
    }

    public Vec3 getInvDirection() {
        long dirVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        RayInvDirection.getInvDirection(dirVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public void set(Vec3Arg direction) {
        long dirVa = this.va();
        float dx = direction.getX();
        float dy = direction.getY();
        float dz = direction.getZ();
        RayInvDirection.set(dirVa, dx, dy, dz);
    }

    public void setInvDirection(Vec3Arg invDirection) {
        long dirVa = this.va();
        float ix = invDirection.getX();
        float iy = invDirection.getY();
        float iz = invDirection.getZ();
        RayInvDirection.setInvDirection(dirVa, ix, iy, iz);
    }

    private static native long create(float var0, float var1, float var2);

    private static native long createDefault();

    private static native void free(long var0);

    private static native void getInvDirection(long var0, FloatBuffer var2);

    private static native void set(long var0, float var2, float var3, float var4);

    private static native void setInvDirection(long var0, float var2, float var3, float var4);
}

