/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.AaBox;
import com.github.stephengold.joltjni.BoxShape;
import com.github.stephengold.joltjni.CapsuleShape;
import com.github.stephengold.joltjni.ConvexHullShape;
import com.github.stephengold.joltjni.CylinderShape;
import com.github.stephengold.joltjni.DebugRenderer;
import com.github.stephengold.joltjni.EmptyShape;
import com.github.stephengold.joltjni.HeightFieldShape;
import com.github.stephengold.joltjni.MassProperties;
import com.github.stephengold.joltjni.MeshShape;
import com.github.stephengold.joltjni.MutableCompoundShape;
import com.github.stephengold.joltjni.NonCopyable;
import com.github.stephengold.joltjni.OffsetCenterOfMassShape;
import com.github.stephengold.joltjni.PhysicsMaterial;
import com.github.stephengold.joltjni.PlaneShape;
import com.github.stephengold.joltjni.RotatedTranslatedShape;
import com.github.stephengold.joltjni.ScaledShape;
import com.github.stephengold.joltjni.ShapeRef;
import com.github.stephengold.joltjni.ShapeRefC;
import com.github.stephengold.joltjni.ShapeResult;
import com.github.stephengold.joltjni.SoftBodyShape;
import com.github.stephengold.joltjni.SphereShape;
import com.github.stephengold.joltjni.StaticCompoundShape;
import com.github.stephengold.joltjni.Stats;
import com.github.stephengold.joltjni.StreamIn;
import com.github.stephengold.joltjni.StreamOut;
import com.github.stephengold.joltjni.TaperedCapsuleShape;
import com.github.stephengold.joltjni.TaperedCylinderShape;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.TriangleShape;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EShapeSubType;
import com.github.stephengold.joltjni.enumerate.EShapeType;
import com.github.stephengold.joltjni.readonly.ConstColor;
import com.github.stephengold.joltjni.readonly.ConstPhysicsMaterial;
import com.github.stephengold.joltjni.readonly.ConstShape;
import com.github.stephengold.joltjni.readonly.Mat44Arg;
import com.github.stephengold.joltjni.readonly.RMat44Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import com.github.stephengold.joltjni.template.RefTarget;
import java.nio.FloatBuffer;

public abstract class Shape
extends NonCopyable
implements ConstShape,
RefTarget {
    Shape() {
    }

    Shape(long shapeVa) {
        this.setVirtualAddressAsCoOwner(shapeVa);
    }

    static Shape newShape(long shapeVa) {
        Shape result;
        if (shapeVa == 0L) {
            return null;
        }
        int ordinal = Shape.getSubType(shapeVa);
        EShapeSubType subType = EShapeSubType.values()[ordinal];
        switch (subType) {
            case Box: {
                result = new BoxShape(shapeVa);
                break;
            }
            case Capsule: {
                result = new CapsuleShape(shapeVa);
                break;
            }
            case ConvexHull: {
                result = new ConvexHullShape(shapeVa);
                break;
            }
            case Cylinder: {
                result = new CylinderShape(shapeVa);
                break;
            }
            case Empty: {
                result = new EmptyShape(shapeVa);
                break;
            }
            case HeightField: {
                result = new HeightFieldShape(shapeVa);
                break;
            }
            case Mesh: {
                result = new MeshShape(shapeVa);
                break;
            }
            case MutableCompound: {
                result = new MutableCompoundShape(shapeVa);
                break;
            }
            case OffsetCenterOfMass: {
                result = new OffsetCenterOfMassShape(shapeVa);
                break;
            }
            case Plane: {
                result = new PlaneShape(shapeVa);
                break;
            }
            case RotatedTranslated: {
                result = new RotatedTranslatedShape(shapeVa);
                break;
            }
            case Scaled: {
                result = new ScaledShape(shapeVa);
                break;
            }
            case SoftBody: {
                result = new SoftBodyShape(shapeVa);
                break;
            }
            case Sphere: {
                result = new SphereShape(shapeVa);
                break;
            }
            case StaticCompound: {
                result = new StaticCompoundShape(shapeVa);
                break;
            }
            case TaperedCapsule: {
                result = new TaperedCapsuleShape(shapeVa);
                break;
            }
            case TaperedCylinder: {
                result = new TaperedCylinderShape(shapeVa);
                break;
            }
            case Triangle: {
                result = new TriangleShape(shapeVa);
                break;
            }
            default: {
                throw new IllegalArgumentException("subType = " + String.valueOf((Object)subType));
            }
        }
        return result;
    }

    public static ShapeResult sRestoreFromBinaryState(StreamIn stream) {
        long streamVa = stream.va();
        long resultVa = Shape.sRestoreFromBinaryState(streamVa);
        ShapeResult result = new ShapeResult(resultVa, true);
        return result;
    }

    protected final void setVirtualAddressAsCoOwner(long shapeVa) {
        long refVa = Shape.toRef(shapeVa);
        Runnable freeingAction = () -> ShapeRef.free(refVa);
        this.setVirtualAddress(shapeVa, freeingAction);
    }

    @Override
    public void copyDebugTriangles(FloatBuffer storeBuffer) {
        long shapeVa = this.va();
        int numTriangles = storeBuffer.capacity() / 9;
        Shape.copyDebugTriangles(shapeVa, numTriangles, storeBuffer);
    }

    @Override
    public int countDebugTriangles() {
        long shapeVa = this.va();
        int result = Shape.countDebugTriangles(shapeVa);
        assert (result > 0) : "result = " + result;
        return result;
    }

    @Override
    public void draw(DebugRenderer renderer, RMat44Arg comTransform, Vec3Arg scale, ConstColor color, boolean useMaterialColors, boolean wireframe) {
        long shapeVa = this.va();
        long rendererVa = renderer.va();
        long transformVa = comTransform.targetVa();
        float scaleX = scale.getX();
        float scaleY = scale.getY();
        float scaleZ = scale.getZ();
        int colorInt = color.getUInt32();
        Shape.draw(shapeVa, rendererVa, transformVa, scaleX, scaleY, scaleZ, colorInt, useMaterialColors, wireframe);
    }

    @Override
    public void drawGetSupportFunction(DebugRenderer renderer, RMat44Arg comTransform, Vec3Arg scale, ConstColor color, boolean drawSupportDirection) {
        long shapeVa = this.va();
        long rendererVa = renderer.va();
        long transformVa = comTransform.targetVa();
        float scaleX = scale.getX();
        float scaleY = scale.getY();
        float scaleZ = scale.getZ();
        int colorInt = color.getUInt32();
        Shape.drawGetSupportFunction(shapeVa, rendererVa, transformVa, scaleX, scaleY, scaleZ, colorInt, drawSupportDirection);
    }

    @Override
    public Vec3 getCenterOfMass() {
        long shapeVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        Shape.getCenterOfMass(shapeVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    @Override
    public float getInnerRadius() {
        long shapeVa = this.va();
        float result = Shape.getInnerRadius(shapeVa);
        return result;
    }

    @Override
    public ConstShape getLeafShape(int subShapeId, int[] storeRemainderId) {
        long currentVa = this.va();
        long leafVa = Shape.getLeafShape(currentVa, subShapeId, storeRemainderId);
        Shape result = Shape.newShape(leafVa);
        return result;
    }

    @Override
    public AaBox getLocalBounds() {
        long shapeVa = this.va();
        long boxVa = Shape.getLocalBounds(shapeVa);
        AaBox result = new AaBox(boxVa, true);
        return result;
    }

    @Override
    public MassProperties getMassProperties() {
        long shapeVa = this.va();
        long propertiesVa = Shape.getMassProperties(shapeVa);
        MassProperties result = new MassProperties(propertiesVa, true);
        return result;
    }

    @Override
    public ConstPhysicsMaterial getMaterial(int subShapeId) {
        long shapeVa = this.va();
        long materialVa = Shape.getMaterial(shapeVa, subShapeId);
        PhysicsMaterial result = new PhysicsMaterial(materialVa);
        return result;
    }

    @Override
    public long getRevisionCount() {
        long shapeVa = this.va();
        long result = Shape.getUserData(shapeVa);
        return result;
    }

    @Override
    public Stats getStats() {
        long shapeVa = this.va();
        long statsVa = Shape.getStats(shapeVa);
        Stats result = new Stats(statsVa, true);
        return result;
    }

    @Override
    public int getSubShapeIdBitsRecursive() {
        long shapeVa = this.va();
        int result = Shape.getSubShapeIdBitsRecursive(shapeVa);
        return result;
    }

    @Override
    public EShapeSubType getSubType() {
        long shapeVa = this.va();
        int ordinal = Shape.getSubType(shapeVa);
        EShapeSubType result = EShapeSubType.values()[ordinal];
        return result;
    }

    @Override
    public EShapeType getType() {
        long shapeVa = this.va();
        int ordinal = Shape.getType(shapeVa);
        EShapeType result = EShapeType.values()[ordinal];
        return result;
    }

    @Override
    public AaBox getWorldSpaceBounds(Mat44Arg comTransform, Vec3Arg scale) {
        long shapeVa = this.va();
        long matrixVa = comTransform.targetVa();
        float sx = scale.getX();
        float sy = scale.getY();
        float sz = scale.getZ();
        long boxVa = Shape.getWorldSpaceBounds(shapeVa, matrixVa, sx, sy, sz);
        AaBox result = new AaBox(boxVa, true);
        return result;
    }

    @Override
    public AaBox getWorldSpaceBounds(RMat44Arg comTransform, Vec3Arg scale) {
        long shapeVa = this.va();
        long rMat44Va = comTransform.targetVa();
        float sx = scale.getX();
        float sy = scale.getY();
        float sz = scale.getZ();
        long boxVa = Shape.getWorldSpaceBoundsReal(shapeVa, rMat44Va, sx, sy, sz);
        AaBox result = new AaBox(boxVa, true);
        return result;
    }

    @Override
    public boolean isValidScale(Vec3Arg scale) {
        long shapeVa = this.va();
        float sx = scale.getX();
        float sy = scale.getY();
        float sz = scale.getZ();
        boolean result = Shape.isValidScale(shapeVa, sx, sy, sz);
        return result;
    }

    @Override
    public Vec3 makeScaleValid(Vec3Arg scale) {
        long shapeVa = this.va();
        FloatBuffer floatBuffer = Temporaries.floatBuffer1.get();
        scale.copyTo(floatBuffer);
        Shape.makeScaleValid(shapeVa, floatBuffer);
        Vec3 result = new Vec3(floatBuffer);
        return result;
    }

    @Override
    public boolean mustBeStatic() {
        long shapeVa = this.va();
        boolean result = Shape.mustBeStatic(shapeVa);
        return result;
    }

    @Override
    public void saveBinaryState(StreamOut stream) {
        long shapeVa = this.va();
        long streamVa = stream.va();
        Shape.saveBinaryState(shapeVa, streamVa);
    }

    @Override
    public ShapeResult scaleShape(Vec3Arg scaleFactors) {
        long shapeVa = this.va();
        float sx = scaleFactors.getX();
        float sy = scaleFactors.getY();
        float sz = scaleFactors.getZ();
        long resultVa = Shape.scaleShape(shapeVa, sx, sy, sz);
        ShapeResult result = new ShapeResult(resultVa, true);
        return result;
    }

    @Override
    public ShapeRefC toRefC() {
        long shapeVa = this.va();
        long refVa = Shape.toRefC(shapeVa);
        ShapeRefC result = new ShapeRefC(refVa, true);
        return result;
    }

    @Override
    public int getRefCount() {
        long shapeVa = this.va();
        int result = Shape.getRefCount(shapeVa);
        return result;
    }

    @Override
    public void setEmbedded() {
        long shapeVa = this.va();
        Shape.setEmbedded(shapeVa);
    }

    @Override
    public ShapeRef toRef() {
        long shapeVa = this.va();
        long copyVa = Shape.toRef(shapeVa);
        ShapeRef result = new ShapeRef(copyVa, true);
        return result;
    }

    static native void copyDebugTriangles(long var0, int var2, FloatBuffer var3);

    static native int countDebugTriangles(long var0);

    static native void draw(long var0, long var2, long var4, float var6, float var7, float var8, int var9, boolean var10, boolean var11);

    static native void drawGetSupportFunction(long var0, long var2, long var4, float var6, float var7, float var8, int var9, boolean var10);

    static native void getCenterOfMass(long var0, FloatBuffer var2);

    static native float getInnerRadius(long var0);

    static native long getLeafShape(long var0, int var2, int[] var3);

    static native long getLocalBounds(long var0);

    static native long getMassProperties(long var0);

    static native long getMaterial(long var0, int var2);

    static native int getRefCount(long var0);

    static native long getStats(long var0);

    static native int getSubShapeIdBitsRecursive(long var0);

    static native int getSubType(long var0);

    static native int getType(long var0);

    static native long getUserData(long var0);

    static native long getWorldSpaceBounds(long var0, long var2, float var4, float var5, float var6);

    static native long getWorldSpaceBoundsReal(long var0, long var2, float var4, float var5, float var6);

    static native boolean isValidScale(long var0, float var2, float var3, float var4);

    static native void makeScaleValid(long var0, FloatBuffer var2);

    static native boolean mustBeStatic(long var0);

    static native void saveBinaryState(long var0, long var2);

    static native long scaleShape(long var0, float var2, float var3, float var4);

    private static native void setEmbedded(long var0);

    private static native long sRestoreFromBinaryState(long var0);

    private static native long toRef(long var0);

    private static native long toRefC(long var0);
}

