/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.CollideSettingsBase;
import com.github.stephengold.joltjni.enumerate.EBackFaceMode;

public class ShapeCastSettings
extends CollideSettingsBase {
    public ShapeCastSettings() {
        long settingsVa = ShapeCastSettings.createDefault();
        this.setVirtualAddressAsOwner(settingsVa);
    }

    public ShapeCastSettings(ShapeCastSettings original) {
        long originalVa = original.va();
        long copyVa = ShapeCastSettings.createCopy(originalVa);
        this.setVirtualAddressAsOwner(copyVa);
    }

    public EBackFaceMode getBackFaceModeConvex() {
        long settingsVa = this.va();
        int ordinal = ShapeCastSettings.getBackFaceModeConvex(settingsVa);
        EBackFaceMode result = EBackFaceMode.values()[ordinal];
        return result;
    }

    public EBackFaceMode getBackFaceModeTriangles() {
        long settingsVa = this.va();
        int ordinal = ShapeCastSettings.getBackFaceModeTriangles(settingsVa);
        EBackFaceMode result = EBackFaceMode.values()[ordinal];
        return result;
    }

    public boolean getReturnDeepestPoint() {
        long settingsVa = this.va();
        boolean result = ShapeCastSettings.getReturnDeepestPoint(settingsVa);
        return result;
    }

    public boolean getUseShrunkenShapeAndConvexRadius() {
        long settingsVa = this.va();
        boolean result = ShapeCastSettings.getUseShrunkenShapeAndConvexRadius(settingsVa);
        return result;
    }

    public void setBackFaceModeConvex(EBackFaceMode mode) {
        long settingsVa = this.va();
        int ordinal = mode.ordinal();
        ShapeCastSettings.setBackFaceModeConvex(settingsVa, ordinal);
    }

    public void setBackFaceModeTriangles(EBackFaceMode mode) {
        long settingsVa = this.va();
        int ordinal = mode.ordinal();
        ShapeCastSettings.setBackFaceModeTriangles(settingsVa, ordinal);
    }

    public void setReturnDeepestPoint(boolean enable) {
        long settingsVa = this.va();
        ShapeCastSettings.setReturnDeepestPoint(settingsVa, enable);
    }

    public void setUseShrunkenShapeAndConvexRadius(boolean enable) {
        long settingsVa = this.va();
        ShapeCastSettings.setUseShrunkenShapeAndConvexRadius(settingsVa, enable);
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native int getBackFaceModeConvex(long var0);

    private static native int getBackFaceModeTriangles(long var0);

    private static native boolean getReturnDeepestPoint(long var0);

    private static native boolean getUseShrunkenShapeAndConvexRadius(long var0);

    private static native void setBackFaceModeConvex(long var0, int var2);

    private static native void setBackFaceModeTriangles(long var0, int var2);

    private static native void setReturnDeepestPoint(long var0, boolean var2);

    private static native void setUseShrunkenShapeAndConvexRadius(long var0, boolean var2);
}

