/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.MotorSettings;
import com.github.stephengold.joltjni.Quat;
import com.github.stephengold.joltjni.SpringSettings;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.TwoBodyConstraint;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EAxis;
import com.github.stephengold.joltjni.enumerate.EMotorState;
import com.github.stephengold.joltjni.readonly.ConstSpringSettings;
import com.github.stephengold.joltjni.readonly.QuatArg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public class SixDofConstraint
extends TwoBodyConstraint {
    SixDofConstraint(long constraintVa) {
        this.setVirtualAddressAsCoOwner(constraintVa);
    }

    public float getLimitsMax(EAxis dof) {
        long constraintVa = this.va();
        int dofIndex = dof.ordinal();
        float result = SixDofConstraint.getLimitsMax(constraintVa, dofIndex);
        return result;
    }

    public float getLimitsMin(EAxis dof) {
        long constraintVa = this.va();
        int dofOrdinal = dof.ordinal();
        float result = SixDofConstraint.getLimitsMin(constraintVa, dofOrdinal);
        return result;
    }

    public ConstSpringSettings getLimitsSpringSettings(EAxis dof) {
        long constraintVa = this.va();
        int dofOrdinal = dof.ordinal();
        long settingsVa = SixDofConstraint.getLimitsSpringSettings(constraintVa, dofOrdinal);
        SpringSettings result = new SpringSettings(this, settingsVa);
        return result;
    }

    public float getMaxFriction(EAxis dof) {
        long constraintVa = this.va();
        int dofIndex = dof.ordinal();
        float result = SixDofConstraint.getMaxFriction(constraintVa, dofIndex);
        return result;
    }

    public MotorSettings getMotorSettings(EAxis dof) {
        long constraintVa = this.va();
        int dofIndex = dof.ordinal();
        long settingsVa = SixDofConstraint.getMotorSettings(constraintVa, dofIndex);
        MotorSettings result = new MotorSettings(this, settingsVa);
        return result;
    }

    public EMotorState getMotorState(EAxis dof) {
        long constraintVa = this.va();
        int dofIndex = dof.ordinal();
        int stateOrdinal = SixDofConstraint.getMotorState(constraintVa, dofIndex);
        EMotorState result = EMotorState.values()[stateOrdinal];
        return result;
    }

    public Quat getRotationInConstraintSpace() {
        long constraintVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        SixDofConstraint.getRotationInConstraintSpace(constraintVa, storeFloats);
        Quat result = new Quat(storeFloats);
        return result;
    }

    public Vec3 getRotationLimitsMax() {
        long constraintVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        SixDofConstraint.getRotationLimitsMax(constraintVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Vec3 getRotationLimitsMin() {
        long constraintVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        SixDofConstraint.getRotationLimitsMin(constraintVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Vec3 getTargetAngularVelocityCs() {
        long constraintVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        SixDofConstraint.getTargetAngularVelocityCs(constraintVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Vec3 getTargetPositionCs() {
        long constraintVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        SixDofConstraint.getTargetPositionCs(constraintVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Quat getTargetOrientationCs() {
        long constraintVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        SixDofConstraint.getTargetOrientationCs(constraintVa, storeFloats);
        Quat result = new Quat(storeFloats);
        return result;
    }

    public Vec3 getTargetVelocityCs() {
        long constraintVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        SixDofConstraint.getTargetVelocityCs(constraintVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Vec3 getTranslationLimitsMax() {
        long constraintVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        SixDofConstraint.getTranslationLimitsMax(constraintVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Vec3 getTranslationLimitsMin() {
        long constraintVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        SixDofConstraint.getTranslationLimitsMin(constraintVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public boolean isFixedAxis(EAxis dof) {
        long constraintVa = this.va();
        int dofIndex = dof.ordinal();
        boolean result = SixDofConstraint.isFixedAxis(constraintVa, dofIndex);
        return result;
    }

    public boolean isFreeAxis(EAxis dof) {
        long constraintVa = this.va();
        int dofIndex = dof.ordinal();
        boolean result = SixDofConstraint.isFreeAxis(constraintVa, dofIndex);
        return result;
    }

    public void setLimitsSpringSettings(EAxis dof, ConstSpringSettings springSettings) {
        long constraintVa = this.va();
        int dofIndex = dof.ordinal();
        long settingsVa = springSettings.targetVa();
        SixDofConstraint.setLimitsSpringSettings(constraintVa, dofIndex, settingsVa);
    }

    public void setMaxFriction(EAxis dof, float friction) {
        long constraintVa = this.va();
        int dofIndex = dof.ordinal();
        SixDofConstraint.setMaxFriction(constraintVa, dofIndex, friction);
    }

    public void setMotorState(EAxis dof, EMotorState state) {
        long constraintVa = this.va();
        int dofIndex = dof.ordinal();
        int stateOrdinal = state.ordinal();
        SixDofConstraint.setMotorState(constraintVa, dofIndex, stateOrdinal);
    }

    public void setRotationLimits(Vec3Arg min, Vec3Arg max) {
        long constraintVa = this.va();
        float minX = min.getX();
        float minY = min.getY();
        float minZ = min.getZ();
        float maxX = max.getX();
        float maxY = max.getY();
        float maxZ = max.getZ();
        SixDofConstraint.setRotationLimits(constraintVa, minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void setTargetVelocityCs(Vec3Arg velocity) {
        long constraintVa = this.va();
        float vx = velocity.getX();
        float vy = velocity.getY();
        float vz = velocity.getZ();
        SixDofConstraint.setTargetVelocityCs(constraintVa, vx, vy, vz);
    }

    public void setTargetAngularVelocityCs(Vec3Arg omega) {
        long constraintVa = this.va();
        float wx = omega.getX();
        float wy = omega.getY();
        float wz = omega.getZ();
        SixDofConstraint.setTargetAngularVelocityCs(constraintVa, wx, wy, wz);
    }

    public void setTargetPositionCs(Vec3Arg offsets) {
        long constraintVa = this.va();
        float x = offsets.getX();
        float y = offsets.getY();
        float z = offsets.getZ();
        SixDofConstraint.setTargetPositionCs(constraintVa, x, y, z);
    }

    public void setTargetOrientationBs(QuatArg orientation) {
        long constraintVa = this.va();
        float qw = orientation.getW();
        float qx = orientation.getX();
        float qy = orientation.getY();
        float qz = orientation.getZ();
        SixDofConstraint.setTargetOrientationBs(constraintVa, qx, qy, qz, qw);
    }

    public void setTargetOrientationCs(QuatArg orientation) {
        long constraintVa = this.va();
        float qw = orientation.getW();
        float qx = orientation.getX();
        float qy = orientation.getY();
        float qz = orientation.getZ();
        SixDofConstraint.setTargetOrientationCs(constraintVa, qx, qy, qz, qw);
    }

    public void setTranslationLimits(Vec3Arg min, Vec3Arg max) {
        long constraintVa = this.va();
        float minX = min.getX();
        float minY = min.getY();
        float minZ = min.getZ();
        float maxX = max.getX();
        float maxY = max.getY();
        float maxZ = max.getZ();
        SixDofConstraint.setTranslationLimits(constraintVa, minX, minY, minZ, maxX, maxY, maxZ);
    }

    private static native float getLimitsMax(long var0, int var2);

    private static native float getLimitsMin(long var0, int var2);

    private static native long getLimitsSpringSettings(long var0, int var2);

    private static native float getMaxFriction(long var0, int var2);

    private static native long getMotorSettings(long var0, int var2);

    private static native int getMotorState(long var0, int var2);

    private static native void getRotationInConstraintSpace(long var0, FloatBuffer var2);

    private static native void getRotationLimitsMax(long var0, FloatBuffer var2);

    private static native void getRotationLimitsMin(long var0, FloatBuffer var2);

    private static native void getTargetAngularVelocityCs(long var0, FloatBuffer var2);

    private static native void getTargetPositionCs(long var0, FloatBuffer var2);

    private static native void getTargetOrientationCs(long var0, FloatBuffer var2);

    private static native void getTargetVelocityCs(long var0, FloatBuffer var2);

    private static native void getTranslationLimitsMax(long var0, FloatBuffer var2);

    private static native void getTranslationLimitsMin(long var0, FloatBuffer var2);

    private static native boolean isFixedAxis(long var0, int var2);

    private static native boolean isFreeAxis(long var0, int var2);

    private static native void setLimitsSpringSettings(long var0, int var2, long var3);

    private static native void setMaxFriction(long var0, int var2, float var3);

    private static native void setMotorState(long var0, int var2, int var3);

    private static native void setRotationLimits(long var0, float var2, float var3, float var4, float var5, float var6, float var7);

    private static native void setTargetAngularVelocityCs(long var0, float var2, float var3, float var4);

    private static native void setTargetPositionCs(long var0, float var2, float var3, float var4);

    private static native void setTargetOrientationBs(long var0, float var2, float var3, float var4, float var5);

    private static native void setTargetOrientationCs(long var0, float var2, float var3, float var4, float var5);

    private static native void setTargetVelocityCs(long var0, float var2, float var3, float var4);

    private static native void setTranslationLimits(long var0, float var2, float var3, float var4, float var5, float var6, float var7);
}

