/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.MotorSettings;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.SpringSettings;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.TwoBodyConstraintSettings;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EAxis;
import com.github.stephengold.joltjni.enumerate.EConstraintSpace;
import com.github.stephengold.joltjni.enumerate.EConstraintSubType;
import com.github.stephengold.joltjni.enumerate.ESwingType;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public class SixDofConstraintSettings
extends TwoBodyConstraintSettings {
    public SixDofConstraintSettings() {
        long settingsVa = SixDofConstraintSettings.createDefault();
        this.setVirtualAddressAsCoOwner(settingsVa, EConstraintSubType.SixDof);
    }

    SixDofConstraintSettings(long settingsVa) {
        this.setVirtualAddressAsCoOwner(settingsVa, EConstraintSubType.SixDof);
    }

    public SixDofConstraintSettings(SixDofConstraintSettings original) {
        long originalVa = original.va();
        long copyVa = SixDofConstraintSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa, EConstraintSubType.SixDof);
    }

    public Vec3 getAxisX1() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        SixDofConstraintSettings.getAxisX1(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Vec3 getAxisX2() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        SixDofConstraintSettings.getAxisX2(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Vec3 getAxisY1() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        SixDofConstraintSettings.getAxisY1(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Vec3 getAxisY2() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        SixDofConstraintSettings.getAxisY2(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public float getLimitMax(EAxis dof) {
        int dofIndex = dof.ordinal();
        float result = this.getLimitMax(dofIndex);
        return result;
    }

    public float getLimitMax(int dofIndex) {
        long settingsVa = this.va();
        float result = SixDofConstraintSettings.getLimitMax(settingsVa, dofIndex);
        return result;
    }

    public float getLimitMin(EAxis dof) {
        int dofIndex = dof.ordinal();
        float result = this.getLimitMin(dofIndex);
        return result;
    }

    public float getLimitMin(int dofIndex) {
        long settingsVa = this.va();
        float result = SixDofConstraintSettings.getLimitMin(settingsVa, dofIndex);
        return result;
    }

    public SpringSettings getLimitsSpringSettings(EAxis translationDof) {
        long constraintSettingsVa = this.va();
        int dofIndex = translationDof.ordinal();
        assert (dofIndex < 3) : dofIndex;
        long springSettingsVa = SixDofConstraintSettings.getLimitsSpringSettings(constraintSettingsVa, dofIndex);
        SpringSettings result = new SpringSettings(this, springSettingsVa);
        return result;
    }

    public float getMaxFriction(EAxis dof) {
        long settingsVa = this.va();
        int dofIndex = dof.ordinal();
        float result = SixDofConstraintSettings.getMaxFriction(settingsVa, dofIndex);
        return result;
    }

    public MotorSettings getMotorSettings(EAxis dof) {
        int dofIndex = dof.ordinal();
        MotorSettings result = this.getMotorSettings(dofIndex);
        return result;
    }

    public MotorSettings getMotorSettings(int dofIndex) {
        long constraintSettingsVa = this.va();
        long motorSettingsVa = SixDofConstraintSettings.getMotorSettings(constraintSettingsVa, dofIndex);
        MotorSettings result = new MotorSettings(this, motorSettingsVa);
        return result;
    }

    public RVec3 getPosition1() {
        long settingsVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        SixDofConstraintSettings.getPosition1(settingsVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    public RVec3 getPosition2() {
        long settingsVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        SixDofConstraintSettings.getPosition2(settingsVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    public EConstraintSpace getSpace() {
        long settingsVa = this.va();
        int ordinal = SixDofConstraintSettings.getSpace(settingsVa);
        EConstraintSpace result = EConstraintSpace.values()[ordinal];
        return result;
    }

    public ESwingType getSwingType() {
        long settingsVa = this.va();
        int ordinal = SixDofConstraintSettings.getSwingType(settingsVa);
        ESwingType result = ESwingType.values()[ordinal];
        return result;
    }

    public boolean isFixedAxis(EAxis dof) {
        long settingsVa = this.va();
        int dofIndex = dof.ordinal();
        boolean result = SixDofConstraintSettings.isFixedAxis(settingsVa, dofIndex);
        return result;
    }

    public boolean isFreeAxis(EAxis dof) {
        long settingsVa = this.va();
        int dofIndex = dof.ordinal();
        boolean result = SixDofConstraintSettings.isFreeAxis(settingsVa, dofIndex);
        return result;
    }

    public void makeFixedAxis(EAxis dof) {
        int dofIndex = dof.ordinal();
        this.makeFixedAxis(dofIndex);
    }

    public void makeFixedAxis(int dofIndex) {
        long settingsVa = this.va();
        SixDofConstraintSettings.makeFixedAxis(settingsVa, dofIndex);
    }

    public void makeFreeAxis(EAxis dof) {
        int dofIndex = dof.ordinal();
        this.makeFreeAxis(dofIndex);
    }

    public void makeFreeAxis(int dofIndex) {
        long settingsVa = this.va();
        SixDofConstraintSettings.makeFreeAxis(settingsVa, dofIndex);
    }

    public Vec3Arg setAxisX1(Vec3Arg axis) {
        long settingsVa = this.va();
        float x = axis.getX();
        float y = axis.getY();
        float z = axis.getZ();
        SixDofConstraintSettings.setAxisX1(settingsVa, x, y, z);
        return axis;
    }

    public Vec3Arg setAxisX2(Vec3Arg axis) {
        long settingsVa = this.va();
        float x = axis.getX();
        float y = axis.getY();
        float z = axis.getZ();
        SixDofConstraintSettings.setAxisX2(settingsVa, x, y, z);
        return axis;
    }

    public Vec3Arg setAxisY1(Vec3Arg axis) {
        long settingsVa = this.va();
        float x = axis.getX();
        float y = axis.getY();
        float z = axis.getZ();
        SixDofConstraintSettings.setAxisY1(settingsVa, x, y, z);
        return axis;
    }

    public Vec3Arg setAxisY2(Vec3Arg axis) {
        long settingsVa = this.va();
        float x = axis.getX();
        float y = axis.getY();
        float z = axis.getZ();
        SixDofConstraintSettings.setAxisY2(settingsVa, x, y, z);
        return axis;
    }

    public void setLimitedAxis(EAxis dof, float min, float max) {
        int dofIndex = dof.ordinal();
        this.setLimitedAxis(dofIndex, min, max);
    }

    public void setLimitedAxis(int dofIndex, float min, float max) {
        long settingsVa = this.va();
        SixDofConstraintSettings.setLimitedAxis(settingsVa, dofIndex, min, max);
    }

    public void setLimitMax(EAxis dof, float max) {
        long settingsVa = this.va();
        int dofIndex = dof.ordinal();
        SixDofConstraintSettings.setLimitMax(settingsVa, dofIndex, max);
    }

    public void setLimitMin(EAxis dof, float min) {
        long settingsVa = this.va();
        int dofIndex = dof.ordinal();
        SixDofConstraintSettings.setLimitMin(settingsVa, dofIndex, min);
    }

    public void setMaxFriction(EAxis dof, float friction) {
        long settingsVa = this.va();
        int dofIndex = dof.ordinal();
        SixDofConstraintSettings.setMaxFriction(settingsVa, dofIndex, friction);
    }

    public MotorSettings setMotorSettings(EAxis dof, MotorSettings motorSettings) {
        int dofIndex = dof.ordinal();
        this.setMotorSettings(dofIndex, motorSettings);
        return motorSettings;
    }

    public void setMotorSettings(int dofIndex, MotorSettings motorSettings) {
        long constraintSettingsVa = this.va();
        long motorSettingsVa = motorSettings.va();
        SixDofConstraintSettings.setMotorSettings(constraintSettingsVa, dofIndex, motorSettingsVa);
    }

    public RVec3Arg setPosition1(RVec3Arg location) {
        long settingsVa = this.va();
        double x = location.xx();
        double y = location.yy();
        double z = location.zz();
        SixDofConstraintSettings.setPosition1(settingsVa, x, y, z);
        return location;
    }

    public RVec3Arg setPosition2(RVec3Arg location) {
        long settingsVa = this.va();
        double x = location.xx();
        double y = location.yy();
        double z = location.zz();
        SixDofConstraintSettings.setPosition2(settingsVa, x, y, z);
        return location;
    }

    public void setSpace(EConstraintSpace space) {
        long settingsVa = this.va();
        int ordinal = space.ordinal();
        SixDofConstraintSettings.setSpace(settingsVa, ordinal);
    }

    public void setSwingType(ESwingType swingType) {
        long settingsVa = this.va();
        int ordinal = swingType.ordinal();
        SixDofConstraintSettings.setSwingType(settingsVa, ordinal);
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native void getAxisX1(long var0, FloatBuffer var2);

    private static native void getAxisX2(long var0, FloatBuffer var2);

    private static native void getAxisY1(long var0, FloatBuffer var2);

    private static native void getAxisY2(long var0, FloatBuffer var2);

    private static native float getLimitMax(long var0, int var2);

    private static native float getLimitMin(long var0, int var2);

    private static native long getLimitsSpringSettings(long var0, int var2);

    private static native float getMaxFriction(long var0, int var2);

    private static native long getMotorSettings(long var0, int var2);

    private static native void getPosition1(long var0, DoubleBuffer var2);

    private static native void getPosition2(long var0, DoubleBuffer var2);

    private static native int getSpace(long var0);

    private static native int getSwingType(long var0);

    private static native boolean isFixedAxis(long var0, int var2);

    private static native boolean isFreeAxis(long var0, int var2);

    private static native void makeFixedAxis(long var0, int var2);

    private static native void makeFreeAxis(long var0, int var2);

    private static native void setAxisX1(long var0, float var2, float var3, float var4);

    private static native void setAxisX2(long var0, float var2, float var3, float var4);

    private static native void setAxisY1(long var0, float var2, float var3, float var4);

    private static native void setAxisY2(long var0, float var2, float var3, float var4);

    private static native void setLimitedAxis(long var0, int var2, float var3, float var4);

    private static native void setLimitMax(long var0, int var2, float var3);

    private static native void setLimitMin(long var0, int var2, float var3);

    private static native void setMaxFriction(long var0, int var2, float var3);

    private static native void setMotorSettings(long var0, int var2, long var3);

    private static native void setPosition1(long var0, double var2, double var4, double var6);

    private static native void setPosition2(long var0, double var2, double var4, double var6);

    private static native void setSpace(long var0, int var2);

    private static native void setSwingType(long var0, int var2);
}

