/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Joint;
import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.SkeletonRef;
import com.github.stephengold.joltjni.StreamOut;
import com.github.stephengold.joltjni.readonly.ConstSkeleton;
import com.github.stephengold.joltjni.template.RefTarget;

public class Skeleton
extends JoltPhysicsObject
implements ConstSkeleton,
RefTarget {
    public Skeleton() {
        long skeletonVa = Skeleton.createDefault();
        long refVa = Skeleton.toRef(skeletonVa);
        Runnable freeingAction = () -> SkeletonRef.free(refVa);
        this.setVirtualAddress(skeletonVa, freeingAction);
    }

    Skeleton(long skeletonVa) {
        long refVa = Skeleton.toRef(skeletonVa);
        Runnable freeingAction = () -> SkeletonRef.free(refVa);
        this.setVirtualAddress(skeletonVa, freeingAction);
    }

    public int addJoint(String name) {
        long skeletonVa = this.va();
        int result = Skeleton.addRootJoint(skeletonVa, name);
        return result;
    }

    public int addJoint(String name, int parentIndex) {
        long skeletonVa = this.va();
        int result = Skeleton.addJointWithParent(skeletonVa, name, parentIndex);
        return result;
    }

    public void calculateParentJointIndices() {
        long skeletonVa = this.va();
        Skeleton.calculateParentJointIndices(skeletonVa);
    }

    @Override
    public boolean areJointsCorrectlyOrdered() {
        long skeletonVa = this.va();
        boolean result = Skeleton.areJointsCorrectlyOrdered(skeletonVa);
        return result;
    }

    @Override
    public Joint getJoint(int jointIndex) {
        long skeletonVa = this.va();
        long resultVa = Skeleton.getJoint(skeletonVa, jointIndex);
        Joint result = new Joint(this, resultVa);
        return result;
    }

    @Override
    public int getJointCount() {
        long skeletonVa = this.va();
        int result = Skeleton.getJointCount(skeletonVa);
        return result;
    }

    @Override
    public int getJointIndex(String name) {
        long skeletonVa = this.va();
        int result = Skeleton.getJointIndex(skeletonVa, name);
        return result;
    }

    public Joint[] getJoints() {
        long skeletonVa = this.va();
        int numJoints = Skeleton.getJointCount(skeletonVa);
        Joint[] result = new Joint[numJoints];
        for (int i = 0; i < numJoints; ++i) {
            long jointVa = Skeleton.getJoint(skeletonVa, i);
            result[i] = new Joint(this, jointVa);
        }
        return result;
    }

    @Override
    public void saveBinaryState(StreamOut stream) {
        long skeletonVa = this.va();
        long streamVa = stream.va();
        Skeleton.saveBinaryState(skeletonVa, streamVa);
    }

    @Override
    public int getRefCount() {
        long skeletonVa = this.va();
        int result = Skeleton.getRefCount(skeletonVa);
        return result;
    }

    @Override
    public void setEmbedded() {
        long skeletonVa = this.va();
        Skeleton.setEmbedded(skeletonVa);
    }

    @Override
    public SkeletonRef toRef() {
        long skeletonVa = this.va();
        long refVa = Skeleton.toRef(skeletonVa);
        SkeletonRef result = new SkeletonRef(refVa, true);
        return result;
    }

    static native int addJointWithParent(long var0, String var2, int var3);

    static native int addRootJoint(long var0, String var2);

    static native boolean areJointsCorrectlyOrdered(long var0);

    private static native void calculateParentJointIndices(long var0);

    private static native long createDefault();

    static native long getJoint(long var0, int var2);

    static native int getJointCount(long var0);

    static native int getJointIndex(long var0, String var2);

    private static native int getRefCount(long var0);

    static native void saveBinaryState(long var0, long var2);

    private static native void setEmbedded(long var0);

    private static native long toRef(long var0);
}

