/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;

public class SkinWeight
extends JoltPhysicsObject {
    public SkinWeight() {
        long weightVa = SkinWeight.createDefault();
        this.setVirtualAddress(weightVa, () -> SkinWeight.free(weightVa));
    }

    public SkinWeight(int invBindIndex, float weight) {
        long weightVa = SkinWeight.create(invBindIndex, weight);
        this.setVirtualAddress(weightVa, () -> SkinWeight.free(weightVa));
    }

    SkinWeight(JoltPhysicsObject container, long weightVa) {
        super(container, weightVa);
    }

    public SkinWeight(SkinWeight original) {
        long originalVa = original.va();
        long copyVa = SkinWeight.createCopy(originalVa);
        this.setVirtualAddress(copyVa, () -> SkinWeight.free(copyVa));
    }

    public int getInvBindIndex() {
        long weightVa = this.va();
        int result = SkinWeight.getInvBindIndex(weightVa);
        return result;
    }

    public float getWeight() {
        long weightVa = this.va();
        float result = SkinWeight.getWeight(weightVa);
        return result;
    }

    private static native long create(int var0, float var1);

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native void free(long var0);

    private static native int getInvBindIndex(long var0);

    private static native float getWeight(long var0);
}

