/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.JoltPhysicsObject;
import com.github.stephengold.joltjni.SkinWeight;

public class Skinned
extends JoltPhysicsObject {
    public Skinned() {
        long skinnedVa = Skinned.createDefault();
        this.setVirtualAddress(skinnedVa, () -> Skinned.free(skinnedVa));
    }

    public Skinned(int vertexIndex, float maxDistance, float backstopDistance, float backstopRadius) {
        long skinnedVa = Skinned.createBackstopped(vertexIndex, maxDistance, backstopDistance, backstopRadius);
        this.setVirtualAddress(skinnedVa, () -> Skinned.free(skinnedVa));
    }

    public Skinned(Skinned original) {
        long originalVa = original.va();
        long copyVa = Skinned.createCopy(originalVa);
        this.setVirtualAddress(copyVa, () -> Skinned.free(copyVa));
    }

    public SkinWeight getWeight(int index) {
        if (index < 0 || index >= 4) {
            throw new IllegalArgumentException("index must be 0, 1, 2, or 3");
        }
        long skinnedVa = this.va();
        long weightVa = Skinned.getWeight(skinnedVa, index);
        SkinWeight result = new SkinWeight(this, weightVa);
        return result;
    }

    public void normalizeWeights() {
        long skinnedVa = this.va();
        Skinned.normalizeWeights(skinnedVa);
    }

    public void setWeight(int index, SkinWeight weight) {
        if (index < 0 || index >= 4) {
            throw new IllegalArgumentException("index must be 0, 1, 2, or 3");
        }
        long skinnedVa = this.va();
        long weightVa = weight.va();
        Skinned.setWeight(skinnedVa, index, weightVa);
    }

    private static native long createBackstopped(int var0, float var1, float var2, float var3);

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native void free(long var0);

    private static native long getWeight(long var0, int var2);

    private static native void normalizeWeights(long var0);

    private static native void setWeight(long var0, int var2, long var3);
}

