/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.MotorSettings;
import com.github.stephengold.joltjni.SpringSettings;
import com.github.stephengold.joltjni.TwoBodyConstraint;
import com.github.stephengold.joltjni.enumerate.EMotorState;

public class SliderConstraint
extends TwoBodyConstraint {
    SliderConstraint(long constraintVa) {
        this.setVirtualAddressAsCoOwner(constraintVa);
    }

    public float getCurrentPosition() {
        long constraintVa = this.va();
        float result = SliderConstraint.getCurrentPosition(constraintVa);
        return result;
    }

    public float getLimitsMax() {
        long constraintVa = this.va();
        float result = SliderConstraint.getLimitsMax(constraintVa);
        return result;
    }

    public float getLimitsMin() {
        long constraintVa = this.va();
        float result = SliderConstraint.getLimitsMin(constraintVa);
        return result;
    }

    public SpringSettings getLimitsSpringSettings() {
        long constraintVa = this.va();
        long settingsVa = SliderConstraint.getLimitsSpringSettings(constraintVa);
        SpringSettings result = new SpringSettings(this, settingsVa);
        return result;
    }

    public float getMaxFrictionForce() {
        long constraintVa = this.va();
        float result = SliderConstraint.getMaxFrictionForce(constraintVa);
        return result;
    }

    public MotorSettings getMotorSettings() {
        long constraintVa = this.va();
        long settingsVa = SliderConstraint.getMotorSettings(constraintVa);
        MotorSettings result = new MotorSettings(this, settingsVa);
        return result;
    }

    public EMotorState getMotorState() {
        long constraintVa = this.va();
        int ordinal = SliderConstraint.getMotorState(constraintVa);
        EMotorState result = EMotorState.values()[ordinal];
        return result;
    }

    public float getTargetPosition() {
        long constraintVa = this.va();
        float result = SliderConstraint.getTargetPosition(constraintVa);
        return result;
    }

    public float getTargetVelocity() {
        long constraintVa = this.va();
        float result = SliderConstraint.getTargetVelocity(constraintVa);
        return result;
    }

    public boolean hasLimits() {
        long constraintVa = this.va();
        boolean result = SliderConstraint.hasLimits(constraintVa);
        return result;
    }

    public void setLimits(float min, float max) {
        long constraintVa = this.va();
        SliderConstraint.setLimits(constraintVa, min, max);
    }

    public void setMaxFrictionForce(float force) {
        long constraintVa = this.va();
        SliderConstraint.setMaxFrictionForce(constraintVa, force);
    }

    public void setMotorState(EMotorState state) {
        long constraintVa = this.va();
        int ordinal = state.ordinal();
        SliderConstraint.setMotorState(constraintVa, ordinal);
    }

    public void setTargetPosition(float offset) {
        long constraintVa = this.va();
        SliderConstraint.setTargetPosition(constraintVa, offset);
    }

    public void setTargetVelocity(float velocity) {
        long constraintVa = this.va();
        SliderConstraint.setTargetVelocity(constraintVa, velocity);
    }

    private static native float getCurrentPosition(long var0);

    private static native float getLimitsMax(long var0);

    private static native float getLimitsMin(long var0);

    private static native long getLimitsSpringSettings(long var0);

    private static native float getMaxFrictionForce(long var0);

    private static native long getMotorSettings(long var0);

    private static native int getMotorState(long var0);

    private static native float getTargetPosition(long var0);

    private static native float getTargetVelocity(long var0);

    private static native boolean hasLimits(long var0);

    private static native void setLimits(long var0, float var2, float var3);

    private static native void setMaxFrictionForce(long var0, float var2);

    private static native void setMotorState(long var0, int var2);

    private static native void setTargetPosition(long var0, float var2);

    private static native void setTargetVelocity(long var0, float var2);
}

