/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.ConvexShapeSettings;
import com.github.stephengold.joltjni.enumerate.EShapeSubType;
import com.github.stephengold.joltjni.readonly.ConstPhysicsMaterial;

public class SphereShapeSettings
extends ConvexShapeSettings {
    public SphereShapeSettings() {
        long settingsVa = SphereShapeSettings.createDefault();
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Sphere);
    }

    public SphereShapeSettings(float radius) {
        this(radius, null);
    }

    public SphereShapeSettings(float radius, ConstPhysicsMaterial material) {
        long materialVa = material == null ? 0L : material.targetVa();
        long settingsVa = SphereShapeSettings.createSphereShapeSettings(radius, materialVa);
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Sphere);
    }

    SphereShapeSettings(long settingsVa) {
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.Sphere);
    }

    public SphereShapeSettings(SphereShapeSettings original) {
        long originalVa = original.va();
        long copyVa = SphereShapeSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa, EShapeSubType.Sphere);
    }

    public float getRadius() {
        long settingsVa = this.va();
        float result = SphereShapeSettings.getRadius(settingsVa);
        return result;
    }

    public void setRadius(float radius) {
        long settingsVa = this.va();
        SphereShapeSettings.setRadius(settingsVa, radius);
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native long createSphereShapeSettings(float var0, long var1);

    private static native float getRadius(long var0);

    private static native void setRadius(long var0, float var2);
}

