/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.BodyIdVector;
import com.github.stephengold.joltjni.NonCopyable;
import com.github.stephengold.joltjni.RMat44;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.RMat44Arg;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public class StateRecorder
extends NonCopyable {
    StateRecorder() {
    }

    public boolean isValidating() {
        long recorderVa = this.va();
        boolean result = StateRecorder.isValidating(recorderVa);
        return result;
    }

    public void readBodyIdVector(BodyIdVector storeResult) {
        long recorderVa = this.va();
        long vectorVa = storeResult.va();
        StateRecorder.readBodyIdVector(recorderVa, vectorVa);
    }

    public boolean readBoolean(boolean b) {
        long recorderVa = this.va();
        boolean result = StateRecorder.readBoolean(recorderVa, b);
        return result;
    }

    public float readFloat(float f) {
        long recorderVa = this.va();
        float result = StateRecorder.readFloat(recorderVa, f);
        return result;
    }

    public int readInt(int i) {
        long recorderVa = this.va();
        int result = StateRecorder.readInt(recorderVa, i);
        return result;
    }

    public void readRMat44(RMat44 inOut) {
        long recorderVa = this.va();
        long matrixVa = inOut.va();
        StateRecorder.readRMat44(recorderVa, matrixVa);
    }

    public void readRVec3(RVec3 inOut) {
        long recorderVa = this.va();
        DoubleBuffer doubleBuffer = Temporaries.doubleBuffer1.get();
        inOut.copyTo(doubleBuffer);
        StateRecorder.readRVec3(recorderVa, doubleBuffer);
        inOut.set(doubleBuffer);
    }

    public String readString(String javaString) {
        long recorderVa = this.va();
        String result = StateRecorder.readString(recorderVa, javaString);
        return result;
    }

    public void readVec3(Vec3 inOut) {
        long recorderVa = this.va();
        FloatBuffer floatBuffer = Temporaries.floatBuffer1.get();
        inOut.copyTo(floatBuffer);
        StateRecorder.readVec3(recorderVa, floatBuffer);
        inOut.set(floatBuffer);
    }

    public void setValidating(boolean setting) {
        long recorderVa = this.va();
        StateRecorder.setValidating(recorderVa, setting);
    }

    public void write(BodyIdVector vector) {
        long recorderVa = this.va();
        long vectorVa = vector.va();
        StateRecorder.writeBodyIdVector(recorderVa, vectorVa);
    }

    public void write(boolean b) {
        long recorderVa = this.va();
        StateRecorder.writeBoolean(recorderVa, b);
    }

    public void write(float f) {
        long recorderVa = this.va();
        StateRecorder.writeFloat(recorderVa, f);
    }

    public void write(int i) {
        long recorderVa = this.va();
        StateRecorder.writeInt(recorderVa, i);
    }

    public void write(RMat44Arg matrix) {
        long recorderVa = this.va();
        long matrixVa = matrix.targetVa();
        StateRecorder.writeRMat44(recorderVa, matrixVa);
    }

    public void write(RVec3Arg v) {
        long recorderVa = this.va();
        double xx = v.xx();
        double yy = v.yy();
        double zz = v.zz();
        StateRecorder.writeRVec3(recorderVa, xx, yy, zz);
    }

    public void write(String javaString) {
        long recorderVa = this.va();
        StateRecorder.writeString(recorderVa, javaString);
    }

    public void write(Vec3Arg v) {
        long recorderVa = this.va();
        float x = v.getX();
        float y = v.getY();
        float z = v.getZ();
        StateRecorder.writeVec3(recorderVa, x, y, z);
    }

    final void setVirtualAddressAsOwner(long recorderVa) {
        Runnable freeingAction = () -> StateRecorder.free(recorderVa);
        this.setVirtualAddress(recorderVa, freeingAction);
    }

    private static native void free(long var0);

    private static native boolean isValidating(long var0);

    private static native void readBodyIdVector(long var0, long var2);

    private static native boolean readBoolean(long var0, boolean var2);

    private static native float readFloat(long var0, float var2);

    private static native int readInt(long var0, int var2);

    private static native void readRMat44(long var0, long var2);

    private static native void readRVec3(long var0, DoubleBuffer var2);

    private static native String readString(long var0, String var2);

    private static native void readVec3(long var0, FloatBuffer var2);

    private static native void setValidating(long var0, boolean var2);

    private static native void writeBodyIdVector(long var0, long var2);

    private static native void writeBoolean(long var0, boolean var2);

    private static native void writeFloat(long var0, float var2);

    private static native void writeInt(long var0, int var2);

    private static native void writeRMat44(long var0, long var2);

    private static native void writeRVec3(long var0, double var2, double var4, double var6);

    private static native void writeString(long var0, String var2);

    private static native void writeVec3(long var0, float var2, float var3, float var4);
}

