/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.MotorSettings;
import com.github.stephengold.joltjni.RVec3;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.TwoBodyConstraintSettings;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.enumerate.EConstraintSpace;
import com.github.stephengold.joltjni.enumerate.EConstraintSubType;
import com.github.stephengold.joltjni.enumerate.ESwingType;
import com.github.stephengold.joltjni.readonly.RVec3Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public class SwingTwistConstraintSettings
extends TwoBodyConstraintSettings {
    public SwingTwistConstraintSettings() {
        long settingsVa = SwingTwistConstraintSettings.createDefault();
        this.setVirtualAddressAsCoOwner(settingsVa, EConstraintSubType.SwingTwist);
    }

    SwingTwistConstraintSettings(long settingsVa) {
        this.setVirtualAddressAsCoOwner(settingsVa, EConstraintSubType.SwingTwist);
    }

    public SwingTwistConstraintSettings(SwingTwistConstraintSettings original) {
        long originalVa = original.targetVa();
        long copyVa = SwingTwistConstraintSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa, EConstraintSubType.SwingTwist);
    }

    public float getMaxFrictionTorque() {
        long settingsVa = this.va();
        float result = SwingTwistConstraintSettings.getMaxFrictionTorque(settingsVa);
        return result;
    }

    public float getNormalHalfConeAngle() {
        long settingsVa = this.va();
        float result = SwingTwistConstraintSettings.getNormalHalfConeAngle(settingsVa);
        return result;
    }

    public Vec3 getPlaneAxis1() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        SwingTwistConstraintSettings.getPlaneAxis1(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Vec3 getPlaneAxis2() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        SwingTwistConstraintSettings.getPlaneAxis2(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public float getPlaneHalfConeAngle() {
        long settingsVa = this.va();
        float result = SwingTwistConstraintSettings.getPlaneHalfConeAngle(settingsVa);
        return result;
    }

    public RVec3 getPosition1() {
        long settingsVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        SwingTwistConstraintSettings.getPosition1(settingsVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    public RVec3 getPosition2() {
        long settingsVa = this.va();
        DoubleBuffer storeDoubles = Temporaries.doubleBuffer1.get();
        SwingTwistConstraintSettings.getPosition2(settingsVa, storeDoubles);
        RVec3 result = new RVec3(storeDoubles);
        return result;
    }

    public EConstraintSpace getSpace() {
        long settingsVa = this.va();
        int ordinal = SwingTwistConstraintSettings.getSpace(settingsVa);
        EConstraintSpace result = EConstraintSpace.values()[ordinal];
        return result;
    }

    public MotorSettings getSwingMotorSettings() {
        long constraintSettingsVa = this.va();
        long motorSettingsVa = SwingTwistConstraintSettings.getSwingMotorSettings(constraintSettingsVa);
        MotorSettings result = new MotorSettings(this, motorSettingsVa);
        return result;
    }

    public ESwingType getSwingType() {
        long settingsVa = this.va();
        int ordinal = SwingTwistConstraintSettings.getSwingType(settingsVa);
        ESwingType result = ESwingType.values()[ordinal];
        return result;
    }

    public Vec3 getTwistAxis1() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        SwingTwistConstraintSettings.getTwistAxis1(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public Vec3 getTwistAxis2() {
        long settingsVa = this.va();
        FloatBuffer storeFloats = Temporaries.floatBuffer1.get();
        SwingTwistConstraintSettings.getTwistAxis2(settingsVa, storeFloats);
        Vec3 result = new Vec3(storeFloats);
        return result;
    }

    public float getTwistMaxAngle() {
        long settingsVa = this.va();
        float result = SwingTwistConstraintSettings.getTwistMaxAngle(settingsVa);
        return result;
    }

    public float getTwistMinAngle() {
        long settingsVa = this.va();
        float result = SwingTwistConstraintSettings.getTwistMinAngle(settingsVa);
        return result;
    }

    public MotorSettings getTwistMotorSettings() {
        long constraintSettingsVa = this.va();
        long motorSettingsVa = SwingTwistConstraintSettings.getTwistMotorSettings(constraintSettingsVa);
        MotorSettings result = new MotorSettings(this, motorSettingsVa);
        return result;
    }

    public void setMaxFrictionTorque(float torque) {
        long settingsVa = this.va();
        SwingTwistConstraintSettings.setMaxFrictionTorque(settingsVa, torque);
    }

    public void setNormalHalfConeAngle(float angle) {
        long settingsVa = this.va();
        SwingTwistConstraintSettings.setNormalHalfConeAngle(settingsVa, angle);
    }

    public Vec3Arg setPlaneAxis1(Vec3Arg axisDirection) {
        long settingsVa = this.va();
        float dx = axisDirection.getX();
        float dy = axisDirection.getY();
        float dz = axisDirection.getZ();
        SwingTwistConstraintSettings.setPlaneAxis1(settingsVa, dx, dy, dz);
        return axisDirection;
    }

    public Vec3Arg setPlaneAxis2(Vec3Arg axisDirection) {
        long settingsVa = this.va();
        float dx = axisDirection.getX();
        float dy = axisDirection.getY();
        float dz = axisDirection.getZ();
        SwingTwistConstraintSettings.setPlaneAxis2(settingsVa, dx, dy, dz);
        return axisDirection;
    }

    public void setPlaneHalfConeAngle(float angle) {
        long settingsVa = this.va();
        SwingTwistConstraintSettings.setPlaneHalfConeAngle(settingsVa, angle);
    }

    public RVec3Arg setPosition1(RVec3Arg location) {
        long settingsVa = this.va();
        double locX = location.xx();
        double locY = location.yy();
        double locZ = location.zz();
        SwingTwistConstraintSettings.setPosition1(settingsVa, locX, locY, locZ);
        return location;
    }

    public RVec3Arg setPosition2(RVec3Arg location) {
        long settingsVa = this.va();
        double locX = location.xx();
        double locY = location.yy();
        double locZ = location.zz();
        SwingTwistConstraintSettings.setPosition2(settingsVa, locX, locY, locZ);
        return location;
    }

    public void setSpace(EConstraintSpace space) {
        long settingsVa = this.va();
        int ordinal = space.ordinal();
        SwingTwistConstraintSettings.setSpace(settingsVa, ordinal);
    }

    public MotorSettings setSwingMotorSettings(MotorSettings motorSettings) {
        long constraintSettingsVa = this.va();
        long motorSettingsVa = motorSettings.va();
        SwingTwistConstraintSettings.setSwingMotorSettings(constraintSettingsVa, motorSettingsVa);
        return motorSettings;
    }

    public void setSwingType(ESwingType swingType) {
        long settingsVa = this.va();
        int ordinal = swingType.ordinal();
        SwingTwistConstraintSettings.setSwingType(settingsVa, ordinal);
    }

    public Vec3Arg setTwistAxis1(Vec3Arg axisDirection) {
        long settingsVa = this.va();
        float dx = axisDirection.getX();
        float dy = axisDirection.getY();
        float dz = axisDirection.getZ();
        SwingTwistConstraintSettings.setTwistAxis1(settingsVa, dx, dy, dz);
        return axisDirection;
    }

    public Vec3Arg setTwistAxis2(Vec3Arg axisDirection) {
        long settingsVa = this.va();
        float dx = axisDirection.getX();
        float dy = axisDirection.getY();
        float dz = axisDirection.getZ();
        SwingTwistConstraintSettings.setTwistAxis2(settingsVa, dx, dy, dz);
        return axisDirection;
    }

    public void setTwistMaxAngle(float angle) {
        long settingsVa = this.va();
        SwingTwistConstraintSettings.setTwistMaxAngle(settingsVa, angle);
    }

    public void setTwistMinAngle(float angle) {
        long settingsVa = this.va();
        SwingTwistConstraintSettings.setTwistMinAngle(settingsVa, angle);
    }

    public MotorSettings setTwistMotorSettings(MotorSettings motorSettings) {
        long constraintSettingsVa = this.va();
        long motorSettingsVa = motorSettings.va();
        SwingTwistConstraintSettings.setTwistMotorSettings(constraintSettingsVa, motorSettingsVa);
        return motorSettings;
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native float getMaxFrictionTorque(long var0);

    private static native float getNormalHalfConeAngle(long var0);

    private static native void getPlaneAxis1(long var0, FloatBuffer var2);

    private static native void getPlaneAxis2(long var0, FloatBuffer var2);

    private static native float getPlaneHalfConeAngle(long var0);

    private static native void getPosition1(long var0, DoubleBuffer var2);

    private static native void getPosition2(long var0, DoubleBuffer var2);

    private static native int getSpace(long var0);

    private static native long getSwingMotorSettings(long var0);

    private static native int getSwingType(long var0);

    private static native void getTwistAxis1(long var0, FloatBuffer var2);

    private static native void getTwistAxis2(long var0, FloatBuffer var2);

    private static native float getTwistMaxAngle(long var0);

    private static native float getTwistMinAngle(long var0);

    private static native long getTwistMotorSettings(long var0);

    private static native void setMaxFrictionTorque(long var0, float var2);

    private static native void setNormalHalfConeAngle(long var0, float var2);

    private static native void setPlaneAxis1(long var0, float var2, float var3, float var4);

    private static native void setPlaneAxis2(long var0, float var2, float var3, float var4);

    private static native void setPlaneHalfConeAngle(long var0, float var2);

    private static native void setPosition1(long var0, double var2, double var4, double var6);

    private static native void setPosition2(long var0, double var2, double var4, double var6);

    private static native void setSpace(long var0, int var2);

    private static native void setSwingMotorSettings(long var0, long var2);

    private static native void setSwingType(long var0, int var2);

    private static native void setTwistAxis1(long var0, float var2, float var3, float var4);

    private static native void setTwistAxis2(long var0, float var2, float var3, float var4);

    private static native void setTwistMaxAngle(long var0, float var2);

    private static native void setTwistMinAngle(long var0, float var2);

    private static native void setTwistMotorSettings(long var0, long var2);
}

