/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.ConvexShapeSettings;
import com.github.stephengold.joltjni.PhysicsMaterial;
import com.github.stephengold.joltjni.enumerate.EShapeSubType;

public class TaperedCylinderShapeSettings
extends ConvexShapeSettings {
    public TaperedCylinderShapeSettings() {
        long settingsVa = TaperedCylinderShapeSettings.createDefault();
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.TaperedCylinder);
    }

    public TaperedCylinderShapeSettings(float halfHeight, float topRadius, float bottomRadius) {
        this(halfHeight, topRadius, bottomRadius, 0.05f);
    }

    public TaperedCylinderShapeSettings(float halfHeight, float topRadius, float bottomRadius, float convexRadius) {
        this(halfHeight, topRadius, bottomRadius, convexRadius, null);
    }

    public TaperedCylinderShapeSettings(float halfHeight, float topRadius, float bottomRadius, float convexRadius, PhysicsMaterial material) {
        long materialVa = material == null ? 0L : material.va();
        long settingsVa = TaperedCylinderShapeSettings.createShapeSettings(halfHeight, topRadius, bottomRadius, convexRadius, materialVa);
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.TaperedCylinder);
    }

    TaperedCylinderShapeSettings(long settingsVa) {
        this.setVirtualAddressAsCoOwner(settingsVa, EShapeSubType.TaperedCylinder);
    }

    public TaperedCylinderShapeSettings(TaperedCylinderShapeSettings original) {
        long originalVa = original.va();
        long copyVa = TaperedCylinderShapeSettings.createCopy(originalVa);
        this.setVirtualAddressAsCoOwner(copyVa, EShapeSubType.TaperedCylinder);
    }

    public float getBottomRadius() {
        long settingsVa = this.va();
        float result = TaperedCylinderShapeSettings.getBottomRadius(settingsVa);
        return result;
    }

    public float getConvexRadius() {
        long settingsVa = this.va();
        float result = TaperedCylinderShapeSettings.getConvexRadius(settingsVa);
        return result;
    }

    public float getHalfHeight() {
        long settingsVa = this.va();
        float result = TaperedCylinderShapeSettings.getHalfHeight(settingsVa);
        return result;
    }

    public float getTopRadius() {
        long settingsVa = this.va();
        float result = TaperedCylinderShapeSettings.getTopRadius(settingsVa);
        return result;
    }

    public void setBottomRadius(float radius) {
        long settingsVa = this.va();
        TaperedCylinderShapeSettings.setBottomRadius(settingsVa, radius);
    }

    public void setConvexRadius(float radius) {
        long settingsVa = this.va();
        TaperedCylinderShapeSettings.setConvexRadius(settingsVa, radius);
    }

    public void setHalfHeight(float halfHeight) {
        long settingsVa = this.va();
        TaperedCylinderShapeSettings.setHalfHeight(settingsVa, halfHeight);
    }

    public void setTopRadius(float radius) {
        long settingsVa = this.va();
        TaperedCylinderShapeSettings.setTopRadius(settingsVa, radius);
    }

    private static native long createCopy(long var0);

    private static native long createDefault();

    private static native long createShapeSettings(float var0, float var1, float var2, float var3, long var4);

    private static native float getBottomRadius(long var0);

    private static native float getConvexRadius(long var0);

    private static native float getHalfHeight(long var0);

    private static native float getTopRadius(long var0);

    private static native void setBottomRadius(long var0, float var2);

    private static native void setConvexRadius(long var0, float var2);

    private static native void setHalfHeight(long var0, float var2);

    private static native void setTopRadius(long var0, float var2);
}

