/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.VehicleConstraint;
import com.github.stephengold.joltjni.VehicleController;
import com.github.stephengold.joltjni.VehicleEngine;
import com.github.stephengold.joltjni.readonly.Vec3Arg;

public class TrackedVehicleController
extends VehicleController {
    TrackedVehicleController(VehicleConstraint constraint, long controllerVa) {
        super(constraint, controllerVa);
    }

    public VehicleEngine getEngine() {
        long controllerVa = this.va();
        long engineVa = TrackedVehicleController.getEngine(controllerVa);
        VehicleEngine result = new VehicleEngine(this, engineVa);
        return result;
    }

    public void setDriverInput(float forward, float leftRatio, float rightRatio, float brake) {
        long controllerVa = this.va();
        TrackedVehicleController.setDriverInput(controllerVa, forward, leftRatio, rightRatio, brake);
    }

    public void setRpmMeter(Vec3Arg location, float size) {
        long controllerVa = this.va();
        float locX = location.getX();
        float locY = location.getY();
        float locZ = location.getZ();
        TrackedVehicleController.setRpmMeter(controllerVa, locX, locY, locZ, size);
    }

    private static native long getEngine(long var0);

    private static native void setDriverInput(long var0, float var2, float var3, float var4, float var5);

    private static native void setRpmMeter(long var0, float var2, float var3, float var4, float var5);
}

