/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephengold.joltjni;

import com.github.stephengold.joltjni.Mat44;
import com.github.stephengold.joltjni.Temporaries;
import com.github.stephengold.joltjni.TransformedConvexObject;
import com.github.stephengold.joltjni.Vec3;
import com.github.stephengold.joltjni.readonly.ConstSphere;
import com.github.stephengold.joltjni.readonly.Mat44Arg;
import com.github.stephengold.joltjni.readonly.Vec3Arg;
import java.nio.FloatBuffer;

public class TransformedSphere
extends TransformedConvexObject {
    public TransformedSphere(Mat44Arg transform, ConstSphere sphere) {
        long transformVa = transform.targetVa();
        long sphereVa = sphere.targetVa();
        long objectVa = TransformedSphere.create(transformVa, sphereVa);
        this.setVirtualAddress(objectVa, () -> TransformedSphere.free(objectVa));
    }

    @Override
    public Vec3 getSupport(Vec3Arg direction) {
        long objectVa = this.va();
        FloatBuffer floatBuffer = Temporaries.floatBuffer1.get();
        direction.copyTo(floatBuffer);
        TransformedSphere.getSupport(objectVa, floatBuffer);
        Vec3 result = new Vec3(floatBuffer);
        return result;
    }

    @Override
    public Mat44 getTransform() {
        long objectVa = this.va();
        long resultVa = TransformedSphere.getTransform(objectVa);
        Mat44 result = new Mat44(resultVa, true);
        return result;
    }

    private static native long create(long var0, long var2);

    private static native void free(long var0);

    private static native void getSupport(long var0, FloatBuffer var2);

    private static native long getTransform(long var0);
}

